VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "AddIn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
' Your add-in must implement the add-in interface
' Did you remember to add the Minitab 15.0 Addin Interface to the project references?

' Also, if you want to use the MINITAB objects, remember to add a reference to the Mtb 15.0 Type Library

Implements IMinitabAddin

Private Function IMinitabAddin_GetName() As String
    ' This method returns the friendly name of your add-in
    
    ' Both the name and the description of the add-in are stored in the registry.
    IMinitabAddin_GetName = "Minitab My Menu Add-In"
End Function

Private Function IMinitabAddin_GetDescription() As String
    ' This method returns the description of your add-in
    IMinitabAddin_GetDescription = "Example add-in using the My Menu functionality"
End Function

Private Sub IMinitabAddin_GetMenuItems(ByRef MainMenu As String, ByRef MenuItems() As String, ByRef Flags As Long)
    ' This method returns the text for the main menu and each menu item
    ' You can return "|" to create a menu separator in your menu items
    ' You must Redim the menu items array to fit your number of items

    MainMenu = "&My Menu"
    
    ReDim MenuItems(0 To 4)
    MenuItems(0) = "Describe &column(s)..."
    MenuItems(1) = "Rename active &worksheet..."
    MenuItems(2) = "|"
    MenuItems(3) = "&DOS window"
    MenuItems(4) = "&Geometric Mean and Mean Absolute Difference..."
    
    ' Flags is not currently used
    Flags = 0

End Sub

Private Sub IMinitabAddin_OnConnect(ByVal Hwnd As Long, ByVal App As Object, ByRef Flags As Long)
    ' This method is called as MINITAB is initializing your add-in
    ' The HWND is the handle to the main MINITAB window
    ' The App object is a reference to the MINITAB Automation object
    ' You can hold onto either of these for use in your add-in
    ' Flags is used to tell MINITAB if your add-in has dynamic menus (i.e. should be reloaded each time
    ' MINITAB starts up).  Set Flags to 1 for dynamic menus and 0 for static.

    Set gMTBApp = App

    ' This forces MINITAB to retain all commands (even those run by the interactive user).
    gMTBApp.Options.SaveCommands = True

    ' Static menus
    Flags = 0
End Sub

Private Sub IMinitabAddin_OnDisconnect()
    ' This method is called as MINITAB is closing your add-in
    Set gMTBApp = Nothing
End Sub

Private Function IMinitabAddin_OnDispatchCommand(ByVal Menu As Long) As String
    ' This method is called whenever a user selects one of your menu items
    ' The Menu should be equivalent to the menu item index set in GetMenuItems

    Dim Cmnd As String

    Select Case Menu
        Case 0
            ' Describe column(s)
            Dim lColCt As Long

            ' Fill up list box in dialog with numeric columns in worksheet
            FormDescribe.lstColumns.Clear

            lColCt = gMTBApp.ActiveProject.ActiveWorksheet.Columns.Count

            For i = 1 To lColCt
                ' Only select the numeric columns.
                If gMTBApp.ActiveProject.ActiveWorksheet.Columns.Item(i).DataType = Numeric Then
                    FormDescribe.lstColumns.AddItem gMTBApp.ActiveProject.ActiveWorksheet.Columns(i).SynthesizedName
                End If
            Next

            ' Show the dialog
            FormDescribe.Show 1

            ' The MINITAB command to issue
            If FormDescribe.Tag = "OK" Then
                Dim sTemp As String
                Dim bPrev As Boolean
                
                bPrev = False
                sTemp = "Describe "
                
                For i = 1 To FormDescribe.lstColumns.ListCount
                    FormDescribe.lstColumns.ListIndex = i - 1
                
                    If FormDescribe.lstColumns.Selected(i - 1) Then
                        If bPrev Then
                            sTemp = sTemp & " "
                        End If

                        sTemp = sTemp & FormDescribe.lstColumns.Text
                        bPrev = True
                    End If
                Next

                If FormDescribe.chkMean.Value = 1 Then
                    sTemp = sTemp & ";  Mean"
                End If

                If FormDescribe.chkVariance.Value = 1 Then
                    sTemp = sTemp & ";  Variance"
                End If

                If FormDescribe.chkSum.Value = 1 Then
                    sTemp = sTemp & ";  Sums"
                End If

                If FormDescribe.chkNnonmissing.Value = 1 Then
                    sTemp = sTemp & ";  N"
                End If

                If FormDescribe.chkHistogram.Value = 1 Then
                    sTemp = sTemp & ";  GHist"
                End If

                If FormDescribe.chkBoxplot.Value = 1 Then
                    sTemp = sTemp & ";  GBoxplot"
                End If

                sTemp = sTemp & "."

                ' If you simply want to run a MINITAB command you can either set that string
                ' as the return value for this function, or you can call ExecuteCommand
                
                ' gMTBApp.ActiveProject.ExecuteCommand sTemp

                Cmnd = sTemp
            End If
            
            Unload FormDescribe
        Case 1
            ' Rename active worksheet
    
            Dim sCurrent As String

            sCurrent = gMTBApp.ActiveProject.ActiveWorksheet.Name

            FormRename.txtCurrent.Enabled = True
            FormRename.txtCurrent.Text = sCurrent
            FormRename.txtCurrent.Enabled = False

            ' Show the dialog
            FormRename.Show 1

            If FormRename.Tag = "OK" Then
                gMTBApp.ActiveProject.ActiveWorksheet.Name = FormRename.txtNew.Text
            End If

            Unload FormRename
        Case 3
            ' DOS Window
            Dim sSysDir As String
            Dim sWinDir As String
            Dim lLength As Long
            Dim sDOSPath As String
            Dim DOSID
            Dim hsearch As Long
            Dim findinfo As WIN32_FIND_DATA

            ' Allocate string
            sSysDir = Space(255)
            sWinDir = Space(255)
            
            ' Get path of system directory
            lLength = GetSystemDirectory(sSysDir, 255)

            ' Trim blank space from string
            sSysDir = Left(sSysDir, lLength)

            lLength = GetWindowsDirectory(sWinDir, 255)
            
            sWinDir = Left(sWinDir, lLength)

            sDOSPath = sSysDir & "\cmd.exe"
            hsearch = FindFirstFile(sDOSPath, findinfo)

            ' WinME uses command.com
            ' To be on the safe side, look around for DOS before
            ' giving up.

            If hsearch = -1 Then
                sDOSPath = sSysDir & "\command.com"
                hsearch = FindFirstFile(sDOSPath, findinfo)

                If hsearch = -1 Then
                    sDOSPath = sWinDir & "\cmd.exe"
                    hsearch = FindFirstFile(sDOSPath, findinfo)

                    If hsearch = -1 Then
                        sDOSPath = sWinDir & "\command.com"
                        hsearch = FindFirstFile(sDOSPath, findinfo)
                    End If
                End If
            End If

            ' Open DOS window
            If hsearch = -1 Then
                MsgBox "Cannot locate DOS executable", vbOKOnly, "MyMenu"
            Else
                FindClose (hsearch)
            
                DOSID = Shell(sDOSPath, 1)
            End If
        Case 4
            ' Geometric Mean and Mean Absolute Difference (stored in the worksheet)

            ' Fill up list box in dialog with numeric columns in worksheet
            lColCt = gMTBApp.ActiveProject.ActiveWorksheet.Columns.Count

            For i = 1 To lColCt
                If gMTBApp.ActiveProject.ActiveWorksheet.Columns(i).DataType = Numeric Then
                    Dim sColName As String

                    lNumber = gMTBApp.ActiveProject.ActiveWorksheet.Columns(i).Number

                    sName = gMTBApp.ActiveProject.ActiveWorksheet.Columns(i).SynthesizedName

                    ' Add column name (if it exists)
                    sColName = gMTBApp.ActiveProject.ActiveWorksheet.Columns(i).Name

                    If sColName <> sName Then
                        sName = sName & "  "
                        sName = sName & sColName
                    End If

                    FormGeoMean.Combo1.AddItem sName
                    FormGeoMean.Combo2.AddItem Str(i)
                End If
            
            Next

            ' Show the dialog
            FormGeoMean.Show 1

            If FormGeoMean.Tag = "OK" Then
                ' Get data from column and pass it to function to do calculations

                Dim MTBColumn As Mtb.Column
                Set MTBColumn = gMTBApp.ActiveProject.ActiveWorksheet.Columns(CLng(FormGeoMean.Combo2.Text))

                Dim dData() As Double
                ReDim dData(MTBColumn.RowCount)

                dData = MTBColumn.GetData()

                Dim dGeoMean As Double
                Dim bSuccess As Boolean

                ' FindGeoMean takes an array of doubles and returns the geometric mean.
                ' bSuccess indicates if the calculations were completed.
                dGeoMean = FindGeoMean(dData, bSuccess)

                If bSuccess = True Then
                    ' Mean Absolute Difference
                    Dim dMAD As Double

                    dMAD = FindMAD(dData)

                    ' Store both values in the first available column.
                    Dim StorageCol As Mtb.Column
                    Set StorageCol = gMTBApp.ActiveProject.ActiveWorksheet.Columns.Add

                    StorageCol.SetData dGeoMean, 1, 1
                    StorageCol.SetData dMAD, 2, 1

                    StorageCol.Name = "MyResults"
                Else
                    ' An error occurred.
                    gMTBApp.ActiveProject.ExecuteCommand "NOTE ** Error ** Cannot compute statistics."
                End If

            End If
            
            Unload FormGeoMean
    End Select

    IMinitabAddin_OnDispatchCommand = Cmnd
End Function

Private Sub IMinitabAddin_OnNotify(ByVal NotifyType As AddinNotifyType)
    ' This method is called when MINITAB notifies your add-in that something has changed.
    ' Use the NotifyType to figure out what changed
    
    ' MINITAB currently fires no events, so this method is not called.
End Sub

Private Function IMinitabAddin_QueryCustomCommand(ByVal Cmnd As String) As Boolean
    ' This method is called when Minitab asks your Addin if it supports a custom command
    ' The Cmnd is the name of the custom command.  Return True if you support the command

    If UCase(Cmnd) = "EXPLORER" Or UCase(Cmnd) = "CLEAR" Then
        IMinitabAddin_QueryCustomCommand = True
    Else
        IMinitabAddin_QueryCustomCommand = False
    End If

End Function

Private Sub IMinitabAddin_ExecuteCustomCommand(ByVal Cmnd As String, ByRef Args() As String)
    ' This method is called when Minitab asks your Addin to execute a custom command
    ' The Cmnd is the name of the command and Args is an array of arguments
    If UCase(Cmnd) = "EXPLORER" Then
        ' Open Windows Explorer

        Dim sWinDir As String
        Dim lLength As Long
        Dim sExplorerPath As String
        Dim ExplorerID

        ' Allocate string
        sWinDir = Space(255)
        
        ' Get path of windows directory
        lLength = GetWindowsDirectory(sWinDir, 255)
        
        ' Trim blank space from string
        sWinDir = Left(sWinDir, lLength)

        sExplorerPath = sWinDir & "\explorer.exe"

        ' Open explorer window
        ExplorerID = Shell(sExplorerPath, 1)
        AppActivate ExplorerID

    ElseIf UCase(Cmnd) = "CLEAR" Then
        ' Clear indicated columns
        Dim lColCt As Long

        lColCt = gMTBApp.ActiveProject.ActiveWorksheet.Columns.Count()
    
        For Each Arg In Args
            For i = 1 To lColCt
                If gMTBApp.ActiveProject.ActiveWorksheet.Columns.Item(i).Number = Arg Then
                    gMTBApp.ActiveProject.ActiveWorksheet.Columns.Item(i).Clear
                End If
            Next
        Next
    End If

End Sub
