Attribute VB_Name = "Module1"
Global gMTBApp As Mtb.Application

' The following type and function declarations are imported from the WindowsAPI.
' Use at your own risk.

Type FILETIME
  dwLowDateTime As Long
  dwHighDateTime As Long
End Type

Type WIN32_FIND_DATA
  dwFileAttributes As Long
  ftCreationTime As FILETIME
  ftLastAccessTime As FILETIME
  ftLastWriteTime As FILETIME
  nFileSizeHigh As Long
  nFileSizeLow As Long
  dwReserved0 As Long
  dwReserved1 As Long
  cFileName As String * 260
  cAlternate As String * 14
End Type

Declare Function GetSystemDirectory Lib "kernel32.dll" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Declare Function GetWindowsDirectory Lib "kernel32.dll" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Declare Function FindFirstFile Lib "kernel32.dll" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Declare Function FindClose Lib "kernel32.dll" (ByVal hFindFile As Long) As Long

' Helper functions to compute statistics.

Public Function FindGeoMean(ByRef dData() As Double, ByRef bSuccess As Boolean) As Double
    ' Find geometric mean.

    Dim dGeoMean As Double
    Dim dValue
    Dim iCount As Integer
    Dim dSum As Double

    iCount = 0
    dSum = 0

    bSuccess = True

    For Each dValue In dData
        If dValue <= 0 Then
            bSuccess = False
            Exit Function
        End If

        dSum = dSum + Log(dValue)
        iCount = iCount + 1
    Next

    dGeoMean = Exp(dSum / iCount)

    FindGeoMean = dGeoMean

End Function
Public Function FindMAD(ByRef dData() As Double) As Double
    ' Find mean absolute difference.

    Dim dMAD As Double
    Dim dValue
    Dim iCount As Integer
    Dim dSum As Double
    Dim dMean As Double

    iCount = 0
    dSum = 0

    For Each dValue In dData
        dSum = dSum + dValue
        iCount = iCount + 1
    Next

    dMean = dSum / iCount

    For Each dValue In dData
        dMAD = dMAD + Abs(dValue - dMean)
    Next

    dMAD = dMAD / iCount

    FindMAD = dMAD

End Function
