/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.util;

import ch.epfl.lamp.compiler.msil.PEFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Table {
    public static final int MAX_NUMBER = 64;
    public static final long VALID_TABLES_MASK = 4394820566871L;
    public static final int TABLE_SET_LENGTH = 13;
    public static final int _TypeDefOrRef = 0;
    public static final int _HasConstant = 1;
    public static final int _HasCustomAttribute = 2;
    public static final int _HasFieldMarshal = 3;
    public static final int _HasDeclSecurity = 4;
    public static final int _MemberRefParent = 5;
    public static final int _HasSemantics = 6;
    public static final int _MethodDefOrRef = 7;
    public static final int _MemberForwarded = 8;
    public static final int _Implementation = 9;
    public static final int _CustomAttributeType = 10;
    public static final int _ResolutionScope = 11;
    public static final int _TypeOrMethodDef = 12;
    public static final int[][] TableSet = new int[13][];
    public static final int[] NoBits;
    private static final String[] tableName;
    public final int rows;
    public final int id;
    protected final PEFile file;
    protected ByteBuffer buffer;
    protected boolean newMapping = false;
    public final boolean isShort;
    private int rowSize = -1;
    private long start = -1L;
    private int currentRow = 0;

    public static int getMask(int tableSetId) {
        return (1 << NoBits[tableSetId]) - 1;
    }

    public static int getTableId(int tableSet, int index) {
        return TableSet[tableSet][index & Table.getMask(tableSet)];
    }

    public static int getTableIndex(int tableSet, int index) {
        return index >> NoBits[tableSet];
    }

    public static int encodeIndex(int index, int tableSetId, int tableId) {
        int[] tableSet = TableSet[tableSetId];
        for (int i = 0; i < tableSet.length; ++i) {
            if (tableSet[i] != tableId) continue;
            return index << NoBits[tableSetId] | i;
        }
        throw new RuntimeException("Cannot find table #" + tableId + " in table set #" + tableSetId);
    }

    public static Table newTable(PEFile file, int id, int rows) {
        Table table2 = null;
        switch (id) {
            case 0: {
                table2 = new ModuleDef(file, rows);
                break;
            }
            case 1: {
                table2 = new TypeRef(file, rows);
                break;
            }
            case 2: {
                table2 = new TypeDef(file, rows);
                break;
            }
            case 3: {
                table2 = new FieldTrans(file, rows);
                break;
            }
            case 4: {
                table2 = new FieldDef(file, rows);
                break;
            }
            case 5: {
                table2 = new MethodTrans(file, rows);
                break;
            }
            case 6: {
                table2 = new MethodDef(file, rows);
                break;
            }
            case 8: {
                table2 = new ParamDef(file, rows);
                break;
            }
            case 9: {
                table2 = new InterfaceImpl(file, rows);
                break;
            }
            case 10: {
                table2 = new MemberRef(file, rows);
                break;
            }
            case 11: {
                table2 = new Constant(file, rows);
                break;
            }
            case 12: {
                table2 = new CustomAttribute(file, rows);
                break;
            }
            case 13: {
                table2 = new FieldMarshal(file, rows);
                break;
            }
            case 14: {
                table2 = new DeclSecurity(file, rows);
                break;
            }
            case 15: {
                table2 = new ClassLayout(file, rows);
                break;
            }
            case 16: {
                table2 = new FieldLayout(file, rows);
                break;
            }
            case 17: {
                table2 = new StandAloneSig(file, rows);
                break;
            }
            case 18: {
                table2 = new EventMap(file, rows);
                break;
            }
            case 20: {
                table2 = new EventDef(file, rows);
                break;
            }
            case 21: {
                table2 = new PropertyMap(file, rows);
                break;
            }
            case 23: {
                table2 = new PropertyDef(file, rows);
                break;
            }
            case 24: {
                table2 = new MethodSemantics(file, rows);
                break;
            }
            case 25: {
                table2 = new MethodImpl(file, rows);
                break;
            }
            case 26: {
                table2 = new ModuleRef(file, rows);
                break;
            }
            case 27: {
                table2 = new TypeSpec(file, rows);
                break;
            }
            case 28: {
                table2 = new ImplMap(file, rows);
                break;
            }
            case 29: {
                table2 = new FieldRVA(file, rows);
                break;
            }
            case 32: {
                table2 = new AssemblyDef(file, rows);
                break;
            }
            case 33: {
                table2 = new AssemblyProcessor(file, rows);
                break;
            }
            case 34: {
                table2 = new AssemblyOS(file, rows);
                break;
            }
            case 35: {
                table2 = new AssemblyRef(file, rows);
                break;
            }
            case 36: {
                table2 = new AssemblyRefProcessor(file, rows);
                break;
            }
            case 37: {
                table2 = new AssemblyRefOS(file, rows);
                break;
            }
            case 38: {
                table2 = new FileDef(file, rows);
                break;
            }
            case 39: {
                table2 = new ExportedType(file, rows);
                break;
            }
            case 40: {
                table2 = new ManifestResource(file, rows);
                break;
            }
            case 41: {
                table2 = new NestedClass(file, rows);
                break;
            }
            case 42: {
                table2 = new GenericParam(file, rows);
                break;
            }
            case 43: {
                table2 = new MethodSpec(file, rows);
                break;
            }
            case 44: {
                table2 = new GenericParamConstraint(file, rows);
                break;
            }
            default: {
                table2 = new Empty(id);
            }
        }
        return table2;
    }

    protected Table(PEFile file, int id, int rows) {
        this.file = file;
        this.id = id;
        this.rows = rows;
        this.isShort = rows < 65536;
    }

    public final long init(long start) {
        if (this.rows < 1) {
            return start;
        }
        if (this.start != -1L) {
            throw new RuntimeException("Cannot re-initialize table '" + this.getTableName() + "'");
        }
        this.start = start;
        this.rowSize = this.getRowSize();
        int size2 = this.rows * this.rowSize();
        this.buffer = this.newMapping ? this.file.mapBuffer(start, size2) : this.file.getBuffer(start, size2);
        return start + (long)size2;
    }

    public final String getTableName() {
        return 0 <= this.id && this.id < 64 ? tableName[this.id] : "<NoTable>";
    }

    public final int rowSize() {
        return this.rowSize;
    }

    public void load() {
        if (this.buffer instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.buffer).load();
        }
    }

    public final int readByte() {
        return this.buffer.get() + 256 & 0xFF;
    }

    public final int readShort() {
        return this.buffer.getShort() + 65536 & 0xFFFF;
    }

    public final int readInt() {
        return this.buffer.getInt();
    }

    public final int readStringIndex() {
        return this.file.StringIsShort ? this.readShort() : this.readInt();
    }

    public final int readBlobIndex() {
        return this.file.BlobIsShort ? this.readShort() : this.readInt();
    }

    public final int readGUIDIndex() {
        return this.file.GUIDIsShort ? this.readShort() : this.readInt();
    }

    public final int readTableIndex(int tableId) {
        return this.file.getTable((int)tableId).isShort ? this.readShort() : this.readInt();
    }

    public final int readTableSetIndex(int tableSetId) {
        return this.file.indexSize[tableSetId] == 2 ? this.readShort() : this.readInt();
    }

    public final void readRow(int row) {
        this.seekRow(row);
        int lastSeek = this.buffer.position();
        this.populateFields();
        int rowSizeRead = this.buffer.position() - lastSeek;
        if (rowSizeRead != this.rowSize()) {
            throw new RuntimeException("Table ID=0x" + PEFile.byte2hex(this.id) + ": read row size = " + rowSizeRead + "; expected row size = " + this.rowSize());
        }
        this.currentRow = row;
    }

    protected final void seekRow(int row) {
        assert (row > 0 && row <= this.rows) : "Index " + row + " is not within the table with #rows = " + this.rows;
        this.buffer.position((row - 1) * this.rowSize());
    }

    public final int currentRow() {
        return this.currentRow;
    }

    public final void nextRow() {
        this.readRow(this.currentRow() + 1);
    }

    protected abstract void populateFields();

    protected abstract int getRowSize();

    static {
        Table.TableSet[0] = new int[]{2, 1, 27};
        Table.TableSet[1] = new int[]{4, 8, 23};
        Table.TableSet[2] = new int[]{6, 4, 1, 2, 8, 9, 10, 0, -1, 23, 20, -1, 26, 27, 32, 35, 38, 39, 40};
        Table.TableSet[3] = new int[]{4, 8};
        Table.TableSet[4] = new int[]{2, 6, 32};
        Table.TableSet[5] = new int[]{-1, 1, 26, 6, 27};
        Table.TableSet[6] = new int[]{20, 23};
        Table.TableSet[7] = new int[]{6, 10};
        Table.TableSet[8] = new int[]{4, 6};
        Table.TableSet[9] = new int[]{38, 35, 39};
        Table.TableSet[10] = new int[]{-1, -1, 6, 10, -1};
        Table.TableSet[11] = new int[]{0, 26, 35, 1};
        Table.TableSet[12] = new int[]{2, 6};
        NoBits = new int[]{2, 2, 5, 1, 2, 3, 1, 1, 1, 2, 3, 2, 1};
        tableName = new String[]{"Module", "TypeRef", "TypeDef", "   FieldTrans", "Field", "MethodTrans", "Method", "", "Param", "InterfaceImpl", "MemberRef", "Constant", "CustomAttribute", "FieldMarshal", "DeclSecurity", "ClassLayout", "FieldLayout", "StandAloneSig", "EventMap", "", "Event", "PropertyMap", "", "Property", "MethodSemantics", "MethodImpl", "ModuleRef", "TypeSpec", "ImplMap", "FieldRVA", "", "", "Assembly", "AssemblyProcessor", "AssemblyOS", "AssemblyRef", "AssemblyRefProcessor", "AssemblyRefOS", "File", "ExportedType", "ManifestResource", "NestedClass", "GenericParam", "MethodSpec", "GenericParamConstraint", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
    }

    public static final class AssemblyDef
    extends Table {
        public static final int ID = 32;
        public int HashAlgId;
        public int MajorVersion;
        public int MinorVersion;
        public int BuildNumber;
        public int RevisionNumber;
        public int Flags;
        public int PublicKey;
        public int Name;
        public int Culture;

        public AssemblyDef(PEFile file, int rows) {
            super(file, 32, rows);
        }

        @Override
        protected void populateFields() {
            this.HashAlgId = this.readInt();
            this.MajorVersion = this.readShort();
            this.MinorVersion = this.readShort();
            this.BuildNumber = this.readShort();
            this.RevisionNumber = this.readShort();
            this.Flags = this.readInt();
            this.PublicKey = this.readBlobIndex();
            this.Name = this.readStringIndex();
            this.Culture = this.readStringIndex();
        }

        @Override
        protected int getRowSize() {
            return 16 + this.file.getBlobIndexSize() + 2 * this.file.getStringIndexSize();
        }
    }

    public static final class AssemblyOS
    extends Table {
        public static final int ID = 34;
        public int OSPlatformID;
        public int OSMajorVersion;
        public int OSMinorVersion;

        public AssemblyOS(PEFile file, int rows) {
            super(file, 34, rows);
        }

        @Override
        protected void populateFields() {
            this.OSPlatformID = this.readInt();
            this.OSMajorVersion = this.readInt();
            this.OSMinorVersion = this.readInt();
        }

        @Override
        protected int getRowSize() {
            return 12;
        }
    }

    public static final class AssemblyProcessor
    extends Table {
        public static final int ID = 33;
        public int Processor;

        public AssemblyProcessor(PEFile file, int rows) {
            super(file, 33, rows);
        }

        @Override
        protected void populateFields() {
            this.Processor = this.readInt();
        }

        @Override
        protected int getRowSize() {
            return 4;
        }
    }

    public static final class AssemblyRef
    extends Table {
        public static final int ID = 35;
        public int MajorVersion;
        public int MinorVersion;
        public int BuildNumber;
        public int RevisionNumber;
        public int Flags;
        public int PublicKeyOrToken;
        public int Name;
        public int Culture;
        public int HashValue;

        public AssemblyRef(PEFile file, int rows) {
            super(file, 35, rows);
        }

        @Override
        protected void populateFields() {
            this.MajorVersion = this.readShort();
            this.MinorVersion = this.readShort();
            this.BuildNumber = this.readShort();
            this.RevisionNumber = this.readShort();
            this.Flags = this.readInt();
            this.PublicKeyOrToken = this.readBlobIndex();
            this.Name = this.readStringIndex();
            this.Culture = this.readStringIndex();
            this.HashValue = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 12 + 2 * this.file.getBlobIndexSize() + 2 * this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class AssemblyRefOS
    extends Table {
        public static final int ID = 37;
        public int OSPlatformId;
        public int OSMajorVersion;
        public int OSMinorVersion;
        public int AssemblyRef;

        public AssemblyRefOS(PEFile file, int rows) {
            super(file, 37, rows);
        }

        @Override
        protected void populateFields() {
            this.OSPlatformId = this.readInt();
            this.OSMajorVersion = this.readInt();
            this.OSMinorVersion = this.readInt();
            this.AssemblyRef = this.readTableIndex(35);
        }

        @Override
        protected int getRowSize() {
            return 12 + this.file.getTableIndexSize(35);
        }
    }

    public static final class AssemblyRefProcessor
    extends Table {
        public static final int ID = 36;
        public int Processor;
        public int AssemblyRef;

        public AssemblyRefProcessor(PEFile file, int rows) {
            super(file, 36, rows);
        }

        @Override
        protected void populateFields() {
            this.Processor = this.readInt();
            this.AssemblyRef = this.readTableIndex(35);
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(35);
        }
    }

    public static final class ClassLayout
    extends Table {
        public static final int ID = 15;
        public int PackingSize;
        public int ClassSize;
        public int Parent;

        public ClassLayout(PEFile file, int rows) {
            super(file, 15, rows);
        }

        @Override
        protected void populateFields() {
            this.PackingSize = this.readShort();
            this.ClassSize = this.readInt();
            this.Parent = this.readTableIndex(2);
        }

        @Override
        protected int getRowSize() {
            return 6 + this.file.getTableIndexSize(2);
        }
    }

    public static final class Constant
    extends Table {
        public static final int ID = 11;
        public int Type;
        public int Parent;
        public int Value;

        public Constant(PEFile file, int rows) {
            super(file, 11, rows);
        }

        @Override
        protected void populateFields() {
            this.Type = this.readShort();
            this.Parent = this.readTableSetIndex(1);
            this.Value = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(1) + this.file.getBlobIndexSize();
        }

        public Object getValue() {
            if (this.Type == 18) {
                return null;
            }
            return this.file.Blob.getConstant(this.Type, this.Value);
        }
    }

    public static final class CustomAttribute
    extends Table {
        public static final int ID = 12;
        public int Parent;
        public int Type;
        public int Value;

        public CustomAttribute(PEFile file, int rows) {
            super(file, 12, rows);
        }

        @Override
        protected void populateFields() {
            this.Parent = this.readTableSetIndex(2);
            this.Type = this.readTableSetIndex(10);
            this.Value = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableSetIndexSize(2) + this.file.getTableSetIndexSize(10) + this.file.getBlobIndexSize();
        }

        public byte[] getValue() {
            return this.Value == 0 ? null : this.file.getBlob(this.Value);
        }
    }

    public static final class DeclSecurity
    extends Table {
        public static final int ID = 14;
        public int Action;
        public int Parent;
        public int PermissionSet;

        public DeclSecurity(PEFile file, int rows) {
            super(file, 14, rows);
        }

        @Override
        protected void populateFields() {
            this.Action = this.readShort();
            this.Parent = this.readTableSetIndex(4);
            this.PermissionSet = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(4) + this.file.getBlobIndexSize();
        }
    }

    private static final class Empty
    extends Table {
        public Empty(int id) {
            super(null, id, 0);
        }

        @Override
        protected int getRowSize() {
            return 0;
        }

        @Override
        protected void populateFields() {
            throw new RuntimeException("Table 0x" + PEFile.byte2hex(this.id));
        }
    }

    public static final class EventDef
    extends Table {
        public static final int ID = 20;
        public int EventFlags;
        public int Name;
        public int EventType;

        public EventDef(PEFile file, int rows) {
            super(file, 20, rows);
        }

        @Override
        protected void populateFields() {
            this.EventFlags = this.readShort();
            this.Name = this.readStringIndex();
            this.EventType = this.readTableSetIndex(0);
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getTableSetIndexSize(0);
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class EventMap
    extends Table {
        public static final int ID = 18;
        public int Parent;
        public int EventList;

        public EventMap(PEFile file, int rows) {
            super(file, 18, rows);
        }

        @Override
        protected void populateFields() {
            this.Parent = this.readTableIndex(2);
            this.EventList = this.readTableIndex(20);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableIndexSize(20);
        }
    }

    public static final class ExportedType
    extends Table {
        public static final int ID = 39;
        public int Flags;
        public int TypeDefId;
        public int TypeName;
        public int TypeNamespace;
        public int Implementation;

        public ExportedType(PEFile file, int rows) {
            super(file, 39, rows);
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readInt();
            this.TypeDefId = this.readInt();
            this.TypeName = this.readStringIndex();
            this.TypeNamespace = this.readStringIndex();
            this.Implementation = this.readTableSetIndex(9);
        }

        @Override
        protected int getRowSize() {
            return 8 + 2 * this.file.getStringIndexSize() + this.file.getTableSetIndexSize(9);
        }

        public String getFullName() {
            String namespace = this.file.getString(this.TypeNamespace);
            return namespace.length() == 0 ? this.file.getString(this.TypeName) : namespace + "." + this.file.getString(this.TypeName);
        }
    }

    public static final class FieldDef
    extends Table {
        public static final int ID = 4;
        public int Flags;
        public int Name;
        public int Signature;

        public FieldDef(PEFile file, int rows) {
            super(file, 4, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class FieldLayout
    extends Table {
        public static final int ID = 16;
        public int Offset;
        public int Field;

        public FieldLayout(PEFile file, int rows) {
            super(file, 16, rows);
        }

        @Override
        protected void populateFields() {
            this.Offset = this.readInt();
            this.Field = this.readTableIndex(4);
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(4);
        }
    }

    public static final class FieldMarshal
    extends Table {
        public static final int ID = 13;
        public int Parent;
        public int NativeType;

        public FieldMarshal(PEFile file, int rows) {
            super(file, 13, rows);
        }

        @Override
        protected void populateFields() {
            this.Parent = this.readTableSetIndex(3);
            this.NativeType = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableSetIndexSize(3) + this.file.getBlobIndexSize();
        }
    }

    public static final class FieldRVA
    extends Table {
        public static final int ID = 29;
        public int RVA;
        public int Field;

        public FieldRVA(PEFile file, int rows) {
            super(file, 29, rows);
        }

        @Override
        protected void populateFields() {
            this.RVA = this.readInt();
            this.Field = this.readTableIndex(4);
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getTableIndexSize(4);
        }
    }

    public static final class FieldTrans
    extends Table {
        public static final int ID = 3;
        public int Field;

        public FieldTrans(PEFile file, int rows) {
            super(file, 3, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Field = this.readTableIndex(4);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(4);
        }
    }

    public static final class FileDef
    extends Table {
        public static final int ID = 38;
        public int Flags;
        public int Name;
        public int HashValue;

        public FileDef(PEFile file, int rows) {
            super(file, 38, rows);
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.HashValue = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class GenericParam
    extends Table {
        public static final int ID = 42;
        public int Number;
        public int Flags;
        public int Owner;
        public int Name;
        private Map GenericParamIdxesForMethodDefIdx = new HashMap();
        private Map GenericParamIdxesForTypeDefIdx = new HashMap();
        private boolean mapsPopulated = false;

        private void addToMap(int key, int value, Map IdxesForIdx) {
            HashSet<Integer> bucket = (HashSet<Integer>)IdxesForIdx.get(key);
            if (bucket == null) {
                bucket = new HashSet<Integer>();
                IdxesForIdx.put(key, bucket);
            }
            bucket.add(value);
        }

        public int[] getTVarIdxes(int TypeDefIdx) {
            Set bucket;
            if (!this.mapsPopulated) {
                this.initMaps();
            }
            if ((bucket = (Set)this.GenericParamIdxesForTypeDefIdx.get(TypeDefIdx)) == null) {
                bucket = Collections.EMPTY_SET;
            }
            int[] res = new int[bucket.size()];
            Iterator it = bucket.iterator();
            for (int i = 0; i < bucket.size(); ++i) {
                res[i] = (Integer)it.next();
            }
            return res;
        }

        public int[] getMVarIdxes(int MethodDefIdx) {
            Set bucket;
            if (!this.mapsPopulated) {
                this.initMaps();
            }
            if ((bucket = (Set)this.GenericParamIdxesForMethodDefIdx.get(MethodDefIdx)) == null) {
                bucket = Collections.EMPTY_SET;
            }
            int[] res = new int[bucket.size()];
            Iterator it = bucket.iterator();
            for (int i = 0; i < bucket.size(); ++i) {
                res[i] = (Integer)it.next();
            }
            return res;
        }

        private void initMaps() {
            this.mapsPopulated = true;
            for (int currentParamRow = 1; currentParamRow <= this.rows; ++currentParamRow) {
                int currentOwner = this.file.GenericParam((int)currentParamRow).Owner;
                int targetTableId = Table.getTableId(12, currentOwner);
                int targetRow = currentOwner >> NoBits[12];
                if (targetTableId == 2) {
                    this.addToMap(targetRow, currentParamRow, this.GenericParamIdxesForTypeDefIdx);
                    continue;
                }
                if (targetTableId == 6) {
                    this.addToMap(targetRow, currentParamRow, this.GenericParamIdxesForMethodDefIdx);
                    continue;
                }
                throw new RuntimeException();
            }
        }

        public GenericParam(PEFile file, int rows) {
            super(file, 42, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Number = this.readShort();
            this.Flags = this.readShort();
            this.Owner = this.readTableSetIndex(12);
            this.Name = this.readStringIndex();
        }

        public boolean isInvariant() {
            return (this.Flags & 3) == 0;
        }

        public boolean isCovariant() {
            return (this.Flags & 3) == 1;
        }

        public boolean isContravariant() {
            return (this.Flags & 3) == 2;
        }

        public boolean isReferenceType() {
            return (this.Flags & 0x1C) == 4;
        }

        public boolean isValueType() {
            return (this.Flags & 0x1C) == 8;
        }

        public boolean hasDefaultConstructor() {
            return (this.Flags & 0x1C) == 16;
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getTableSetIndexSize(12) + this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class GenericParamConstraint
    extends Table {
        public static final int ID = 44;
        public int Owner;
        public int Constraint;
        private boolean mapPopulated = false;
        private Map TypeDefOrRefIdxesForGenParamIdx = new HashMap();

        public GenericParamConstraint(PEFile file, int rows) {
            super(file, 44, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Owner = this.readTableIndex(42);
            this.Constraint = this.readTableSetIndex(0);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(42) + this.file.getTableSetIndexSize(0);
        }

        public int[] getTypeDefOrRefIdxes(int genParamIdx) {
            Set bucket;
            if (!this.mapPopulated) {
                this.initMap();
            }
            if ((bucket = (Set)this.TypeDefOrRefIdxesForGenParamIdx.get(genParamIdx)) == null) {
                bucket = Collections.EMPTY_SET;
            }
            int[] res = new int[bucket.size()];
            Iterator it = bucket.iterator();
            for (int i = 0; i < bucket.size(); ++i) {
                res[i] = (Integer)it.next();
            }
            return res;
        }

        private void initMap() {
            this.mapPopulated = true;
            for (int currentConstraintRow = 1; currentConstraintRow <= this.rows; ++currentConstraintRow) {
                int targetGenericParam = this.file.GenericParamConstraint((int)currentConstraintRow).Owner;
                int value = this.file.GenericParamConstraint.Constraint;
                this.addToMap(targetGenericParam, value);
            }
        }

        private void addToMap(int key, int value) {
            HashSet<Integer> bucket = (HashSet<Integer>)this.TypeDefOrRefIdxesForGenParamIdx.get(key);
            if (bucket == null) {
                bucket = new HashSet<Integer>();
                this.TypeDefOrRefIdxesForGenParamIdx.put(key, bucket);
            }
            bucket.add(value);
        }
    }

    public static final class ImplMap
    extends Table {
        public static final int ID = 28;
        public int MappingFlags;
        public int MemberForwarded;
        public int ImportName;
        public int ImportScope;

        public ImplMap(PEFile file, int rows) {
            super(file, 28, rows);
        }

        @Override
        protected void populateFields() {
            this.MappingFlags = this.readShort();
            this.MemberForwarded = this.readTableSetIndex(8);
            this.ImportName = this.readStringIndex();
            this.ImportScope = this.readTableIndex(26);
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getTableSetIndexSize(8) + this.file.getStringIndexSize() + this.file.getTableIndexSize(26);
        }
    }

    public static final class InterfaceImpl
    extends Table {
        public static final int ID = 9;
        public int Class;
        public int Interface;

        public InterfaceImpl(PEFile file, int rows) {
            super(file, 9, rows);
        }

        @Override
        protected void populateFields() {
            this.Class = this.readTableIndex(2);
            this.Interface = this.readTableSetIndex(0);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableSetIndexSize(0);
        }

        public int findType(int targetIndex) {
            for (int i = 1; i <= this.rows; ++i) {
                this.seekRow(i);
                if (targetIndex != this.readTableIndex(2)) continue;
                return i;
            }
            return 0;
        }
    }

    public static final class ManifestResource
    extends Table {
        public static final int ID = 40;
        public int Offset;
        public int Flags;
        public int Name;
        public int Implementation;

        public ManifestResource(PEFile file, int rows) {
            super(file, 40, rows);
        }

        @Override
        protected void populateFields() {
            this.Offset = this.readInt();
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.Implementation = this.readTableSetIndex(9);
        }

        @Override
        protected int getRowSize() {
            return 8 + this.file.getStringIndexSize() + this.file.getTableSetIndexSize(9);
        }
    }

    public static final class MemberRef
    extends Table {
        public static final int ID = 10;
        public int Class;
        public int Name;
        public int Signature;

        public MemberRef(PEFile file, int rows) {
            super(file, 10, rows);
        }

        @Override
        protected void populateFields() {
            this.Class = this.readTableSetIndex(5);
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableSetIndexSize(5) + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class MethodDef
    extends Table {
        public static final int ID = 6;
        public int RVA;
        public int ImplFlags;
        public int Flags;
        public int Name;
        public int Signature;
        public int ParamList;

        public MethodDef(PEFile file, int rows) {
            super(file, 6, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.RVA = this.readInt();
            this.ImplFlags = this.readShort();
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Signature = this.readBlobIndex();
            this.ParamList = this.readTableIndex(8);
        }

        @Override
        protected int getRowSize() {
            return 8 + this.file.getStringIndexSize() + this.file.getBlobIndexSize() + this.file.getTableIndexSize(8);
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }

    public static final class MethodImpl
    extends Table {
        public static final int ID = 25;
        public int Class;
        public int MethodBody;
        public int MethodDeclaration;

        public MethodImpl(PEFile file, int rows) {
            super(file, 25, rows);
        }

        @Override
        protected void populateFields() {
            this.Class = this.readTableIndex(2);
            this.MethodBody = this.readTableSetIndex(7);
            this.MethodDeclaration = this.readTableSetIndex(7);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + 2 * this.file.getTableSetIndexSize(7);
        }
    }

    public static final class MethodSemantics
    extends Table {
        public static final int ID = 24;
        public int Semantics;
        public int Method;
        public int Association;
        private static final short Setter = 1;
        private static final short Getter = 2;
        private static final short Other = 4;
        private static final short AddOn = 8;
        private static final short RemoveOn = 16;
        private static final short Fire = 32;

        public MethodSemantics(PEFile file, int rows) {
            super(file, 24, rows);
        }

        @Override
        protected void populateFields() {
            this.Semantics = this.readShort();
            this.Method = this.readTableIndex(6);
            this.Association = this.readTableSetIndex(6);
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getTableIndexSize(6) + this.file.getTableSetIndexSize(6);
        }

        public boolean isGetter() {
            return (this.Semantics & 2) != 0;
        }

        public boolean isSetter() {
            return (this.Semantics & 1) != 0;
        }

        public boolean isOther() {
            return (this.Semantics & 4) != 0;
        }

        public boolean isAddOn() {
            return (this.Semantics & 8) != 0;
        }

        public boolean isRemoveOn() {
            return (this.Semantics & 0x10) != 0;
        }

        public boolean isFire() {
            return (this.Semantics & 0x20) != 0;
        }
    }

    public static final class MethodSpec
    extends Table {
        public static final int ID = 43;
        public int Method;
        public int Instantiation;

        public MethodSpec(PEFile file, int rows) {
            super(file, 43, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Method = this.readTableSetIndex(7);
            this.Instantiation = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableSetIndexSize(7) + this.file.getBlobIndexSize();
        }
    }

    public static final class MethodTrans
    extends Table {
        public static final int ID = 5;
        public int Method;

        public MethodTrans(PEFile file, int rows) {
            super(file, 5, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Method = this.readTableIndex(4);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(6);
        }
    }

    public static final class ModuleDef
    extends Table {
        public static final int ID = 0;
        public int Generation;
        public int Name;
        public int Mvid;
        public int EncId;
        public int EncBaseId;

        public ModuleDef(PEFile file, int rows) {
            super(file, 0, rows);
        }

        @Override
        protected void populateFields() {
            this.Generation = this.readShort();
            this.Name = this.readStringIndex();
            this.Mvid = this.readGUIDIndex();
            this.EncId = this.readGUIDIndex();
            this.EncBaseId = this.readGUIDIndex();
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + 3 * this.file.getGUIDIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class ModuleRef
    extends Table {
        public static final int ID = 26;
        public int Name;

        public ModuleRef(PEFile file, int rows) {
            super(file, 26, rows);
        }

        @Override
        protected void populateFields() {
            this.Name = this.readStringIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class NestedClass
    extends Table {
        public static final int ID = 41;
        public int NestedClass;
        public int EnclosingClass;

        public NestedClass(PEFile file, int rows) {
            super(file, 41, rows);
        }

        @Override
        protected void populateFields() {
            this.NestedClass = this.readTableIndex(2);
            this.EnclosingClass = this.readTableIndex(2);
        }

        @Override
        protected int getRowSize() {
            return 2 * this.file.getTableIndexSize(2);
        }
    }

    public static final class ParamDef
    extends Table {
        public static final int ID = 8;
        public int Flags;
        public int Sequence;
        public int Name;

        public ParamDef(PEFile file, int rows) {
            super(file, 8, rows);
            this.newMapping = true;
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readShort();
            this.Sequence = this.readShort();
            this.Name = this.readStringIndex();
        }

        @Override
        protected int getRowSize() {
            return 4 + this.file.getStringIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }
    }

    public static final class PropertyDef
    extends Table {
        public static final int ID = 23;
        public int Flags;
        public int Name;
        public int Type;

        public PropertyDef(PEFile file, int rows) {
            super(file, 23, rows);
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readShort();
            this.Name = this.readStringIndex();
            this.Type = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return 2 + this.file.getStringIndexSize() + this.file.getBlobIndexSize();
        }

        public String getName() {
            return this.file.getString(this.Name);
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Type);
        }
    }

    public static final class PropertyMap
    extends Table {
        public static final int ID = 21;
        public int Parent;
        public int PropertyList;

        public PropertyMap(PEFile file, int rows) {
            super(file, 21, rows);
        }

        @Override
        protected void populateFields() {
            this.Parent = this.readTableIndex(2);
            this.PropertyList = this.readTableIndex(23);
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableIndexSize(2) + this.file.getTableIndexSize(23);
        }
    }

    public static final class StandAloneSig
    extends Table {
        public static final int ID = 17;
        public int Signature;

        public StandAloneSig(PEFile file, int rows) {
            super(file, 17, rows);
        }

        @Override
        protected void populateFields() {
            this.Signature = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getBlobIndexSize();
        }
    }

    public static final class TypeDef
    extends Table {
        public static final int ID = 2;
        public int Flags;
        public int Name;
        public int Namespace;
        public int Extends;
        public int FieldList;
        public int MethodList;

        public TypeDef(PEFile file, int rows) {
            super(file, 2, rows);
            this.newMapping = true;
        }

        public String getFullName() {
            String namespace = this.file.getString(this.Namespace);
            return namespace.length() == 0 ? this.file.getString(this.Name) : namespace + "." + this.file.getString(this.Name);
        }

        @Override
        protected void populateFields() {
            this.Flags = this.readInt();
            this.Name = this.readStringIndex();
            this.Namespace = this.readStringIndex();
            this.Extends = this.readTableSetIndex(0);
            this.FieldList = this.readTableIndex(4);
            this.MethodList = this.readTableIndex(6);
        }

        @Override
        protected int getRowSize() {
            return 4 + 2 * this.file.getStringIndexSize() + this.file.getTableSetIndexSize(0) + this.file.getTableIndexSize(4) + this.file.getTableIndexSize(6);
        }
    }

    public static final class TypeRef
    extends Table {
        public static final int ID = 1;
        public int ResolutionScope;
        public int Name;
        public int Namespace;

        public TypeRef(PEFile file, int rows) {
            super(file, 1, rows);
        }

        @Override
        protected void populateFields() {
            this.ResolutionScope = this.readTableSetIndex(11);
            this.Name = this.readStringIndex();
            this.Namespace = this.readStringIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getTableSetIndexSize(11) + 2 * this.file.getStringIndexSize();
        }

        public String getFullName() {
            String namespace = this.file.getString(this.Namespace);
            return namespace.length() == 0 ? this.file.getString(this.Name) : namespace + "." + this.file.getString(this.Name);
        }
    }

    public static final class TypeSpec
    extends Table {
        public static final int ID = 27;
        public int Signature;

        public TypeSpec(PEFile file, int rows) {
            super(file, 27, rows);
        }

        @Override
        protected void populateFields() {
            this.Signature = this.readBlobIndex();
        }

        @Override
        protected int getRowSize() {
            return this.file.getBlobIndexSize();
        }

        public PEFile.Sig getSignature() {
            return this.file.getSignature(this.Signature);
        }
    }
}

