/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.AbstractJsonObject;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonStringNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class JsonObject
extends AbstractJsonObject {
    private final List<JsonField> fields;

    JsonObject(final Iterable<JsonField> fields) {
        this.fields = Collections.unmodifiableList(new ArrayList<JsonField>(){
            {
                for (JsonField field : fields) {
                    this.add(field);
                }
            }
        });
    }

    @Override
    public Map<JsonStringNode, JsonNode> getFields() {
        return Collections.unmodifiableMap(new LinkedHashMap<JsonStringNode, JsonNode>(){
            {
                for (JsonField field : JsonObject.this.fields) {
                    this.put(field.getName(), field.getValue());
                }
            }
        });
    }

    @Override
    public List<JsonField> getFieldList() {
        return this.fields;
    }
}

