/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.staj.JsonStreamElementType;

public abstract class JsonStreamElement {
    private static final JsonStreamElement START_DOCUMENT = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.START_DOCUMENT);
    private static final JsonStreamElement END_DOCUMENT = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.END_DOCUMENT);
    private static final JsonStreamElement START_ARRAY = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.START_ARRAY);
    private static final JsonStreamElement END_ARRAY = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.END_ARRAY);
    private static final JsonStreamElement START_OBJECT = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.START_OBJECT);
    private static final JsonStreamElement END_OBJECT = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.END_OBJECT);
    private static final JsonStreamElement END_FIELD = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.END_FIELD);
    private static final JsonStreamElement TRUE = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.TRUE);
    private static final JsonStreamElement FALSE = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.FALSE);
    private static final JsonStreamElement NULL = JsonStreamElement.nonTextJsonStreamElement(JsonStreamElementType.NULL);
    private final JsonStreamElementType jsonStreamElementType;

    private static JsonStreamElement nonTextJsonStreamElement(final JsonStreamElementType jsonStreamElementType) {
        return new JsonStreamElement(jsonStreamElementType){

            @Override
            public boolean hasText() {
                return false;
            }

            @Override
            public String text() {
                throw new IllegalStateException(this.jsonStreamElementType().name() + " does not have text associated with it");
            }

            public String toString() {
                return "JsonStreamElement jsonStreamElementType: " + (Object)((Object)jsonStreamElementType) + "";
            }
        };
    }

    private static JsonStreamElement textJsonStreamElement(final JsonStreamElementType jsonStreamElementType, final String text) {
        return new JsonStreamElement(jsonStreamElementType){

            @Override
            public boolean hasText() {
                return true;
            }

            @Override
            public String text() {
                return text;
            }

            public String toString() {
                return "JsonStreamElement jsonStreamElementType: " + (Object)((Object)jsonStreamElementType) + ", text: " + text;
            }
        };
    }

    static JsonStreamElement startDocument() {
        return START_DOCUMENT;
    }

    static JsonStreamElement endDocument() {
        return END_DOCUMENT;
    }

    static JsonStreamElement startArray() {
        return START_ARRAY;
    }

    static JsonStreamElement endArray() {
        return END_ARRAY;
    }

    static JsonStreamElement startObject() {
        return START_OBJECT;
    }

    static JsonStreamElement endObject() {
        return END_OBJECT;
    }

    static JsonStreamElement startField(String text) {
        return JsonStreamElement.textJsonStreamElement(JsonStreamElementType.START_FIELD, text);
    }

    static JsonStreamElement endField() {
        return END_FIELD;
    }

    static JsonStreamElement string(String text) {
        return JsonStreamElement.textJsonStreamElement(JsonStreamElementType.STRING, text);
    }

    static JsonStreamElement number(String text) {
        return JsonStreamElement.textJsonStreamElement(JsonStreamElementType.NUMBER, text);
    }

    static JsonStreamElement trueValue() {
        return TRUE;
    }

    static JsonStreamElement falseValue() {
        return FALSE;
    }

    static JsonStreamElement nullValue() {
        return NULL;
    }

    private JsonStreamElement(JsonStreamElementType jsonStreamElementType) {
        this.jsonStreamElementType = jsonStreamElementType;
    }

    public final JsonStreamElementType jsonStreamElementType() {
        return this.jsonStreamElementType;
    }

    public abstract boolean hasText();

    public abstract String text();
}

