/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron;

import com.google.gson.stream.JsonWriter;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.map.hash.TObjectLongHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.TileEntityCache;
import net.minecraftforge.cauldron.configuration.CauldronConfig;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class CauldronHooks {
    public static boolean craftWorldLoading = false;
    public static int tickingDimension = 0;
    public static afg tickingChunk = null;
    public static Map<Class<? extends and>, TileEntityCache> tileEntityCache = new HashMap<Class<? extends and>, TileEntityCache>();
    private static TObjectLongHashMap<CollisionWarning> recentWarnings = new TObjectLongHashMap();

    public static void logInfo(String msg, Object ... args) {
        MinecraftServer.G().e(MessageFormat.format(msg, args));
    }

    public static void logWarning(String msg, Object ... args) {
        MinecraftServer.G().f(MessageFormat.format(msg, args));
    }

    public static void logSevere(String msg, Object ... args) {
        MinecraftServer.G().h(MessageFormat.format(msg, args));
    }

    public static void logStack() {
        if (CauldronConfig.logWithStackTraces.getValue().booleanValue()) {
            Throwable ex = new Throwable();
            ex.fillInStackTrace();
            ex.printStackTrace();
        }
    }

    public static void logEntityDeath(qn entity) {
        if (CauldronConfig.entityDeathLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} setDead(): {1}", entity.p.t.i, entity);
            CauldronHooks.logStack();
        }
    }

    public static void logEntityDespawn(qn entity, String reason) {
        if (CauldronConfig.entityDespawnLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} Despawning ({1}): {2}", entity.p.t.i, reason, entity);
            CauldronHooks.logStack();
        }
    }

    public static void logEntitySpawn(afn world, qn entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (CauldronConfig.entitySpawnLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("Dim: {0} Spawning ({1}): {2}", new Object[]{world.t.i, spawnReason, entity});
            CauldronHooks.logInfo("Dim: {0} Entities Last Tick: {1}", world.t.i, world.entitiesTicked);
            CauldronHooks.logInfo("Dim: {0} Tiles Last Tick: {1}", world.t.i, world.tilesTicked);
            CauldronHooks.logStack();
        }
    }

    public static void logChunkLoad(mi provider, String msg, int x, int z2, boolean logLoadOnRequest) {
        if (CauldronConfig.chunkLoadLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("{0} Chunk At [{1}] ({2}, {3})", msg, provider.i.t.i, x, z2);
            if (logLoadOnRequest) {
                CauldronHooks.logLoadOnRequest(provider, x, z2);
            }
            CauldronHooks.logStack();
        }
    }

    public static void logChunkUnload(mi provider, int x, int z2, String msg) {
        if (CauldronConfig.chunkUnloadLogging.getValue().booleanValue()) {
            CauldronHooks.logInfo("{0} [{1}] ({2}, {3})", msg, provider.i.t.i, x, z2);
            long currentTick = MinecraftServer.G().aj();
            long lastAccessed = provider.lastAccessed(x, z2);
            long diff = currentTick - lastAccessed;
            CauldronHooks.logInfo(" Last accessed: {0, number} Current Tick: {1, number} [{2, number}]", lastAccessed, currentTick, diff);
        }
    }

    private static void logLoadOnRequest(mi provider, int x, int z2) {
        long currentTick = MinecraftServer.G().aj();
        long lastAccessed = provider.lastAccessed(x, z2);
        long diff = currentTick - lastAccessed;
        CauldronHooks.logInfo(" Last accessed: {0, number} Current Tick: {1, number} [{2, number}]", lastAccessed, currentTick, diff);
        CauldronHooks.logInfo(" Finding Spawn Point: {0}", provider.i.y);
        CauldronHooks.logInfo(" Load chunk on request: {0}", provider.a);
        CauldronHooks.logInfo(" Calling Forge Tick: {0}", MinecraftServer.callingForgeTick);
        CauldronHooks.logInfo(" Load chunk on forge tick: {0}", CauldronConfig.loadChunkOnForgeTick.getValue());
        long providerTickDiff = currentTick - (long)provider.initialTick;
        if (providerTickDiff <= 100L) {
            CauldronHooks.logInfo(" Current Tick - Initial Tick: {0, number}", providerTickDiff);
        }
    }

    public static boolean checkBoundingBoxSize(qn entity, ayf aabb) {
        int logSize = CauldronConfig.largeBoundingBoxLogSize.getValue();
        if (logSize <= 0 || !CauldronConfig.checkEntityBoundingBoxes.getValue().booleanValue()) {
            return false;
        }
        int x = ou.c((double)aabb.a);
        int x1 = ou.c((double)(aabb.d + 1.0));
        int y = ou.c((double)aabb.b);
        int y1 = ou.c((double)(aabb.e + 1.0));
        int z2 = ou.c((double)aabb.c);
        int z1 = ou.c((double)(aabb.f + 1.0));
        int size = Math.abs(x1 - x) * Math.abs(y1 - y) * Math.abs(z1 - z2);
        if (size > CauldronConfig.largeBoundingBoxLogSize.getValue()) {
            CauldronHooks.logWarning("Entity being removed for bounding box restrictions", new Object[0]);
            CauldronHooks.logWarning("BB Size: {0} > {1} avg edge: {2}", size, logSize, aabb.b());
            CauldronHooks.logWarning("Motion: ({0}, {1}, {2})", entity.w, entity.x, entity.y);
            CauldronHooks.logWarning("Calculated bounding box: {0}", aabb);
            CauldronHooks.logWarning("Entity bounding box: {0}", entity.J());
            CauldronHooks.logWarning("Entity: {0}", entity);
            dg tag = new dg();
            entity.e(tag);
            CauldronHooks.logWarning("Entity NBT: {0}", tag);
            CauldronHooks.logStack();
            entity.B();
            return true;
        }
        return false;
    }

    public static boolean checkEntitySpeed(qn entity, double x, double y, double z2) {
        double distance;
        int maxSpeed = CauldronConfig.entityMaxSpeed.getValue();
        if (maxSpeed > 0 && CauldronConfig.checkEntityMaxSpeeds.getValue().booleanValue() && (distance = x * x + z2 * z2) > (double)maxSpeed) {
            if (CauldronConfig.logEntitySpeedRemoval.getValue().booleanValue()) {
                CauldronHooks.logInfo("Speed violation: {0} was over {1} - Removing Entity: {2}", distance, maxSpeed, entity);
                if (entity instanceof rh) {
                    rh livingBase = (rh)entity;
                    CauldronHooks.logInfo("Entity Motion: ({0}, {1}, {2}) Move Strafing: {3} Move Forward: {4}", entity.w, entity.x, entity.y, Float.valueOf(livingBase.be), Float.valueOf(livingBase.bf));
                }
                if (CauldronConfig.logWithStackTraces.getValue().booleanValue()) {
                    CauldronHooks.logInfo("Move offset: ({0}, {1}, {2})", x, y, z2);
                    CauldronHooks.logInfo("Motion: ({0}, {1}, {2})", entity.w, entity.x, entity.y);
                    CauldronHooks.logInfo("Entity: {0}", entity);
                    dg tag = new dg();
                    entity.e(tag);
                    CauldronHooks.logInfo("Entity NBT: {0}", tag);
                    CauldronHooks.logStack();
                }
            }
            if (entity instanceof xl) {
                entity.w = 0.0;
                entity.x = 0.0;
                entity.y = 0.0;
                return false;
            }
            entity.L = true;
            return false;
        }
        return true;
    }

    public static void logEntitySize(afn world, qn entity, List list) {
        if (!CauldronConfig.logEntityCollisionChecks.getValue().booleanValue()) {
            return;
        }
        long largeCountLogSize = CauldronConfig.largeCollisionLogSize.getValue().intValue();
        if (largeCountLogSize > 0L && (long)world.entitiesTicked > largeCountLogSize) {
            CauldronHooks.logWarning("Entity size > {0, number} at: {1}", largeCountLogSize, entity);
        }
        if (list == null) {
            return;
        }
        long largeCollisionLogSize = CauldronConfig.largeCollisionLogSize.getValue().intValue();
        if (largeCollisionLogSize > 0L && MinecraftServer.G().aj() % 10 == 0 && (long)list.size() >= largeCollisionLogSize) {
            CollisionWarning warning = new CollisionWarning(world, entity);
            if (recentWarnings.contains((Object)warning)) {
                long lastWarned = recentWarnings.get((Object)warning);
                if (MinecraftServer.ap() - lastWarned < 30000L) {
                    return;
                }
            }
            recentWarnings.put((Object)warning, System.currentTimeMillis());
            CauldronHooks.logWarning("Entity collision > {0, number} at: {1}", largeCollisionLogSize, entity);
        }
    }

    public static boolean canTileEntityTick(and tileEntity, afn world) {
        if (tileEntity == null || world.cauldronConfig == null) {
            return false;
        }
        TileEntityCache teCache = tileEntityCache.get(tileEntity.getClass());
        if (teCache == null) {
            String teConfigPath = tileEntity.getClass().getName().replace(".", "-");
            teCache = new TileEntityCache(tileEntity.getClass(), world.M().k(), teConfigPath, world.cauldronConfig.getBoolean(teConfigPath + ".tick-no-players", false), world.cauldronConfig.getInt(teConfigPath + ".tick-interval", 1));
            tileEntityCache.put(tileEntity.getClass(), teCache);
            CauldronConfig.load(false);
        }
        if (!teCache.tickNoPlayers && !world.isActiveBlockCoord(tileEntity.c, tileEntity.e)) {
            return false;
        }
        return teCache.tickInterval > 0 && world.M().f() % (long)teCache.tickInterval == 0L;
    }

    public static boolean canUpdate(and tileEntity) {
        return tileEntity != null && tileEntity.canUpdate() && !MinecraftServer.bannedTileEntityUpdates.contains(tileEntity.getClass());
    }

    public static void writeChunks(File file, boolean logAll) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(file);
            JsonWriter writer = new JsonWriter((Writer)fileWriter);
            writer.setIndent("  ");
            writer.beginArray();
            for (mj world : MinecraftServer.G().worlds) {
                writer.beginObject();
                writer.name("name").value(world.getWorld().getName());
                writer.name("dimensionId").value((long)world.t.i);
                writer.name("players").value((long)world.h.size());
                writer.name("loadedChunks").value((long)world.b.g.size());
                writer.name("activeChunks").value((long)world.F.size());
                writer.name("entities").value((long)world.e.size());
                writer.name("tiles").value((long)world.g.size());
                TObjectIntHashMap chunkEntityCounts = new TObjectIntHashMap();
                TObjectIntHashMap classEntityCounts = new TObjectIntHashMap();
                TObjectIntHashMap entityCollisionCounts = new TObjectIntHashMap();
                HashSet<r> collidingCoords = new HashSet<r>();
                for (int i = 0; i < world.e.size(); ++i) {
                    r coords;
                    qn entity = (qn)world.e.get(i);
                    afg chunkCoords = new afg((int)entity.t >> 4, (int)entity.v >> 4);
                    chunkEntityCounts.adjustOrPutValue((Object)chunkCoords, 1, 1);
                    classEntityCounts.adjustOrPutValue(entity.getClass(), 1, 1);
                    if (entity.D == null || !logAll || collidingCoords.contains(coords = new r((int)Math.floor(entity.t), (int)Math.floor(entity.u), (int)Math.floor(entity.v)))) continue;
                    collidingCoords.add(coords);
                    int size = entity.p.b(entity, entity.D.b(1.0, 1.0, 1.0)).size();
                    if (size < 5) continue;
                    entityCollisionCounts.put((Object)entity, size);
                }
                TObjectIntHashMap chunkTileCounts = new TObjectIntHashMap();
                TObjectIntHashMap classTileCounts = new TObjectIntHashMap();
                writer.name("tiles").beginArray();
                for (int i = 0; i < world.g.size(); ++i) {
                    and tile = (and)world.g.get(i);
                    if (logAll) {
                        writer.beginObject();
                        writer.name("type").value(tile.getClass().toString());
                        writer.name("x").value((long)tile.c);
                        writer.name("y").value((long)tile.d);
                        writer.name("z").value((long)tile.e);
                        writer.name("isInvalid").value(tile.r());
                        writer.name("canUpdate").value(tile.canUpdate());
                        writer.name("block").value("" + tile.q());
                        writer.endObject();
                    }
                    afg chunkCoords = new afg(tile.c >> 4, tile.e >> 4);
                    chunkTileCounts.adjustOrPutValue((Object)chunkCoords, 1, 1);
                    classTileCounts.adjustOrPutValue(tile.getClass(), 1, 1);
                }
                writer.endArray();
                if (logAll) {
                    CauldronHooks.writeChunkCounts(writer, "topEntityColliders", entityCollisionCounts, 20);
                }
                CauldronHooks.writeChunkCounts(writer, "entitiesByClass", classEntityCounts);
                CauldronHooks.writeChunkCounts(writer, "entitiesByChunk", chunkEntityCounts);
                CauldronHooks.writeChunkCounts(writer, "tilesByClass", classTileCounts);
                CauldronHooks.writeChunkCounts(writer, "tilesByChunk", chunkTileCounts);
                writer.endObject();
            }
            writer.endArray();
            writer.close();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            MinecraftServer.G().h("Could not save chunk info report to " + file);
        }
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, TObjectIntHashMap<T> map) throws IOException {
        CauldronHooks.writeChunkCounts(writer, name, map, 0);
    }

    private static <T> void writeChunkCounts(JsonWriter writer, String name, final TObjectIntHashMap<T> map, int max) throws IOException {
        ArrayList sortedCoords = new ArrayList(map.keySet());
        Collections.sort(sortedCoords, new Comparator<T>(){

            @Override
            public int compare(T s1, T s2) {
                return map.get(s2) - map.get(s1);
            }
        });
        int i = 0;
        writer.name(name).beginArray();
        for (Object key : sortedCoords) {
            if (max > 0 && i++ > max) break;
            if (map.get(key) < 5) continue;
            writer.beginObject();
            writer.name("key").value(key.toString());
            writer.name("count").value((long)map.get(key));
            writer.endObject();
        }
        writer.endArray();
    }

    public static void dumpHeap(File file, boolean live) {
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            Object hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
            Method m = clazz.getMethod("dumpHeap", String.class, Boolean.TYPE);
            m.invoke(hotspotMBean, file.getPath(), live);
        }
        catch (Throwable t) {
            CauldronHooks.logSevere("Could not write heap to {0}", file);
        }
    }

    public static void enableThreadContentionMonitoring() {
        if (!CauldronConfig.enableThreadContentionMonitoring.getValue().booleanValue()) {
            return;
        }
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        mbean.setThreadContentionMonitoringEnabled(true);
    }

    private static class CollisionWarning {
        public r chunkCoords;
        public int dimensionId;

        public CollisionWarning(afn world, qn entity) {
            this.dimensionId = world.t.i;
            this.chunkCoords = new r(entity.ai, entity.aj, entity.ak);
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof CollisionWarning) || otherObj == null) {
                return false;
            }
            CollisionWarning other = (CollisionWarning)otherObj;
            return other.dimensionId == this.dimensionId && other.chunkCoords.equals((Object)this.chunkCoords);
        }

        public int hashCode() {
            return this.chunkCoords.hashCode() + this.dimensionId;
        }
    }
}

