/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import java.util.List;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.CauldronConfig;
import net.minecraftforge.cauldron.configuration.IntSetting;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;

public class CauldronWorldConfig {
    private final String worldName;
    public YamlConfiguration config;
    private boolean verbose;
    public boolean entitiesDespawnImmediate = true;

    public CauldronWorldConfig(String worldName) {
        this.worldName = worldName.toLowerCase();
        this.config = CauldronConfig.config;
        if (worldName.toLowerCase().contains("dummy")) {
            return;
        }
    }

    public void save() {
        CauldronConfig.save();
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    public void set(String path, Object val) {
        this.config.set(path, val);
    }

    public boolean isBoolean(String path) {
        return this.config.isBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        if (CauldronConfig.settings.get("world-settings.default." + path) == null) {
            CauldronConfig.settings.put("world-settings.default." + path, new BoolSetting("world-settings.default." + path, def, ""));
        }
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    public int getInt(String path, int def) {
        if (CauldronConfig.settings.get("world-settings.default." + path) == null) {
            CauldronConfig.settings.put("world-settings.default." + path, new IntSetting("world-settings.default." + path, def, ""));
        }
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }
}

