/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;
import org.bukkit.util.StringUtil;
import org.spigotmc.CustomTimingsHandler;

public class TimingsCommand
extends BukkitCommand {
    private static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"merged", (Object)"reset", (Object)"separate");
    public static long timingStart = 0L;

    public TimingsCommand(String name) {
        super(name);
        this.description = "Records timings for all plugin events";
        this.usageMessage = "/timings <reset|merged|separate|on|off> [paste]";
        this.setPermission("bukkit.command.timings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if ("on".equals(args[0])) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "This command is disabled as it does not produce accurate results. Please enable plugin-profiling in bukkit.yml and restart.");
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Please see http://www.spigotmc.org/wiki/disabled-timings-on-command/ for further information.");
        } else if ("off".equals(args[0])) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "This command is disabled as it does not produce accurate results. Please disable plugin-profiling in bukkit.yml and restart.");
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Please see http://www.spigotmc.org/wiki/disabled-timings-on-command/ for further information.");
        }
        boolean separate = "separate".equals(args[0]);
        boolean paste = "paste".equals(args[0]);
        if ("on".equals(args[0]) || "reset".equals(args[0])) {
            if (!"on".equals(args[0]) && !Bukkit.getPluginManager().useTimings()) {
                sender.sendMessage("Please enable timings by typing /timings on");
                return true;
            }
            for (HandlerList handlerList : HandlerList.getHandlerLists()) {
                for (RegisteredListener listener : handlerList.getRegisteredListeners()) {
                    if (!(listener instanceof TimedRegisteredListener)) continue;
                    ((TimedRegisteredListener)listener).reset();
                }
            }
            CustomTimingsHandler.reload();
            timingStart = System.nanoTime();
            sender.sendMessage("Timings reset");
        } else if ("merged".equals(args[0]) || separate || paste) {
            ByteArrayOutputStream bout;
            if (!Bukkit.getPluginManager().useTimings()) {
                sender.sendMessage("Please enable timings by typing /timings on");
                return true;
            }
            long sampleTime = System.nanoTime() - timingStart;
            int index = 0;
            int pluginIdx = 0;
            File timingFolder = new File("timings");
            timingFolder.mkdirs();
            File timings = new File(timingFolder, "timings.txt");
            File names = null;
            ByteArrayOutputStream byteArrayOutputStream = bout = paste ? new ByteArrayOutputStream() : null;
            while (timings.exists()) {
                timings = new File(timingFolder, "timings" + ++index + ".txt");
            }
            PrintStream fileTimings = null;
            PrintStream fileNames = null;
            try {
                PrintStream printStream = fileTimings = paste ? new PrintStream(bout) : new PrintStream(timings);
                if (separate) {
                    names = new File(timingFolder, "names" + index + ".txt");
                    fileNames = new PrintStream(names);
                }
                for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
                    ++pluginIdx;
                    long totalTime = 0L;
                    if (separate) {
                        fileNames.println(pluginIdx + " " + plugin.getDescription().getFullName());
                        fileTimings.println("Plugin " + pluginIdx);
                    } else {
                        fileTimings.println(plugin.getDescription().getFullName());
                    }
                    for (RegisteredListener listener : HandlerList.getRegisteredListeners(plugin)) {
                        if (!(listener instanceof TimedRegisteredListener)) continue;
                        TimedRegisteredListener trl = (TimedRegisteredListener)listener;
                        long time = trl.getTotalTime();
                        int count = trl.getCount();
                        if (count == 0) continue;
                        long avg = time / (long)count;
                        totalTime += time;
                        Class<? extends Event> eventClass = trl.getEventClass();
                        if (count <= 0 || eventClass == null) continue;
                        fileTimings.println("    " + eventClass.getSimpleName() + (trl.hasMultiple() ? " (and sub-classes)" : "") + " Time: " + time + " Count: " + count + " Avg: " + avg + " Violations: " + trl.violations);
                    }
                    fileTimings.println("    Total time " + totalTime + " (" + totalTime / 1000000000L + "s)");
                }
                CustomTimingsHandler.printTimings(fileTimings);
                fileTimings.println("Sample time " + sampleTime + " (" + (double)sampleTime / 1.0E9 + "s)");
                if (paste) {
                    new PasteThread(sender, bout).start();
                    boolean arr$ = true;
                    return arr$;
                }
                sender.sendMessage("Timings written to " + timings.getPath());
                sender.sendMessage("Paste contents of file into form at http://aikar.co/timings.php to read results.");
                if (separate) {
                    sender.sendMessage("Names written to " + names.getPath());
                }
            }
            catch (IOException e) {
            }
            finally {
                if (fileTimings != null) {
                    fileTimings.close();
                }
                if (fileNames != null) {
                    fileNames.close();
                }
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], TIMINGS_SUBCOMMANDS, new ArrayList(TIMINGS_SUBCOMMANDS.size()));
        }
        return ImmutableList.of();
    }

    private static class PasteThread
    extends Thread {
        private final CommandSender sender;
        private final ByteArrayOutputStream bout;

        public PasteThread(CommandSender sender, ByteArrayOutputStream bout) {
            super("Timings paste thread");
            this.sender = sender;
            this.bout = bout;
        }

        @Override
        public void run() {
            try {
                HttpURLConnection con = (HttpURLConnection)new URL("http://paste.ubuntu.com/").openConnection();
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                con.setInstanceFollowRedirects(false);
                OutputStream out = con.getOutputStream();
                out.write("poster=Spigot&syntax=text&content=".getBytes("UTF-8"));
                out.write(URLEncoder.encode(this.bout.toString("UTF-8"), "UTF-8").getBytes("UTF-8"));
                out.close();
                con.getInputStream().close();
                String location = con.getHeaderField("Location");
                String pasteID = location.substring("http://paste.ubuntu.com/".length(), location.length() - 1);
                this.sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Your timings have been pasted to " + location);
                this.sender.sendMessage((Object)((Object)ChatColor.GREEN) + "You can view the results at http://aikar.co/timings.php?url=" + pasteID);
            }
            catch (IOException ex) {
                this.sender.sendMessage((Object)((Object)ChatColor.RED) + "Error pasting timings, check your console for more information");
                Bukkit.getServer().getLogger().log(Level.WARNING, "Could not paste timings", ex);
            }
        }
    }
}

