/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.block;

import com.google.common.base.Strings;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_7_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R1.block.CraftBlockState;

public class CraftSkull
extends CraftBlockState
implements Skull {
    private final anz skull;
    private String player;
    private SkullType skullType;
    private byte rotation;
    private final int MAX_OWNER_LENGTH = 16;

    public CraftSkull(Block block) {
        super(block);
        CraftWorld world = (CraftWorld)block.getWorld();
        this.skull = (anz)world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
        this.player = this.skull.c();
        this.skullType = CraftSkull.getSkullType(this.skull.a());
        this.rotation = (byte)this.skull.getRotation();
    }

    static SkullType getSkullType(int id) {
        switch (id) {
            case 0: {
                return SkullType.SKELETON;
            }
            case 1: {
                return SkullType.WITHER;
            }
            case 2: {
                return SkullType.ZOMBIE;
            }
            case 3: {
                return SkullType.PLAYER;
            }
            case 4: {
                return SkullType.CREEPER;
            }
        }
        throw new AssertionError(id);
    }

    static int getSkullType(SkullType type) {
        switch (type) {
            case SKELETON: {
                return 0;
            }
            case WITHER: {
                return 1;
            }
            case ZOMBIE: {
                return 2;
            }
            case PLAYER: {
                return 3;
            }
            case CREEPER: {
                return 4;
            }
        }
        throw new AssertionError((Object)type);
    }

    static byte getBlockFace(BlockFace rotation) {
        switch (rotation) {
            case NORTH: {
                return 0;
            }
            case NORTH_NORTH_EAST: {
                return 1;
            }
            case NORTH_EAST: {
                return 2;
            }
            case EAST_NORTH_EAST: {
                return 3;
            }
            case EAST: {
                return 4;
            }
            case EAST_SOUTH_EAST: {
                return 5;
            }
            case SOUTH_EAST: {
                return 6;
            }
            case SOUTH_SOUTH_EAST: {
                return 7;
            }
            case SOUTH: {
                return 8;
            }
            case SOUTH_SOUTH_WEST: {
                return 9;
            }
            case SOUTH_WEST: {
                return 10;
            }
            case WEST_SOUTH_WEST: {
                return 11;
            }
            case WEST: {
                return 12;
            }
            case WEST_NORTH_WEST: {
                return 13;
            }
            case NORTH_WEST: {
                return 14;
            }
            case NORTH_NORTH_WEST: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid BlockFace rotation: " + (Object)((Object)rotation));
    }

    static BlockFace getBlockFace(byte rotation) {
        switch (rotation) {
            case 0: {
                return BlockFace.NORTH;
            }
            case 1: {
                return BlockFace.NORTH_NORTH_EAST;
            }
            case 2: {
                return BlockFace.NORTH_EAST;
            }
            case 3: {
                return BlockFace.EAST_NORTH_EAST;
            }
            case 4: {
                return BlockFace.EAST;
            }
            case 5: {
                return BlockFace.EAST_SOUTH_EAST;
            }
            case 6: {
                return BlockFace.SOUTH_EAST;
            }
            case 7: {
                return BlockFace.SOUTH_SOUTH_EAST;
            }
            case 8: {
                return BlockFace.SOUTH;
            }
            case 9: {
                return BlockFace.SOUTH_SOUTH_WEST;
            }
            case 10: {
                return BlockFace.SOUTH_WEST;
            }
            case 11: {
                return BlockFace.WEST_SOUTH_WEST;
            }
            case 12: {
                return BlockFace.WEST;
            }
            case 13: {
                return BlockFace.WEST_NORTH_WEST;
            }
            case 14: {
                return BlockFace.NORTH_WEST;
            }
            case 15: {
                return BlockFace.NORTH_NORTH_WEST;
            }
        }
        throw new AssertionError(rotation);
    }

    @Override
    public boolean hasOwner() {
        return !Strings.isNullOrEmpty((String)this.player);
    }

    @Override
    public String getOwner() {
        return this.player;
    }

    @Override
    public boolean setOwner(String name) {
        if (name == null || name.length() > 16) {
            return false;
        }
        this.player = name;
        if (this.skullType != SkullType.PLAYER) {
            this.skullType = SkullType.PLAYER;
        }
        return true;
    }

    @Override
    public BlockFace getRotation() {
        return CraftSkull.getBlockFace(this.rotation);
    }

    @Override
    public void setRotation(BlockFace rotation) {
        this.rotation = CraftSkull.getBlockFace(rotation);
    }

    @Override
    public SkullType getSkullType() {
        return this.skullType;
    }

    @Override
    public void setSkullType(SkullType skullType) {
        this.skullType = skullType;
        if (skullType != SkullType.PLAYER) {
            this.player = "";
        }
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result) {
            this.skull.a(CraftSkull.getSkullType(this.skullType), this.player);
            this.skull.a((int)this.rotation);
            this.skull.e();
        }
        return result;
    }
}

