/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.command;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import jline.console.completer.Completer;
import org.bukkit.craftbukkit.v1_7_R1.CraftServer;
import org.bukkit.craftbukkit.v1_7_R1.util.Waitable;

public class ConsoleCommandCompleter
implements Completer {
    private final CraftServer server;

    public ConsoleCommandCompleter(CraftServer server) {
        this.server = server;
    }

    public int complete(final String buffer, int cursor, List<CharSequence> candidates) {
        Waitable<List<String>> waitable = new Waitable<List<String>>(){

            @Override
            protected List<String> evaluate() {
                return ConsoleCommandCompleter.this.server.getCommandMap().tabComplete(ConsoleCommandCompleter.this.server.getConsoleSender(), buffer);
            }
        };
        this.server.getServer().processQueue.add(waitable);
        try {
            List offers = (List)waitable.get();
            if (offers == null) {
                return cursor;
            }
            candidates.addAll(offers);
            int lastSpace = buffer.lastIndexOf(32);
            if (lastSpace == -1) {
                return cursor - buffer.length();
            }
            return cursor - (buffer.length() - lastSpace - 1);
        }
        catch (ExecutionException e) {
            this.server.getLogger().log(Level.WARNING, "Unhandled exception when tab completing", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return cursor;
    }
}

