/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_7_R1.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.MapMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaMap
extends CraftMetaItem
implements MapMeta {
    static final CraftMetaItem.ItemMetaKey MAP_SCALING = new CraftMetaItem.ItemMetaKey("map_is_scaling", "scaling");
    static final byte SCALING_EMPTY = 0;
    static final byte SCALING_TRUE = 1;
    static final byte SCALING_FALSE = 2;
    private byte scaling = 0;

    CraftMetaMap(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaMap)) {
            return;
        }
        CraftMetaMap map = (CraftMetaMap)meta;
        this.scaling = map.scaling;
    }

    CraftMetaMap(dg tag) {
        super(tag);
        if (tag.c(CraftMetaMap.MAP_SCALING.NBT)) {
            this.scaling = (byte)(tag.n(CraftMetaMap.MAP_SCALING.NBT) ? 1 : 2);
        }
    }

    CraftMetaMap(Map<String, Object> map) {
        super(map);
        Boolean scaling = CraftMetaItem.SerializableMeta.getObject(Boolean.class, map, CraftMetaMap.MAP_SCALING.BUKKIT, true);
        if (scaling != null) {
            this.setScaling(scaling);
        }
    }

    @Override
    void applyToItem(dg tag) {
        super.applyToItem(tag);
        if (this.hasScaling()) {
            tag.a(CraftMetaMap.MAP_SCALING.NBT, this.isScaling());
        }
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case MAP: {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isMapEmpty();
    }

    boolean isMapEmpty() {
        return !this.hasScaling();
    }

    boolean hasScaling() {
        return this.scaling != 0;
    }

    @Override
    public boolean isScaling() {
        return this.scaling == 1;
    }

    @Override
    public void setScaling(boolean scaling) {
        this.scaling = (byte)(scaling ? 1 : 2);
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaMap) {
            CraftMetaMap that = (CraftMetaMap)meta;
            return this.scaling == that.scaling;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaMap || this.isMapEmpty());
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasScaling()) {
            hash ^= 0x22222222 << (this.isScaling() ? 1 : -1);
        }
        return original != hash ? CraftMetaMap.class.hashCode() ^ hash : hash;
    }

    @Override
    public CraftMetaMap clone() {
        return (CraftMetaMap)super.clone();
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasScaling()) {
            builder.put((Object)CraftMetaMap.MAP_SCALING.BUKKIT, (Object)this.isScaling());
        }
        return builder;
    }
}

