/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.scoreboard;

import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final aym objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, aym objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
        scoreboard.objectives.put(objective.b(), this);
    }

    aym getHandle() {
        return this.objective;
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.objective.b();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.objective.d();
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 32 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 32 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.objective.a(displayName);
    }

    @Override
    public String getCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria.bukkitName;
    }

    @Override
    public boolean isModifiable() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return !this.criteria.criteria.b();
    }

    @Override
    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ayr board = scoreboard.board;
        aym objective = this.objective;
        for (int i = 0; i < 3; ++i) {
            if (board.a(i) != objective) continue;
            board.a(i, null);
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.a(slotNumber, this.getHandle());
        }
    }

    @Override
    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ayr board = scoreboard.board;
        aym objective = this.objective;
        for (int i = 0; i < 3; ++i) {
            if (board.a(i) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i);
        }
        return null;
    }

    @Override
    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, player.getName());
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.objectives.remove(this.getName());
        scoreboard.board.k(this.objective);
        this.setUnregistered();
    }
}

