/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.RemapperProcessor;
import net.md_5.specialsource.provider.ClassLoaderProvider;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.RuntimeRepo;
import net.md_5.specialsource.transformer.MappingTransformer;
import net.md_5.specialsource.transformer.MavenShade;
import net.minecraftforge.cauldron.configuration.CauldronConfig;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_7_R1.CraftServer;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;

public class PluginClassLoader
extends URLClassLoader {
    private final JavaPluginLoader loader;
    private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();
    private final PluginDescriptionFile description;
    private final File dataFolder;
    private final File file;
    JavaPlugin plugin;
    private JavaPlugin pluginInit;
    private IllegalStateException pluginState;
    private JarRemapper remapper;
    private RemapperProcessor remapperProcessor;
    private boolean debug;
    private static ConcurrentMap<Integer, JarMapping> jarMappings = new ConcurrentHashMap<Integer, JarMapping>();
    private static final int F_USE_GUAVA10 = 2;
    private static final int F_GLOBAL_INHERIT = 4;
    private static final int F_REMAP_OBCPRE = 8;
    private static final int F_REMAP_NMS152 = 16;
    private static final int F_REMAP_NMS161 = 32;
    private static final int F_REMAP_NMS162 = 64;
    private static final int F_REMAP_NMS164 = 128;
    private static final int F_REMAP_NMS172 = 256;
    private static final int F_REMAP_OBC152 = 512;
    private static final int F_REMAP_OBC161 = 1024;
    private static final int F_REMAP_OBC162 = 2048;
    private static final int F_REMAP_OBC164 = 4096;
    private static final int F_REMAP_OBC172 = 8192;
    private static final int F_REMAP_NMSPRE_MASK = -1048576;
    private static final String org_bukkit_craftbukkit = new String(new char[]{'o', 'r', 'g', '/', 'b', 'u', 'k', 'k', 'i', 't', '/', 'c', 'r', 'a', 'f', 't', 'b', 'u', 'k', 'k', 'i', 't'});

    PluginClassLoader(JavaPluginLoader loader, ClassLoader parent, PluginDescriptionFile description, File dataFolder, File file) throws InvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        Validate.notNull((Object)loader, (String)"Loader cannot be null");
        this.loader = loader;
        this.description = description;
        this.dataFolder = dataFolder;
        this.file = file;
        String pluginName = this.description.getName();
        boolean useCustomClassLoader = CauldronConfig.getBoolean("plugin-settings.default.custom-class-loader", true);
        this.debug = CauldronConfig.getBoolean("plugin-settings.default.debug", false);
        boolean useGuava10 = CauldronConfig.getBoolean("plugin-settings.default.use-guava10", true);
        boolean remapNMS172 = CauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_7_R1", true);
        boolean remapNMS164 = CauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R3", true);
        boolean remapNMS162 = CauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R2", true);
        boolean remapNMS161 = CauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_6_R1", true);
        boolean remapNMS152 = CauldronConfig.getBoolean("plugin-settings.default.remap-nms-v1_5_R3", true);
        String remapNMSPre = CauldronConfig.getString("plugin-settings.default.remap-nms-pre", "false");
        boolean remapOBC172 = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_7_R1", true);
        boolean remapOBC164 = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R3", true);
        boolean remapOBC162 = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R2", true);
        boolean remapOBC161 = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_6_R1", true);
        boolean remapOBC152 = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-v1_5_R3", true);
        boolean remapOBCPre = CauldronConfig.getBoolean("plugin-settings.default.remap-obc-pre", false);
        boolean globalInherit = CauldronConfig.getBoolean("plugin-settings.default.global-inheritance", true);
        boolean pluginInherit = CauldronConfig.getBoolean("plugin-settings.default.plugin-inheritance", true);
        boolean reflectFields = CauldronConfig.getBoolean("plugin-settings.default.remap-reflect-field", true);
        boolean reflectClass = CauldronConfig.getBoolean("plugin-settings.default.remap-reflect-class", true);
        boolean allowFuture = CauldronConfig.getBoolean("plugin-settings.default.remap-allow-future", false);
        useCustomClassLoader = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".custom-class-loader", useCustomClassLoader, false);
        this.debug = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".debug", this.debug, false);
        useGuava10 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".use-guava10", useGuava10, false);
        remapNMS172 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_7_R1", remapNMS172, false);
        remapNMS164 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R3", remapNMS164, false);
        remapNMS162 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R2", remapNMS162, false);
        remapNMS161 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_6_R1", remapNMS161, false);
        remapNMS152 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-nms-v1_5_R3", remapNMS152, false);
        remapNMSPre = CauldronConfig.getString("plugin-settings." + pluginName + ".remap-nms-pre", remapNMSPre, false);
        remapOBC172 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_7_R1", remapOBC172, false);
        remapOBC164 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R3", remapOBC164, false);
        remapOBC162 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R2", remapOBC162, false);
        remapOBC161 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_6_R1", remapOBC161, false);
        remapOBC152 = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-v1_5_R3", remapOBC152, false);
        remapOBCPre = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-obc-pre", remapOBCPre, false);
        globalInherit = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".global-inheritance", globalInherit, false);
        pluginInherit = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".plugin-inheritance", pluginInherit, false);
        reflectFields = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-field", reflectFields, false);
        reflectClass = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-reflect-class", reflectClass, false);
        allowFuture = CauldronConfig.getBoolean("plugin-settings." + pluginName + ".remap-allow-future", allowFuture, false);
        if (this.debug) {
            System.out.println("PluginClassLoader debugging enabled for " + pluginName);
        }
        if (!useCustomClassLoader) {
            this.remapper = null;
            return;
        }
        int flags = 0;
        if (useGuava10) {
            flags |= 2;
        }
        if (remapNMS172) {
            flags |= 0x100;
        }
        if (remapNMS164) {
            flags |= 0x80;
        }
        if (remapNMS162) {
            flags |= 0x40;
        }
        if (remapNMS161) {
            flags |= 0x20;
        }
        if (remapNMS152) {
            flags |= 0x10;
        }
        if (!remapNMSPre.equals("false")) {
            if (remapNMSPre.equals("1.7.2")) {
                flags |= 0x17200000;
            } else if (remapNMSPre.equals("1.6.4")) {
                flags |= 0x16400000;
            } else if (remapNMSPre.equals("1.6.2")) {
                flags |= 0x16200000;
            } else if (remapNMSPre.equals("1.6.1")) {
                flags |= 0x16100000;
            } else if (remapNMSPre.equals("1.5.2")) {
                flags |= 0x15200000;
            } else {
                System.out.println("Unsupported nms-remap-pre version '" + remapNMSPre + "', disabling");
            }
        }
        if (remapOBC172) {
            flags |= 0x2000;
        }
        if (remapOBC164) {
            flags |= 0x1000;
        }
        if (remapOBC162) {
            flags |= 0x800;
        }
        if (remapOBC161) {
            flags |= 0x400;
        }
        if (remapOBC152) {
            flags |= 0x200;
        }
        if (remapOBCPre) {
            flags |= 8;
        }
        if (globalInherit) {
            flags |= 4;
        }
        JarMapping jarMapping = this.getJarMapping(flags);
        if ((flags & 4) != 0) {
            if (this.debug) {
                System.out.println("Enabling global inheritance remapping");
            }
            jarMapping.setInheritanceMap(loader.getGlobalInheritanceMap());
            jarMapping.setFallbackInheritanceProvider((InheritanceProvider)new ClassLoaderProvider((ClassLoader)this));
        }
        this.remapper = new JarRemapper(jarMapping);
        if (pluginInherit || reflectFields || reflectClass) {
            this.remapperProcessor = new RemapperProcessor(pluginInherit ? loader.getGlobalInheritanceMap() : null, (JarMapping)(reflectFields || reflectClass ? jarMapping : null));
            this.remapperProcessor.setRemapReflectField(reflectFields);
            this.remapperProcessor.setRemapReflectClass(reflectClass);
            this.remapperProcessor.debug = this.debug;
        } else {
            this.remapperProcessor = null;
        }
        try {
            Class<JavaPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new InvalidPluginException("Cannot find main class `" + description.getMain() + "'", ex);
            }
            try {
                pluginClass = jarClass.asSubclass(JavaPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new InvalidPluginException("main class `" + description.getMain() + "' does not extend JavaPlugin", ex);
            }
            this.plugin = pluginClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPluginException("No public constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new InvalidPluginException("Abnormal plugin type", ex);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    public static String getNativeVersion() {
        String packageName = CraftServer.class.getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    private void loadNmsMappings(JarMapping jarMapping, String obfVersion) throws IOException {
        HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("net.minecraft.server", "net.minecraft.server." + obfVersion);
        if (obfVersion.contains("v1_7_R")) {
            obfVersion = "v1_7_R1";
        }
        jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/cb2numpkg.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
        if (obfVersion.equals("v1_7_R1")) {
            jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream("mappings/" + obfVersion + "/obf2numpkg.srg"))), (MappingTransformer)new MavenShade(relocations), null, false);
        }
        jarMapping.methods.put("net/minecraft/server/" + obfVersion + "/PlayerConnection/getPlayer ()Lorg/bukkit/craftbukkit/" + PluginClassLoader.getNativeVersion() + "/entity/CraftPlayer;", "getPlayerB");
    }

    private JarMapping getJarMapping(int flags) {
        JarMapping jarMapping = (JarMapping)jarMappings.get(flags);
        if (jarMapping != null) {
            if (this.debug) {
                System.out.println("Mapping reused for " + Integer.toHexString(flags));
            }
            return jarMapping;
        }
        jarMapping = new JarMapping();
        try {
            if ((flags & 2) != 0) {
                jarMapping.packages.put("com/google/common", "guava10/com/google/common");
            }
            jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/com/google/gson", "com/google/gson");
            jarMapping.packages.put("net/minecraft/util/io", "io");
            jarMapping.packages.put("net/minecraft/util/com", "com");
            jarMapping.packages.put("net/minecraft/util/gnu", "gnu");
            jarMapping.packages.put("net/minecraft/util/org", "org");
            if ((flags & 0x100) != 0) {
                this.loadNmsMappings(jarMapping, "v1_7_R1");
                this.loadNmsMappings(jarMapping, "v1_7_R2");
                this.loadNmsMappings(jarMapping, "v1_7_R3");
            }
            if ((flags & 0x80) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R3");
            }
            if ((flags & 0x40) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R2");
            }
            if ((flags & 0x20) != 0) {
                this.loadNmsMappings(jarMapping, "v1_6_R1");
            }
            if ((flags & 0x10) != 0) {
                this.loadNmsMappings(jarMapping, "v1_5_R3");
            }
            if ((flags & 0x2000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R2", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_7_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x1000) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x800) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R2", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x400) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_6_R1", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0x200) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/v1_5_R3", org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 8) != 0) {
                jarMapping.packages.put(org_bukkit_craftbukkit + "/libs/org/objectweb/asm", "org/objectweb/asm");
                jarMapping.packages.put(org_bukkit_craftbukkit, org_bukkit_craftbukkit + "/" + PluginClassLoader.getNativeVersion());
            }
            if ((flags & 0xFFF00000) != 0) {
                String filename;
                switch (flags & 0xFFF00000) {
                    case 24248320: {
                        filename = "mappings/v1_7_R1/cb2numpkg.srg";
                        break;
                    }
                    case 23330816: {
                        filename = "mappings/v1_6_R3/cb2numpkg.srg";
                        break;
                    }
                    case 23199744: {
                        filename = "mappings/v1_6_R2/cb2numpkg.srg";
                        break;
                    }
                    case 0x1610000: {
                        filename = "mappings/v1_6_R1/cb2numpkg.srg";
                        break;
                    }
                    case 0x1510000: {
                        filename = "mappings/v1_5_R2/cb2numpkg.srg";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid unversioned mapping flags: " + Integer.toHexString(flags & 0xFFF00000) + " in " + Integer.toHexString(flags));
                    }
                }
                jarMapping.loadMappings(new BufferedReader(new InputStreamReader(this.loader.getClass().getClassLoader().getResourceAsStream(filename))), null, null, false);
            }
            System.out.println("Mapping loaded " + jarMapping.packages.size() + " packages, " + jarMapping.classes.size() + " classes, " + jarMapping.fields.size() + " fields, " + jarMapping.methods.size() + " methods, flags " + Integer.toHexString(flags));
            JarMapping currentJarMapping = jarMappings.putIfAbsent(flags, jarMapping);
            return currentJarMapping == null ? jarMapping : currentJarMapping;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        if (name.startsWith("org.bukkit.") || name.startsWith("net.minecraft.")) {
            if (this.debug) {
                System.out.println("Unexpected plugin findClass on OBC/NMS: name=" + name + ", checkGlobal=" + checkGlobal + "; returning not found");
            }
            throw new ClassNotFoundException(name);
        }
        String string = name.intern();
        synchronized (string) {
            Class<?> result = (Class<?>)this.classes.get(name);
            if (result == null) {
                Class<?> old;
                if (checkGlobal) {
                    result = this.loader.getClassByName(name);
                }
                if (result == null && (result = this.remapper == null ? super.findClass(name) : this.remappedFindClass(name)) != null) {
                    this.loader.setClass(name, result);
                }
                if (result != null && (old = this.classes.putIfAbsent(name, result)) != null && old != result) {
                    System.err.println("Defined class " + name + " twice as different classes, " + result + " and " + old);
                    result = old;
                }
            }
            return result;
        }
    }

    private Class<?> remappedFindClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block8: {
            result = null;
            try {
                JarURLConnection jarURLConnection;
                URL jarURL;
                CodeSource codeSource;
                InputStream stream;
                String path = name.replace('.', '/').concat(".class");
                URL url = this.findResource(path);
                if (url == null || (stream = url.openStream()) == null) break block8;
                byte[] bytecode = null;
                if (this.remapperProcessor != null && (bytecode = this.remapperProcessor.process(stream)) == null) {
                    stream = url.openStream();
                }
                byte[] remappedBytecode = this.remapper.remapClassFile(bytecode, (ClassRepo)RuntimeRepo.getInstance());
                if (this.debug) {
                    File file = new File("remapped-plugin-classes/" + name + ".class");
                    file.getParentFile().mkdirs();
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(remappedBytecode);
                        fileOutputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if ((result = this.defineClass(name, remappedBytecode, 0, remappedBytecode.length, codeSource = new CodeSource(jarURL = (jarURLConnection = (JarURLConnection)url.openConnection()).getJarFileURL(), new CodeSigner[0]))) != null) {
                    this.resolveClass(result);
                }
            }
            catch (Throwable t) {
                if (this.debug) {
                    System.out.println("remappedFindClass(" + name + ") exception: " + t);
                    t.printStackTrace();
                }
                throw new ClassNotFoundException("Failed to remap class " + name, t);
            }
        }
        return result;
    }

    Set<String> getClasses() {
        return this.classes.keySet();
    }

    synchronized void initialize(JavaPlugin javaPlugin) {
        Validate.notNull((Object)javaPlugin, (String)"Initializing plugin cannot be null");
        Validate.isTrue((javaPlugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (String)"Cannot initialize plugin outside of this class loader");
        if (this.plugin != null || this.pluginInit != null) {
            throw new IllegalArgumentException("Plugin already initialized!", this.pluginState);
        }
        this.pluginState = new IllegalStateException("Initial initialization");
        this.pluginInit = javaPlugin;
        javaPlugin.init(this.loader, this.loader.server, this.description, this.dataFolder, this.file, this);
    }
}

