/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameData;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.Level;

public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;
    private static Map<String, Boolean> configWorldGenCache;
    private static Map<String, String> worldGenMap;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        String modId = Loader.instance().activeModContainer().getModId();
        modId = modId.replaceAll("[^A-Za-z0-9]", "");
        modId.replace(" ", "_");
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
        worldGenMap.put(generator.getClass().getName(), modId);
    }

    public static void generateWorld(int chunkX, int chunkZ, afn world, aog chunkGenerator, aog chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long worldSeed = world.G();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        boolean before = ((mj)world).b.a;
        ((mj)world).b.a = true;
        for (IWorldGenerator generator : worldGenerators) {
            if (!configWorldGenCache.containsKey(generator.getClass().getName())) {
                String modId = worldGenMap.get(generator.getClass().getName());
                String generatorName = "";
                generatorName = modId + "-" + generator.getClass().getSimpleName();
                boolean generatorEnabled = world.mcpcConfig.getBoolean("worldgen-" + generatorName, true);
                configWorldGenCache.put(generator.getClass().getName(), generatorEnabled);
            }
            if (!configWorldGenCache.get(generator.getClass().getName()).booleanValue()) continue;
            fmlRandom.setSeed(chunkSeed);
            generator.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
        world.mcpcConfig.save();
        ((mj)world).b.a = before;
    }

    private static void computeSortedGeneratorList() {
        ArrayList list = Lists.newArrayList(worldGenerators);
        Collections.sort(list, new Comparator<IWorldGenerator>(){

            @Override
            public int compare(IWorldGenerator o1, IWorldGenerator o2) {
                return Ints.compare((int)((Integer)worldGeneratorIndex.get(o1)), (int)((Integer)worldGeneratorIndex.get(o2)));
            }
        });
        sortedGeneratorList = ImmutableList.copyOf((Collection)list);
    }

    public static void registerItem(abn item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static abn registerItem(abn item, String name, String modId) {
        GameData.getMain().registerItem(item, name);
        return item;
    }

    public static void addAlias(String alias, String forName, Type type) {
    }

    public static ahu registerBlock(ahu block, String name) {
        return GameRegistry.registerBlock(block, zt.class, name);
    }

    public static ahu registerBlock(ahu block, Class<? extends zt> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, new Object[0]);
    }

    @Deprecated
    public static ahu registerBlock(ahu block, Class<? extends zt> itemclass, String name, String modId, Object ... itemCtorArgs) {
        return GameRegistry.registerBlock(block, itemclass, name, itemCtorArgs);
    }

    public static ahu registerBlock(ahu block, Class<? extends zt> itemclass, String name, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            zt i = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
                ctorArgClasses[0] = ahu.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
                }
                Constructor<? extends zt> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlock(block, name);
            if (i != null) {
                GameData.getMain().registerItem((abn)i, name);
            }
            return block;
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(e);
        }
    }

    public static void addRecipe(abp output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static ads addShapedRecipe(abp output, Object ... params) {
        return adq.a().a(output, params);
    }

    public static void addShapelessRecipe(abp output, Object ... params) {
        adq.a().b(output, params);
    }

    public static void addRecipe(ads recipe) {
        adq.a().b().add(recipe);
    }

    public static void addSmelting(ahu input, abp output, float xp) {
        adm.a().a(input, output, xp);
    }

    public static void addSmelting(abn input, abp output, float xp) {
        adm.a().a(input, output, xp);
    }

    public static void addSmelting(abp input, abp output, float xp) {
        adm.a().a(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends and> tileEntityClass, String id) {
        and.a(tileEntityClass, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends and> tileEntityClass, String id, String ... alternatives) {
        and.a(tileEntityClass, (String)id);
        Map teMappings = (Map)ObfuscationReflectionHelper.getPrivateValue(and.class, null, "field_145855_i", "nameToClassMap");
        for (String s : alternatives) {
            if (teMappings.containsKey(s)) continue;
            teMappings.put(s, tileEntityClass);
        }
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(abp itemStack) {
        int fuelValue = 0;
        for (IFuelHandler handler : fuelHandlers) {
            fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
        }
        return fuelValue;
    }

    public static ahu findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static abn findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, abp itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static abp findItemStack(String modId, String name, int stackSize) {
        abp foundStack = GameData.findItemStack(modId, name);
        if (foundStack != null) {
            abp is = foundStack.m();
            is.b = Math.min(stackSize, is.e());
            return is;
        }
        return null;
    }

    public static UniqueIdentifier findUniqueIdentifierFor(ahu block) {
        return GameData.getUniqueName(block);
    }

    public static UniqueIdentifier findUniqueIdentifierFor(abn item) {
        return GameData.getUniqueName(item);
    }

    static {
        configWorldGenCache = new HashMap<String, Boolean>();
        worldGenMap = new HashMap<String, String>();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ObjectHolder {
        public String value();
    }

    public static enum Type {
        BLOCK,
        ITEM;

    }

    public static final class UniqueIdentifier {
        public final String modId;
        public final String name;

        UniqueIdentifier(String modId, String name) {
            this.modId = modId;
            this.name = name;
        }

        public UniqueIdentifier(String string) {
            String[] parts = string.split(":");
            this.modId = parts[0];
            this.name = parts[1];
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            UniqueIdentifier other = (UniqueIdentifier)obj;
            return Objects.equal((Object)this.modId, (Object)other.modId) && Objects.equal((Object)this.name, (Object)other.name);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.modId, this.name});
        }

        public String toString() {
            return String.format("%s:%s", this.modId, this.name);
        }
    }
}

