/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PublicKey;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;

class ThreadPlayerLookupUUID
extends Thread {
    final nd field_151292_a;

    ThreadPlayerLookupUUID(nd p_i45296_1_, String p_i45296_2_) {
        super(p_i45296_2_);
        this.field_151292_a = p_i45296_1_;
    }

    @Override
    public void run() {
        try {
            if (!MinecraftServer.G().W()) {
                this.fireLoginEvents();
                nd.setLoginState((nd)this.field_151292_a, (nf)nf.d);
                return;
            }
            String s = new BigInteger(oh.a((String)nd.getLoginServerId((nd)this.field_151292_a), (PublicKey)nd.getMinecraftServer((nd)this.field_151292_a).I().getPublic(), (SecretKey)nd.getSecretKey((nd)this.field_151292_a))).toString(16);
            nd.doGameProfilesMatch((nd)this.field_151292_a, (GameProfile)nd.getMinecraftServer((nd)this.field_151292_a).as().hasJoinedServer(new GameProfile((String)null, nd.getGameProfile((nd)this.field_151292_a).getName()), s));
            if (nd.getGameProfile((nd)this.field_151292_a) != null) {
                this.fireLoginEvents();
                nd.getLogger().info("UUID of player " + nd.getGameProfile((nd)this.field_151292_a).getName() + " is " + nd.getGameProfile((nd)this.field_151292_a).getId());
                nd.setLoginState((nd)this.field_151292_a, (nf)nf.d);
            } else {
                this.field_151292_a.a("Failed to verify username!");
                nd.getLogger().error("Username '" + nd.getGameProfile((nd)this.field_151292_a).getName() + "' tried to join with an invalid session");
            }
        }
        catch (AuthenticationUnavailableException authenticationunavailableexception) {
            this.field_151292_a.a("Authentication servers are down. Please try again later, sorry!");
            nd.getLogger().error("Couldn't verify username because servers are unavailable");
        }
        catch (Exception exception) {
            this.field_151292_a.a("Failed to verify username!");
            nd.getMinecraftServer((nd)this.field_151292_a).server.getLogger().log(Level.WARNING, "Exception verifying " + nd.getGameProfile((nd)this.field_151292_a).getName(), exception);
        }
    }

    private void fireLoginEvents() throws Exception {
        if (!this.field_151292_a.a.d()) {
            return;
        }
        String playerName = nd.getGameProfile((nd)this.field_151292_a).getName();
        InetAddress address = ((InetSocketAddress)this.field_151292_a.a.b()).getAddress();
        final CraftServer server = nd.getMinecraftServer((nd)this.field_151292_a).server;
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address);
        server.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            };
            nd.getMinecraftServer((nd)this.field_151292_a).processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.field_151292_a.a(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.field_151292_a.a(asyncEvent.getKickMessage());
            return;
        }
    }
}

