/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import cpw.mods.fml.common.eventhandler.Cancelable;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.block.BlockBreakEvent;

public class BlockEvent
extends Event {
    public final int x;
    public final int y;
    public final int z;
    public final afn world;
    public final ahu block;
    public final int blockMetadata;

    public BlockEvent(int x, int y2, int z2, afn world, ahu block, int blockMetadata) {
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.world = world;
        this.block = block;
        this.blockMetadata = blockMetadata;
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final xl player;
        private int exp;

        public BreakEvent(int x, int y2, int z2, afn world, ahu block, int blockMetadata, xl player) {
            super(x, y2, z2, world, block, blockMetadata);
            this.player = player;
            BlockBreakEvent bukkitEvent = CraftEventFactory.callBlockBreakEvent(world, x, y2, z2, block, blockMetadata, (mm)player);
            if (bukkitEvent.isCancelled()) {
                this.setCanceled(true);
            } else {
                this.exp = bukkitEvent.getExpToDrop();
            }
        }

        public xl getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }

    public static class HarvestDropsEvent
    extends BlockEvent {
        public final int fortuneLevel;
        public final ArrayList<abp> drops;
        public final boolean isSilkTouching;
        public float dropChance;
        public final xl harvester;

        public HarvestDropsEvent(int x, int y2, int z2, afn world, ahu block, int blockMetadata, int fortuneLevel, float dropChance, ArrayList<abp> drops, xl harvester, boolean isSilkTouching) {
            super(x, y2, z2, world, block, blockMetadata);
            this.fortuneLevel = fortuneLevel;
            this.dropChance = dropChance;
            this.drops = drops;
            this.isSilkTouching = isSilkTouching;
            this.harvester = harvester;
        }
    }
}

