/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.CaseFormat;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Achievement;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.entity.EntityType;

public class CraftStatistic {
    private static final BiMap<String, Statistic> statistics;
    private static final BiMap<String, Achievement> achievements;

    private CraftStatistic() {
    }

    public static Achievement getBukkitAchievement(np achievement) {
        return CraftStatistic.getBukkitAchievementByName(achievement.e);
    }

    public static Achievement getBukkitAchievementByName(String name) {
        return (Achievement)((Object)achievements.get((Object)name));
    }

    public static Statistic getBukkitStatistic(nv statistic) {
        return CraftStatistic.getBukkitStatisticByName(statistic.e);
    }

    public static Statistic getBukkitStatisticByName(String name) {
        if (name.startsWith("stat.killEntity")) {
            name = "stat.killEntity";
        }
        if (name.startsWith("stat.entityKilledBy")) {
            name = "stat.entityKilledBy";
        }
        if (name.startsWith("stat.breakItem")) {
            name = "stat.breakItem";
        }
        if (name.startsWith("stat.useItem")) {
            name = "stat.useItem";
        }
        if (name.startsWith("stat.mineBlock")) {
            name = "stat.mineBlock";
        }
        if (name.startsWith("stat.craftItem")) {
            name = "stat.craftItem";
        }
        return (Statistic)((Object)statistics.get((Object)name));
    }

    public static nv getNMSStatistic(Statistic statistic) {
        return od.a((String)((String)statistics.inverse().get((Object)statistic)));
    }

    public static np getNMSAchievement(Achievement achievement) {
        return (np)od.a((String)((String)achievements.inverse().get((Object)achievement)));
    }

    public static nv getMaterialStatistic(Statistic stat, Material material) {
        try {
            if (stat == Statistic.MINE_BLOCK) {
                return od.C[material.getId()];
            }
            if (stat == Statistic.CRAFT_ITEM) {
                return od.D[material.getId()];
            }
            if (stat == Statistic.USE_ITEM) {
                return od.E[material.getId()];
            }
            if (stat == Statistic.BREAK_ITEM) {
                return od.F[material.getId()];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        return null;
    }

    public static nv getEntityStatistic(Statistic stat, EntityType entity) {
        qu entityEggInfo = (qu)qt.a.get(entity.getTypeId());
        if (entityEggInfo != null) {
            return entityEggInfo.d;
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(nv statistic) {
        String statisticString = statistic.e;
        return EntityType.fromName(statisticString.substring(statisticString.lastIndexOf(".") + 1));
    }

    public static Material getMaterialFromStatistic(nv statistic) {
        int id;
        String statisticString = statistic.e;
        try {
            id = Integer.valueOf(statisticString.substring(statisticString.lastIndexOf(".") + 1));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return Material.getMaterial(id);
    }

    static {
        ImmutableMap specialCases = ImmutableMap.builder().put((Object)"achievement.buildWorkBench", (Object)Achievement.BUILD_WORKBENCH).put((Object)"achievement.diamonds", (Object)Achievement.GET_DIAMONDS).put((Object)"achievement.portal", (Object)Achievement.NETHER_PORTAL).put((Object)"achievement.ghast", (Object)Achievement.GHAST_RETURN).put((Object)"achievement.theEnd", (Object)Achievement.END_PORTAL).put((Object)"achievement.theEnd2", (Object)Achievement.THE_END).put((Object)"achievement.blazeRod", (Object)Achievement.GET_BLAZE_ROD).put((Object)"achievement.potion", (Object)Achievement.BREW_POTION).build();
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder achievementBuilder = ImmutableBiMap.builder();
        for (Statistic statistic : Statistic.values()) {
            if (statistic == Statistic.PLAY_ONE_TICK) {
                statisticBuilder.put((Object)"stat.playOneMinute", (Object)statistic);
                continue;
            }
            statisticBuilder.put((Object)("stat." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, statistic.name())), (Object)statistic);
        }
        for (Enum enum_ : Achievement.values()) {
            if (specialCases.values().contains((Object)enum_)) continue;
            achievementBuilder.put((Object)("achievement." + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, enum_.name())), (Object)enum_);
        }
        achievementBuilder.putAll((Map)specialCases);
        statistics = statisticBuilder.build();
        achievements = achievementBuilder.build();
    }
}

