/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.UnsupportedTerminal;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.CraftServer;

public class Main {
    public static boolean useJline = true;
    public static boolean useConsole = true;
    public static YamlConfiguration configuration;
    public static File configFile;

    public static void main(String[] args) {
        Main.loadOptions(args);
        MinecraftServer.main((String[])args);
    }

    public static OptionSet loadOptions(String[] args) {
        OptionParser parser = new OptionParser(){
            {
                this.acceptsAll(Main.asList(new String[]{"?", "help"}), "Show the help");
                this.acceptsAll(Main.asList(new String[]{"c", "config"}), "Properties file to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("server.properties"), (Object[])new File[0]).describedAs("Properties file");
                this.acceptsAll(Main.asList(new String[]{"P", "plugins"}), "Plugin directory to use").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("plugins"), (Object[])new File[0]).describedAs("Plugin directory");
                this.acceptsAll(Main.asList(new String[]{"h", "host", "server-ip"}), "Host to listen on").withRequiredArg().ofType(String.class).describedAs("Hostname or IP");
                this.acceptsAll(Main.asList(new String[]{"W", "world-dir", "universe", "world-container"}), "World container").withRequiredArg().ofType(File.class).describedAs("Directory containing worlds");
                this.acceptsAll(Main.asList(new String[]{"w", "world", "level-name"}), "World name").withRequiredArg().ofType(String.class).describedAs("World name");
                this.acceptsAll(Main.asList(new String[]{"p", "port", "server-port"}), "Port to listen on").withRequiredArg().ofType(Integer.class).describedAs("Port");
                this.acceptsAll(Main.asList(new String[]{"o", "online-mode"}), "Whether to use online authentication").withRequiredArg().ofType(Boolean.class).describedAs("Authentication");
                this.acceptsAll(Main.asList(new String[]{"s", "size", "max-players"}), "Maximum amount of players").withRequiredArg().ofType(Integer.class).describedAs("Server size");
                this.acceptsAll(Main.asList(new String[]{"d", "date-format"}), "Format of the date to display in the console (for log entries)").withRequiredArg().ofType(SimpleDateFormat.class).describedAs("Log date format");
                this.acceptsAll(Main.asList(new String[]{"log-pattern"}), "Specfies the log filename pattern").withRequiredArg().ofType(String.class).defaultsTo((Object)"server.log", (Object[])new String[0]).describedAs("Log filename");
                this.acceptsAll(Main.asList(new String[]{"log-limit"}), "Limits the maximum size of the log file (0 = unlimited)").withRequiredArg().ofType(Integer.class).defaultsTo((Object)0, (Object[])new Integer[0]).describedAs("Max log size");
                this.acceptsAll(Main.asList(new String[]{"log-count"}), "Specified how many log files to cycle through").withRequiredArg().ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]).describedAs("Log count");
                this.acceptsAll(Main.asList(new String[]{"log-append"}), "Whether to append to the log file").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]).describedAs("Log append");
                this.acceptsAll(Main.asList(new String[]{"log-strip-color"}), "Strips color codes from log file");
                this.acceptsAll(Main.asList(new String[]{"b", "bukkit-settings"}), "File for bukkit settings").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("bukkit.yml"), (Object[])new File[0]).describedAs("Yml file");
                this.acceptsAll(Main.asList(new String[]{"nojline"}), "Disables jline and emulates the vanilla console");
                this.acceptsAll(Main.asList(new String[]{"noconsole"}), "Disables the console");
                this.acceptsAll(Main.asList(new String[]{"v", "version"}), "Show the CraftBukkit Version");
                this.acceptsAll(Main.asList(new String[]{"demo"}), "Demo mode");
            }
        };
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, ex.getLocalizedMessage());
        }
        if (options == null || options.has("?")) {
            try {
                parser.printHelpOn((OutputStream)System.out);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (options.has("v")) {
            System.out.println(CraftServer.class.getPackage().getImplementationVersion());
        } else {
            try {
                String jline_UnsupportedTerminal = new String(new char[]{'j', 'l', 'i', 'n', 'e', '.', 'U', 'n', 's', 'u', 'p', 'p', 'o', 'r', 't', 'e', 'd', 'T', 'e', 'r', 'm', 'i', 'n', 'a', 'l'});
                String jline_terminal = new String(new char[]{'j', 'l', 'i', 'n', 'e', '.', 't', 'e', 'r', 'm', 'i', 'n', 'a', 'l'});
                boolean bl2 = useJline = !jline_UnsupportedTerminal.equals(System.getProperty(jline_terminal));
                if (options.has("nojline")) {
                    System.setProperty("user.language", "en");
                    useJline = false;
                }
                if (!useJline) {
                    System.setProperty("jline.terminal", UnsupportedTerminal.class.getName());
                }
                if (options.has("noconsole")) {
                    useConsole = false;
                }
                int maxPermGen = 0;
                for (String s : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                    if (!s.startsWith("-XX:MaxPermSize")) continue;
                    maxPermGen = Integer.parseInt(s.replaceAll("[^\\d]", ""));
                    maxPermGen <<= 10 * "kmg".indexOf(Character.toLowerCase(s.charAt(s.length() - 1)));
                }
                if (maxPermGen < 131072) {
                    System.out.println("Warning, your max perm gen size is not set or less than 128mb. It is recommended you restart Java with the following argument: -XX:MaxPermSize=128M");
                }
                configFile = (File)options.valueOf("bukkit-settings");
                configuration = YamlConfiguration.loadConfiguration(configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults(YamlConfiguration.loadConfiguration(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml")));
                try {
                    configuration.save(configFile);
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, "Could not save " + configFile, ex);
                }
                return options;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private static List<String> asList(String ... params) {
        return Arrays.asList(params);
    }
}

