/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CraftBlockState
implements BlockState {
    private final CraftWorld world;
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;
    protected int type;
    protected MaterialData data;
    protected int flag;
    protected final byte light;

    public CraftBlockState(Block block) {
        this.world = (CraftWorld)block.getWorld();
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.type = block.getTypeId();
        this.light = block.getLightLevel();
        this.chunk = (CraftChunk)block.getChunk();
        this.flag = 3;
        this.createData(block.getData());
    }

    public CraftBlockState(Block block, int flag) {
        this(block);
        this.flag = flag;
    }

    public static CraftBlockState getBlockState(afn world, int x, int y2, int z2) {
        return new CraftBlockState(world.getWorld().getBlockAt(x, y2, z2));
    }

    public static CraftBlockState getBlockState(afn world, int x, int y2, int z2, int flag) {
        return new CraftBlockState(world.getWorld().getBlockAt(x, y2, z2), flag);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setData(MaterialData data) {
        Material mat = this.getType();
        if (mat == null || mat.getData() == null) {
            this.data = data;
        } else if (data.getClass() == mat.getData() || data.getClass() == MaterialData.class) {
            this.data = data;
        } else {
            throw new IllegalArgumentException("Provided data is not of type " + mat.getData().getName() + ", found " + data.getClass().getName());
        }
    }

    @Override
    public MaterialData getData() {
        return this.data;
    }

    @Override
    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    @Override
    public boolean setTypeId(int type) {
        if (this.type != type) {
            this.type = type;
            this.createData((byte)0);
        }
        return true;
    }

    @Override
    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getFlag() {
        return this.flag;
    }

    @Override
    public int getTypeId() {
        return this.type;
    }

    @Override
    public byte getLightLevel() {
        return this.light;
    }

    @Override
    public Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    @Override
    public boolean update() {
        return this.update(false);
    }

    @Override
    public boolean update(boolean force) {
        return this.update(force, true);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        Block block = this.getBlock();
        if (block.getType() != this.getType()) {
            if (force) {
                block.setTypeId(this.getTypeId(), applyPhysics);
            } else {
                return false;
            }
        }
        block.setData(this.getRawData(), applyPhysics);
        this.world.getHandle().g(this.x, this.y, this.z);
        return true;
    }

    private void createData(byte data) {
        Material mat = this.getType();
        this.data = mat == null || mat.getData() == null ? new MaterialData(this.type, data) : mat.getNewData(data);
    }

    @Override
    public byte getRawData() {
        return this.data.getData();
    }

    @Override
    public Location getLocation() {
        return new Location(this.world, this.x, this.y, this.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.world);
            loc.setX(this.x);
            loc.setY(this.y);
            loc.setZ(this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    @Override
    public void setRawData(byte data) {
        this.data.setData(data);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftBlockState other = (CraftBlockState)obj;
        if (!(this.world == other.world || this.world != null && this.world.equals(other.world))) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.data == other.data || this.data != null && this.data.equals(other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.world != null ? this.world.hashCode() : 0);
        hash = 73 * hash + this.x;
        hash = 73 * hash + this.y;
        hash = 73 * hash + this.z;
        hash = 73 * hash + this.type;
        hash = 73 * hash + (this.data != null ? this.data.hashCode() : 0);
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this.getBlock(), metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this.getBlock(), metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this.getBlock(), metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this.getBlock(), metadataKey, owningPlugin);
    }
}

