/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftInventoryDoubleChest;
import org.bukkit.inventory.Inventory;

public class CraftChest
extends CraftBlockState
implements Chest {
    private final CraftWorld world;
    private final ani chest;

    public CraftChest(Block block) {
        super(block);
        this.world = (CraftWorld)block.getWorld();
        this.chest = (ani)this.world.getTileEntityAt(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Inventory getBlockInventory() {
        return new CraftInventory((po)this.chest);
    }

    @Override
    public Inventory getInventory() {
        CraftInventory right;
        CraftInventory left;
        int id;
        int x = this.getX();
        int y2 = this.getY();
        int z2 = this.getZ();
        CraftInventory inventory = new CraftInventory((po)this.chest);
        if (this.world.getBlockTypeIdAt(x, y2, z2) == Material.CHEST.getId()) {
            id = Material.CHEST.getId();
        } else if (this.world.getBlockTypeIdAt(x, y2, z2) == Material.TRAPPED_CHEST.getId()) {
            id = Material.TRAPPED_CHEST.getId();
        } else {
            throw new IllegalStateException("CraftChest is not a chest but is instead " + this.world.getBlockAt(x, y2, z2));
        }
        if (this.world.getBlockTypeIdAt(x - 1, y2, z2) == id) {
            left = new CraftInventory((po)((ani)this.world.getHandle().o(x - 1, y2, z2)));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (this.world.getBlockTypeIdAt(x + 1, y2, z2) == id) {
            right = new CraftInventory((po)((ani)this.world.getHandle().o(x + 1, y2, z2)));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        if (this.world.getBlockTypeIdAt(x, y2, z2 - 1) == id) {
            left = new CraftInventory((po)((ani)this.world.getHandle().o(x, y2, z2 - 1)));
            inventory = new CraftInventoryDoubleChest(left, inventory);
        }
        if (this.world.getBlockTypeIdAt(x, y2, z2 + 1) == id) {
            right = new CraftInventory((po)((ani)this.world.getHandle().o(x, y2, z2 + 1)));
            inventory = new CraftInventoryDoubleChest(inventory, right);
        }
        return inventory;
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result) {
            this.chest.e();
        }
        return result;
    }
}

