/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.chunkio;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.chunkio.QueuedChunk;
import org.bukkit.craftbukkit.util.AsynchronousExecutor;
import org.bukkit.craftbukkit.util.LongHash;
import org.bukkit.event.world.ChunkLoadEvent;

class ChunkIOProvider
implements AsynchronousExecutor.CallBackProvider<QueuedChunk, aoj, Runnable, RuntimeException> {
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    ChunkIOProvider() {
    }

    @Override
    public aoj callStage1(QueuedChunk queuedChunk) throws RuntimeException {
        aow loader = queuedChunk.loader;
        Object[] data = loader.loadChunk__Async_CB(queuedChunk.world, queuedChunk.x, queuedChunk.z);
        if (data != null) {
            queuedChunk.compound = (dg)data[1];
            return (aoj)data[0];
        }
        return null;
    }

    @Override
    public void callStage2(QueuedChunk queuedChunk, aoj chunk) throws RuntimeException {
        CraftServer server;
        if (chunk == null) {
            queuedChunk.provider.originalGetChunkAt(queuedChunk.x, queuedChunk.z);
            return;
        }
        queuedChunk.loader.loadEntities(chunk, queuedChunk.compound.m("Level"), queuedChunk.world);
        MinecraftForge.EVENT_BUS.post(new ChunkDataEvent.Load(chunk, queuedChunk.compound));
        chunk.p = queuedChunk.provider.i.H();
        queuedChunk.provider.g.put(LongHash.toLong(queuedChunk.x, queuedChunk.z), chunk);
        queuedChunk.provider.h.add(chunk);
        chunk.c();
        if (queuedChunk.provider.e != null) {
            queuedChunk.provider.e.e(queuedChunk.x, queuedChunk.z);
        }
        if ((server = queuedChunk.provider.i.getServer()) != null) {
            server.getPluginManager().callEvent(new ChunkLoadEvent(chunk.bukkitChunk, false));
        }
        chunk.a((aog)queuedChunk.provider, (aog)queuedChunk.provider, queuedChunk.x, queuedChunk.z);
    }

    @Override
    public void callStage3(QueuedChunk queuedChunk, aoj chunk, Runnable runnable) throws RuntimeException {
        runnable.run();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "Chunk I/O Executor Thread-" + this.threadNumber.getAndIncrement());
        thread.setDaemon(true);
        return thread;
    }
}

