/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.inventory.CraftInventoryHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.HorseInventory;

public class CraftHorse
extends CraftAnimals
implements Horse {
    public CraftHorse(CraftServer server, uu entity) {
        super(server, (ur)entity);
    }

    public uu getHandle() {
        return (uu)this.entity;
    }

    @Override
    public Horse.Variant getVariant() {
        return Horse.Variant.values()[this.getHandle().bX()];
    }

    @Override
    public void setVariant(Horse.Variant variant) {
        Validate.notNull((Object)((Object)variant), (String)"Variant cannot be null");
        this.getHandle().s(variant.ordinal());
    }

    @Override
    public Horse.Color getColor() {
        return Horse.Color.values()[this.getHandle().bY() & 0xFF];
    }

    @Override
    public void setColor(Horse.Color color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null");
        this.getHandle().t(color.ordinal() & 0xFF | this.getStyle().ordinal() << 8);
    }

    @Override
    public Horse.Style getStyle() {
        return Horse.Style.values()[this.getHandle().bY() >>> 8];
    }

    @Override
    public void setStyle(Horse.Style style) {
        Validate.notNull((Object)((Object)style), (String)"Style cannot be null");
        this.getHandle().t(this.getColor().ordinal() & 0xFF | style.ordinal() << 8);
    }

    @Override
    public boolean isCarryingChest() {
        return this.getHandle().ci();
    }

    @Override
    public void setCarryingChest(boolean chest) {
        if (chest == this.isCarryingChest()) {
            return;
        }
        this.getHandle().l(chest);
        this.getHandle().cL();
    }

    @Override
    public int getDomestication() {
        return this.getHandle().co();
    }

    @Override
    public void setDomestication(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Domestication cannot be less than zero");
        Validate.isTrue((value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication cannot be greater than the max domestication");
        this.getHandle().u(value);
    }

    @Override
    public int getMaxDomestication() {
        return this.getHandle().cu();
    }

    @Override
    public void setMaxDomestication(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Max domestication cannot be zero or less");
        this.getHandle().maxDomestication = value;
    }

    @Override
    public double getJumpStrength() {
        return this.getHandle().cr();
    }

    @Override
    public void setJumpStrength(double strength) {
        Validate.isTrue((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength cannot be less than zero");
        this.getHandle().a(uu.bv).a(strength);
    }

    @Override
    public boolean isTamed() {
        return this.getHandle().ca();
    }

    @Override
    public void setTamed(boolean tamed) {
        this.getHandle().i(tamed);
    }

    @Override
    public AnimalTamer getOwner() {
        if (this.getOwnerName() == null || "".equals(this.getOwnerName())) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerName());
    }

    @Override
    public void setOwner(AnimalTamer owner) {
        if (owner != null && !"".equals(owner.getName())) {
            this.setTamed(true);
            this.getHandle().a(null);
            this.setOwnerName(owner.getName());
        } else {
            this.setTamed(false);
            this.setOwnerName("");
        }
    }

    public String getOwnerName() {
        return this.getHandle().cf();
    }

    public void setOwnerName(String name) {
        this.getHandle().b(name);
    }

    @Override
    public HorseInventory getInventory() {
        return new CraftInventoryHorse((po)this.getHandle().bG);
    }

    @Override
    public String toString() {
        return "CraftHorse{variant=" + (Object)((Object)this.getVariant()) + ", owner=" + this.getOwner() + '}';
    }

    @Override
    public EntityType getType() {
        return EntityType.HORSE;
    }
}

