/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.BookMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaBook
extends CraftMetaItem
implements BookMeta {
    static final CraftMetaItem.ItemMetaKey BOOK_TITLE = new CraftMetaItem.ItemMetaKey("title");
    static final CraftMetaItem.ItemMetaKey BOOK_AUTHOR = new CraftMetaItem.ItemMetaKey("author");
    static final CraftMetaItem.ItemMetaKey BOOK_PAGES = new CraftMetaItem.ItemMetaKey("pages");
    static final int MAX_PAGE_LENGTH = 256;
    static final int MAX_TITLE_LENGTH = 65535;
    private String title;
    private String author;
    private List<String> pages = new ArrayList<String>();

    CraftMetaBook(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaBook)) {
            return;
        }
        CraftMetaBook bookMeta = (CraftMetaBook)meta;
        this.title = bookMeta.title;
        this.author = bookMeta.author;
        this.pages.addAll(bookMeta.pages);
    }

    CraftMetaBook(dg tag) {
        super(tag);
        if (tag.c(CraftMetaBook.BOOK_TITLE.NBT)) {
            this.title = tag.j(CraftMetaBook.BOOK_TITLE.NBT);
        }
        if (tag.c(CraftMetaBook.BOOK_AUTHOR.NBT)) {
            this.author = tag.j(CraftMetaBook.BOOK_AUTHOR.NBT);
        }
        if (tag.c(CraftMetaBook.BOOK_PAGES.NBT)) {
            dp pages = tag.c(CraftMetaBook.BOOK_PAGES.NBT, 8);
            String[] pageArray = new String[pages.c()];
            for (int i = 0; i < pages.c(); ++i) {
                String page;
                pageArray[i] = page = pages.f(i);
            }
            this.addPage(pageArray);
        }
    }

    CraftMetaBook(Map<String, Object> map) {
        super(map);
        this.setAuthor(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_AUTHOR.BUKKIT, true));
        this.setTitle(CraftMetaItem.SerializableMeta.getString(map, CraftMetaBook.BOOK_TITLE.BUKKIT, true));
        Iterable pages = CraftMetaItem.SerializableMeta.getObject(Iterable.class, map, CraftMetaBook.BOOK_PAGES.BUKKIT, true);
        CraftMetaItem.safelyAdd(pages, this.pages, 256);
    }

    @Override
    void applyToItem(dg itemData) {
        super.applyToItem(itemData);
        if (this.hasTitle()) {
            itemData.a(CraftMetaBook.BOOK_TITLE.NBT, this.title);
        }
        if (this.hasAuthor()) {
            itemData.a(CraftMetaBook.BOOK_AUTHOR.NBT, this.author);
        }
        if (this.hasPages()) {
            itemData.a(CraftMetaBook.BOOK_PAGES.NBT, (du)CraftMetaBook.createStringList(this.pages));
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isBookEmpty();
    }

    boolean isBookEmpty() {
        return !this.hasPages() && !this.hasAuthor() && !this.hasTitle();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case WRITTEN_BOOK: 
            case BOOK_AND_QUILL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAuthor() {
        return !Strings.isNullOrEmpty((String)this.author);
    }

    @Override
    public boolean hasTitle() {
        return !Strings.isNullOrEmpty((String)this.title);
    }

    @Override
    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean setTitle(String title) {
        if (title == null) {
            this.title = null;
            return true;
        }
        if (title.length() > 65535) {
            return false;
        }
        this.title = title;
        return true;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getPage(int page) {
        Validate.isTrue((boolean)this.isValidPage(page), (String)"Invalid page number");
        return this.pages.get(page - 1);
    }

    @Override
    public void setPage(int page, String text) {
        if (!this.isValidPage(page)) {
            throw new IllegalArgumentException("Invalid page number " + page + "/" + this.pages.size());
        }
        this.pages.set(page - 1, text == null ? "" : (text.length() > 256 ? text.substring(0, 256) : text));
    }

    @Override
    public void setPages(String ... pages) {
        this.pages.clear();
        this.addPage(pages);
    }

    @Override
    public void addPage(String ... pages) {
        for (String page : pages) {
            if (page == null) {
                page = "";
            } else if (page.length() > 256) {
                page = page.substring(0, 256);
            }
            this.pages.add(page);
        }
    }

    @Override
    public int getPageCount() {
        return this.pages.size();
    }

    @Override
    public List<String> getPages() {
        return ImmutableList.copyOf(this.pages);
    }

    @Override
    public void setPages(List<String> pages) {
        this.pages.clear();
        CraftMetaItem.safelyAdd(pages, this.pages, 256);
    }

    private boolean isValidPage(int page) {
        return page > 0 && page <= this.pages.size();
    }

    @Override
    public CraftMetaBook clone() {
        CraftMetaBook meta = (CraftMetaBook)super.clone();
        meta.pages = new ArrayList<String>(this.pages);
        return meta;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasTitle()) {
            hash = 61 * hash + this.title.hashCode();
        }
        if (this.hasAuthor()) {
            hash = 61 * hash + 13 * this.author.hashCode();
        }
        if (this.hasPages()) {
            hash = 61 * hash + 17 * this.pages.hashCode();
        }
        return original != hash ? CraftMetaBook.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaBook) {
            CraftMetaBook that = (CraftMetaBook)meta;
            return (this.hasTitle() ? that.hasTitle() && this.title.equals(that.title) : !that.hasTitle()) && (this.hasAuthor() ? that.hasAuthor() && this.author.equals(that.author) : !that.hasAuthor()) && (this.hasPages() ? that.hasPages() && this.pages.equals(that.pages) : !that.hasPages());
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaBook || this.isBookEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasTitle()) {
            builder.put((Object)CraftMetaBook.BOOK_TITLE.BUKKIT, (Object)this.title);
        }
        if (this.hasAuthor()) {
            builder.put((Object)CraftMetaBook.BOOK_AUTHOR.BUKKIT, (Object)this.author);
        }
        if (this.hasPages()) {
            builder.put((Object)CraftMetaBook.BOOK_PAGES.BUKKIT, this.pages);
        }
        return builder;
    }
}

