/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.map;

import java.awt.Image;
import java.util.Arrays;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;

public class CraftMapCanvas
implements MapCanvas {
    private final byte[] buffer = new byte[16384];
    private final CraftMapView mapView;
    private byte[] base;
    private MapCursorCollection cursors = new MapCursorCollection();

    protected CraftMapCanvas(CraftMapView mapView) {
        this.mapView = mapView;
        Arrays.fill(this.buffer, (byte)-1);
    }

    @Override
    public CraftMapView getMapView() {
        return this.mapView;
    }

    @Override
    public MapCursorCollection getCursors() {
        return this.cursors;
    }

    @Override
    public void setCursors(MapCursorCollection cursors) {
        this.cursors = cursors;
    }

    @Override
    public void setPixel(int x, int y2, byte color) {
        if (x < 0 || y2 < 0 || x >= 128 || y2 >= 128) {
            return;
        }
        if (this.buffer[y2 * 128 + x] != color) {
            this.buffer[y2 * 128 + x] = color;
            this.mapView.worldMap.a(x, y2, y2);
        }
    }

    @Override
    public byte getPixel(int x, int y2) {
        if (x < 0 || y2 < 0 || x >= 128 || y2 >= 128) {
            return 0;
        }
        return this.buffer[y2 * 128 + x];
    }

    @Override
    public byte getBasePixel(int x, int y2) {
        if (x < 0 || y2 < 0 || x >= 128 || y2 >= 128) {
            return 0;
        }
        return this.base[y2 * 128 + x];
    }

    protected void setBase(byte[] base) {
        this.base = base;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void drawImage(int x, int y2, Image image) {
        byte[] bytes = MapPalette.imageToBytes(image);
        for (int x2 = 0; x2 < image.getWidth(null); ++x2) {
            for (int y22 = 0; y22 < image.getHeight(null); ++y22) {
                this.setPixel(x + x2, y2 + y22, bytes[y22 * image.getWidth(null) + x2]);
            }
        }
    }

    @Override
    public void drawText(int x, int y2, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        if (!font.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        for (int i = 0; i < text.length(); ++i) {
            int j;
            char ch2 = text.charAt(i);
            if (ch2 == '\n') {
                x = xStart;
                y2 += font.getHeight() + 1;
                continue;
            }
            if (ch2 == '\u00a7' && (j = text.indexOf(59, i)) >= 0) {
                try {
                    color = Byte.parseByte(text.substring(i + 1, j));
                    i = j;
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
            for (int r2 = 0; r2 < font.getHeight(); ++r2) {
                for (int c = 0; c < sprite.getWidth(); ++c) {
                    if (!sprite.get(r2, c)) continue;
                    this.setPixel(x + c, y2 + r2, color);
                }
            }
            x += sprite.getWidth() + 1;
        }
    }
}

