/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scheduler;

import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.SpigotTimings;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.spigotmc.CustomTimingsHandler;

public class CraftTask
implements BukkitTask,
Runnable {
    private volatile CraftTask next = null;
    private volatile long period;
    private long nextRun;
    private final Runnable task;
    private final Plugin plugin;
    private final int id;
    CustomTimingsHandler timings = null;

    CraftTask() {
        this(null, null, -1, -1L);
    }

    CraftTask(Runnable task) {
        this(null, task, -1, -1L);
    }

    CraftTask(Plugin plugin, Runnable task, int id, long period) {
        this.plugin = plugin;
        this.task = task;
        this.id = id;
        this.period = period;
    }

    @Override
    public final int getTaskId() {
        return this.id;
    }

    @Override
    public final Plugin getOwner() {
        return this.plugin;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public void run() {
        if (!Bukkit.getServer().getPluginManager().useTimings()) {
            this.task.run();
            return;
        }
        if (this.timings == null && this.getOwner() != null && this.isSync()) {
            this.timings = SpigotTimings.getPluginTaskTimings(this, this.period);
        }
        if (this.timings != null) {
            this.timings.startTiming();
        }
        this.task.run();
        if (this.timings != null) {
            this.timings.stopTiming();
        }
    }

    long getPeriod() {
        return this.period;
    }

    void setPeriod(long period) {
        this.period = period;
    }

    long getNextRun() {
        return this.nextRun;
    }

    void setNextRun(long nextRun) {
        this.nextRun = nextRun;
    }

    CraftTask getNext() {
        return this.next;
    }

    void setNext(CraftTask next) {
        this.next = next;
    }

    public Class<? extends Runnable> getTaskClass() {
        return this.task.getClass();
    }

    @Override
    public void cancel() {
        Bukkit.getScheduler().cancelTask(this.id);
    }

    boolean cancel0() {
        this.setPeriod(-2L);
        return true;
    }
}

