/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.internal.FMLMessage;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends qn>, EntityRegistration> entityClassRegistrations = HashBiMap.create();
    public static Map<Class<? extends qn>, String> entityTypeMap = Maps.newHashMap();
    public static Map<String, Class<? extends qn>> entityClassMap = Maps.newHashMap();

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(1, 255);
        for (Object id : qt.e.keySet()) {
            this.availableIndicies.clear((Integer)id);
        }
    }

    public static void registerModEntity(Class<? extends qn> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerBukkitType(entityClass, entityName);
    }

    private void doModEntityRegistration(Class<? extends qn> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er = new EntityRegistration(mc, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er);
            this.entityNames.put(entityName, mc);
            if (!qt.d.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc.getModId(), entityName);
                qt.d.put(entityClass, entityModName);
                qt.c.put(entityModName, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.WARN, e, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er);
    }

    public static void registerGlobalEntityID(Class<? extends qn> entityClass, String entityName, int id) {
        if (qt.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        id = EntityRegistry.instance().validateAndClaimId(id);
        qt.a(entityClass, (String)entityName, (int)id);
        EntityRegistry.registerBukkitType(entityClass, entityName);
    }

    private int validateAndClaimId(int id) {
        int realId = id;
        if (id < -128) {
            FMLLog.warning("Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", id, Loader.instance().activeModContainer().getModId(), realId);
            realId += 3000;
        }
        if (realId < 0) {
            realId += 127;
        }
        try {
            UnsignedBytes.checkedCast((long)realId);
        }
        catch (IllegalArgumentException e) {
            FMLLog.log(Level.ERROR, "The entity ID %d for mod %s is not an unsigned byte and may not work", id, Loader.instance().activeModContainer().getModId());
        }
        if (!this.availableIndicies.get(realId)) {
            FMLLog.severe("The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", Loader.instance().activeModContainer().getModId(), id);
        }
        this.availableIndicies.clear(realId);
        return realId;
    }

    public static void registerGlobalEntityID(Class<? extends qn> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour) {
        if (qt.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        EntityRegistry.instance().validateAndClaimId(id);
        qt.a(entityClass, (String)entityName, (int)id, (int)backgroundEggColour, (int)foregroundEggColour);
        EntityRegistry.registerBukkitType(entityClass, entityName);
    }

    private static void registerBukkitType(Class<? extends qn> entityClass, String entityName) {
        ModContainer activeModContainer = Loader.instance().activeModContainer();
        String modId = "unknown";
        if (entityName.contains(".") && entityName.indexOf(".") + 1 < entityName.length()) {
            entityName = entityName.substring(entityName.indexOf(".") + 1, entityName.length());
        }
        entityName.replace("entity", "");
        if (entityName.startsWith("ent")) {
            entityName.replace("ent", "");
        }
        entityName = entityName.replaceAll("[^A-Za-z0-9]", "");
        if (activeModContainer != null) {
            modId = activeModContainer.getModId();
        }
        entityName = modId + "-" + entityName;
        entityTypeMap.put(entityClass, entityName);
        entityClassMap.put(entityName, entityClass);
    }

    public static String getCustomEntityTypeName(Class<? extends qn> entityClass) {
        return entityTypeMap.get(entityClass);
    }

    public static void addSpawn(Class<? extends ri> entityClass, int weightedProb, int min, int max, rj typeOfCreature, agg ... biomes) {
        for (agg biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            for (agj entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                break;
            }
            spawns.add(new agj(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, rj spawnList, agg ... biomes) {
        Class entityClazz = (Class)qt.c.get(entityName);
        if (ri.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, spawnList, biomes);
        }
    }

    public static void removeSpawn(Class<? extends ri> entityClass, rj typeOfCreature, agg ... biomes) {
        for (agg biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                agj entry = (agj)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, rj spawnList, agg ... biomes) {
        Class entityClazz = (Class)qt.c.get(entityName);
        if (ri.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, spawnList, biomes);
        }
    }

    public static int findGlobalUniqueEntityId() {
        int res = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (res < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return res;
    }

    public EntityRegistration lookupModSpawn(Class<? extends qn> clazz, boolean keepLooking) {
        Class<? extends qn> localClazz = clazz;
        do {
            EntityRegistration er;
            if ((er = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er : this.entityRegistrations.get((Object)mc)) {
            if (er.getModEntityId() != modEntityId) continue;
            return er;
        }
        return null;
    }

    public boolean tryTrackingEntity(md entityTracker, qn entity) {
        EntityRegistration er = this.lookupModSpawn(entity.getClass(), true);
        if (er != null) {
            entityTracker.a(entity, er.getTrackingRange(), er.getUpdateFrequency(), er.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends qn> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, qn> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, Class<? extends qn> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends qn> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public qn doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (qn)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, qn> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

