/*
 * Decompiled with CFR 0.152.
 */
package jline.internal;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.internal.Configuration;
import jline.internal.Log;

public final class TerminalLineSettings {
    public static final String JLINE_STTY = "jline.stty";
    public static final String DEFAULT_STTY = "stty";
    public static final String JLINE_SH = "jline.sh";
    public static final String DEFAULT_SH = "sh";
    private String sttyCommand = Configuration.getString((String)"jline.stty", (String)"stty");
    private String shCommand = Configuration.getString((String)"jline.sh", (String)"sh");
    private String config = this.get("-a");
    private long configLastFetched = System.currentTimeMillis();

    public TerminalLineSettings() throws IOException, InterruptedException {
        Log.debug((Object[])new Object[]{"Config: ", this.config});
        if (this.config.length() == 0) {
            throw new IOException(MessageFormat.format("Unrecognized stty code: {0}", this.config));
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void restore() throws IOException, InterruptedException {
        this.set("sane");
    }

    public String get(String args) throws IOException, InterruptedException {
        return this.stty(args);
    }

    public void set(String args) throws IOException, InterruptedException {
        this.stty(args);
    }

    public int getProperty(String name) {
        assert (name != null);
        long currentTime = System.currentTimeMillis();
        try {
            if (this.config == null || currentTime - this.configLastFetched > 1000L) {
                this.config = this.get("-a");
            }
        }
        catch (Exception e) {
            Log.debug((Object[])new Object[]{"Failed to query stty ", name, "\n", e});
        }
        if (currentTime - this.configLastFetched > 1000L) {
            this.configLastFetched = currentTime;
        }
        return TerminalLineSettings.getProperty(name, this.config);
    }

    protected static int getProperty(String name, String stty) {
        Pattern pattern = Pattern.compile(name + "\\s+=\\s+([^;]*)[;\\n\\r]");
        Matcher matcher = pattern.matcher(stty);
        if (!(matcher.find() || (matcher = (pattern = Pattern.compile(name + "\\s+([^;]*)[;\\n\\r]")).matcher(stty)).find() || (matcher = (pattern = Pattern.compile("(\\S*)\\s+" + name)).matcher(stty)).find())) {
            return -1;
        }
        return TerminalLineSettings.parseControlChar(matcher.group(1));
    }

    private static int parseControlChar(String str) {
        if ("<undef>".equals(str)) {
            return -1;
        }
        if (str.charAt(0) == '0') {
            return Integer.parseInt(str, 8);
        }
        if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            return Integer.parseInt(str, 10);
        }
        if (str.charAt(0) == '^') {
            if (str.charAt(1) == '?') {
                return 127;
            }
            return str.charAt(1) - 64;
        }
        if (str.charAt(0) == 'M' && str.charAt(1) == '-') {
            if (str.charAt(2) == '^') {
                if (str.charAt(3) == '?') {
                    return 255;
                }
                return str.charAt(3) - 64 + 128;
            }
            return str.charAt(2) + 128;
        }
        return str.charAt(0);
    }

    private String stty(String args) throws IOException, InterruptedException {
        assert (args != null);
        return this.exec(String.format("%s %s < /dev/tty", this.sttyCommand, args));
    }

    private String exec(String cmd) throws IOException, InterruptedException {
        assert (cmd != null);
        return this.exec(this.shCommand, "-c", cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exec(String ... cmd) throws IOException, InterruptedException {
        assert (cmd != null);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Log.trace((Object[])new Object[]{"Running: ", cmd});
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in2 = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in2 = p.getInputStream();
            while ((c = in2.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        catch (Throwable throwable) {
            TerminalLineSettings.close(in2, out, err);
            throw throwable;
        }
        TerminalLineSettings.close(in2, out, err);
        String result = bout.toString();
        Log.trace((Object[])new Object[]{"Result: ", result});
        return result;
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

