/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron;

import com.google.common.io.Files;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.server.MinecraftServer;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.InventoryHolder;

public class CauldronUtils {
    private static boolean deobfuscated = false;

    public static boolean isOverridingUpdateEntity(Class<? extends and> c) {
        Class<?> clazz = null;
        String method = CauldronUtils.deobfuscatedEnvironment() ? "updateEntity" : "func_145845_h";
        try {
            clazz = c.getMethod(method, new Class[0]).getDeclaringClass();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return clazz != and.class;
    }

    public static boolean canTileEntityUpdate(Class<? extends and> c) {
        boolean canUpdate = false;
        try {
            Constructor<? extends and> ctor = c.getConstructor(new Class[0]);
            and te = ctor.newInstance(new Object[0]);
            canUpdate = te.canUpdate();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return canUpdate;
    }

    public static <T> void dumpAndSortClassList(List<Class<? extends T>> classList) {
        ArrayList<String> sortedClassList = new ArrayList<String>();
        for (Class<T> clazz : classList) {
            sortedClassList.add(clazz.getName());
        }
        Collections.sort(sortedClassList);
        for (int i = 0; i < sortedClassList.size(); ++i) {
            MinecraftServer.G().e("Detected TE " + (String)sortedClassList.get(i) + " with canUpdate set to true and no updateEntity override!. This is NOT good, please report to mod author as this can hurt performance.");
        }
    }

    public static boolean migrateWorlds(String worldType, String oldWorldContainer, String newWorldContainer, String worldName) {
        boolean result = true;
        File newWorld = new File(new File(newWorldContainer), worldName);
        File oldWorld = new File(new File(oldWorldContainer), worldName);
        if (!newWorld.isDirectory() && oldWorld.isDirectory()) {
            MinecraftServer.G().e("---- Migration of old " + worldType + " folder required ----");
            MinecraftServer.G().e("Cauldron has moved back to using the Forge World structure, your " + worldType + " folder will be moved to a new location in order to operate correctly.");
            MinecraftServer.G().e("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Cauldron in the future.");
            MinecraftServer.G().e("Attempting to move " + oldWorld + " to " + newWorld + "...");
            if (newWorld.exists()) {
                MinecraftServer.G().h("A file or folder already exists at " + newWorld + "!");
                MinecraftServer.G().e("---- Migration of old " + worldType + " folder failed ----");
                result = false;
            } else if (newWorld.getParentFile().mkdirs() || newWorld.getParentFile().exists()) {
                MinecraftServer.G().e("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                try {
                    Files.move((File)oldWorld, (File)newWorld);
                }
                catch (IOException exception) {
                    MinecraftServer.G().h("Unable to move world data.");
                    exception.printStackTrace();
                    result = false;
                }
                try {
                    Files.copy((File)new File(oldWorld.getParent(), "level.dat"), (File)new File(newWorld, "level.dat"));
                }
                catch (IOException exception) {
                    MinecraftServer.G().h("Unable to migrate world level.dat.");
                }
                MinecraftServer.G().e("---- Migration of old " + worldType + " folder complete ----");
            } else {
                result = false;
            }
        }
        return result;
    }

    public static InventoryHolder getOwner(and tileentity) {
        BlockState state = tileentity.b.getWorld().getBlockAt(tileentity.c, tileentity.d, tileentity.e).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)((Object)state);
        }
        return null;
    }

    public static boolean deobfuscatedEnvironment() {
        try {
            byte[] bs = ((LaunchClassLoader)CauldronUtils.class.getClassLoader()).getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscated = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return deobfuscated;
    }
}

