/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class VersionInfo {
    public static final VersionInfo INSTANCE = new VersionInfo();
    public final JsonRootNode versionData;

    public VersionInfo() {
        InputStream installProfile = this.getClass().getResourceAsStream("/cauldron_libs.json");
        JdomParser parser = new JdomParser();
        try {
            this.versionData = parser.parse((Reader)new InputStreamReader(installProfile, Charsets.UTF_8));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getProfileName() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "profileName"});
    }

    public static String getVersionTarget() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "target"});
    }

    public static File getLibraryPath(File root) {
        String path = VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "path"});
        String[] split = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').omitEmptyStrings().split((CharSequence)path), String.class);
        File dest = root;
        Iterable subSplit = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)split[0]);
        for (String part : subSplit) {
            dest = new File(dest, part);
        }
        dest = new File(new File(dest, split[1]), split[2]);
        String fileName = split[1] + "-" + split[2] + ".jar";
        return new File(dest, fileName);
    }

    public static String getVersion() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "version"});
    }

    public static String getWelcomeMessage() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "welcome"});
    }

    public static String getLogoFileName() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "logo"});
    }

    public static JsonNode getVersionInfo() {
        return VersionInfo.INSTANCE.versionData.getNode(new Object[]{"versionInfo"});
    }

    public static File getMinecraftFile(File path) {
        return new File(new File(path, VersionInfo.getMinecraftVersion()), VersionInfo.getMinecraftVersion() + ".jar");
    }

    public static String getContainedFile() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "filePath"});
    }

    public static void extractFile(File path) throws IOException {
        INSTANCE.doFileExtract(path);
    }

    private void doFileExtract(File path) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + VersionInfo.getContainedFile());
        OutputSupplier outputSupplier = Files.newOutputStreamSupplier((File)path);
        System.out.println("doFileExtract path = " + path.getAbsolutePath() + ", inputStream = " + inputStream + ", outputSupplier = " + outputSupplier);
        ByteStreams.copy((InputStream)inputStream, (OutputSupplier)outputSupplier);
    }

    public static String getMinecraftVersion() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "minecraft"});
    }
}

