/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.cauldron.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronCommand;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.cauldron.TileEntityCache;
import net.minecraftforge.cauldron.configuration.BoolSetting;
import net.minecraftforge.cauldron.configuration.IntSetting;
import net.minecraftforge.cauldron.configuration.Setting;
import net.minecraftforge.common.DimensionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.file.YamlConfiguration;

public class CauldronConfig {
    private static final File CONFIG_FILE = new File("cauldron.yml");
    private static final String HEADER = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n";
    public static YamlConfiguration config;
    static int version;
    static Map<String, Command> commands;
    public static Map<String, Setting> settings;
    public static final BoolSetting dumpMaterials;
    public static final BoolSetting disableWarnings;
    public static final BoolSetting worldLeakDebug;
    public static final BoolSetting connectionLogging;
    public static final BoolSetting tileEntityPlaceLogging;
    public static final BoolSetting tickIntervalLogging;
    public static final BoolSetting chunkLoadLogging;
    public static final BoolSetting chunkUnloadLogging;
    public static final BoolSetting entitySpawnLogging;
    public static final BoolSetting entityDespawnLogging;
    public static final BoolSetting entityDeathLogging;
    public static final BoolSetting logWithStackTraces;
    public static final BoolSetting dumpChunksOnDeadlock;
    public static final BoolSetting dumpHeapOnDeadlock;
    public static final BoolSetting dumpThreadsOnWarn;
    public static final BoolSetting logEntityCollisionChecks;
    public static final BoolSetting logEntitySpeedRemoval;
    public static final IntSetting largeCollisionLogSize;
    public static final IntSetting largeEntityCountLogSize;
    public static final BoolSetting loadChunkOnRequest;
    public static final BoolSetting loadChunkOnForgeTick;
    public static final BoolSetting checkEntityBoundingBoxes;
    public static final BoolSetting checkEntityMaxSpeeds;
    public static final IntSetting largeBoundingBoxLogSize;
    public static final IntSetting entityMaxSpeed;
    public static final BoolSetting enableThreadContentionMonitoring;
    public static final BoolSetting infiniteWaterSource;
    public static final BoolSetting flowingLavaDecay;
    public static final BoolSetting fakePlayerLogin;
    public static final BoolSetting remapPluginFile;

    public static void init() {
        if (config == null) {
            commands = new HashMap<String, Command>();
            commands.put("cauldron", new CauldronCommand());
            CauldronConfig.load(false);
        }
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.G().server.getCommandMap().register(entry.getKey(), "cauldron", entry.getValue());
        }
    }

    public static void save() {
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    public static void load(boolean refreshTECache) {
        try {
            config = YamlConfiguration.loadConfiguration(CONFIG_FILE);
            String header = "This is the main configuration file for Cauldron.\n\nIf you need help with the configuration or have any questions related to Cauldron,\njoin us at the IRC or drop by our forums and leave a post.\n\nIRC: #cauldron @ irc.esper.net ( http://webchat.esper.net/?channel=cauldron )\nForums: http://cauldron.minecraftforge.net/\n\n";
            for (Setting setting : settings.values()) {
                if (!setting.description.equals("")) {
                    header = header + "Setting: " + setting.path + " Default: " + setting.def + "   # " + setting.description + "\n";
                }
                config.addDefault(setting.path, setting.def);
                settings.get(setting.path).setValue(config.getString(setting.path));
            }
            config.options().header(header);
            config.options().copyDefaults(true);
            version = CauldronConfig.getInt("config-version", 1);
            CauldronConfig.set("config-version", 1);
            for (mj world : DimensionManager.getWorlds()) {
                if (world.cauldronConfig == null) continue;
                world.cauldronConfig.config = config;
                world.cauldronConfig.entitiesDespawnImmediate = world.cauldronConfig.getBoolean("entities.despawn-immediate", true);
            }
            if (refreshTECache) {
                for (Map.Entry entry : CauldronHooks.tileEntityCache.entrySet()) {
                    TileEntityCache teCache = (TileEntityCache)entry.getValue();
                    teCache.tickNoPlayers = config.getBoolean("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-no-players", config.getBoolean("world-settings.default." + teCache.configPath + ".tick-no-players"));
                    teCache.tickInterval = config.getInt("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-interval", config.getInt("world-settings.default." + teCache.configPath + ".tick-interval"));
                }
            }
            CauldronConfig.save();
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load " + CONFIG_FILE, ex);
        }
    }

    public static void set(String path, Object val) {
        config.set(path, val);
    }

    public static boolean isSet(String path) {
        return config.isSet(path);
    }

    public static boolean isInt(String path) {
        return config.isInt(path);
    }

    public static boolean isBoolean(String path) {
        return config.isBoolean(path);
    }

    public static boolean getBoolean(String path, boolean def) {
        return CauldronConfig.getBoolean(path, def, true);
    }

    public static boolean getBoolean(String path, boolean def, boolean useDefault) {
        if (useDefault) {
            config.addDefault(path, def);
        }
        return config.getBoolean(path, def);
    }

    public static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    public static String getString(String path, String def) {
        return CauldronConfig.getString(path, def, true);
    }

    public static String getString(String path, String def, boolean useDefault) {
        if (useDefault) {
            config.addDefault(path, def);
        }
        return config.getString(path, def);
    }

    public static String getFakePlayer(String className, String defaultName) {
        return CauldronConfig.getString("fake-players." + className + ".username", defaultName);
    }

    static {
        settings = new HashMap<String, Setting>();
        dumpMaterials = new BoolSetting("settings.dump-materials", false, "Dumps all materials with their corresponding id's");
        disableWarnings = new BoolSetting("logging.disabled-warnings", false, "Disable warning messages to server admins");
        worldLeakDebug = new BoolSetting("logging.world-leak-debug", false, "Log worlds that appear to be leaking (buggy)");
        connectionLogging = new BoolSetting("logging.connection", false, "Log connections");
        tileEntityPlaceLogging = new BoolSetting("logging.warn-place-no-tileentity", true, "Warn when a mod requests tile entity from a block that doesn't support one");
        tickIntervalLogging = new BoolSetting("logging.tick-intervals", false, "Log when skip interval handlers are ticked");
        chunkLoadLogging = new BoolSetting("logging.chunk-load", false, "Log when chunks are loaded (dev)");
        chunkUnloadLogging = new BoolSetting("logging.chunk-unload", false, "Log when chunks are unloaded (dev)");
        entitySpawnLogging = new BoolSetting("logging.entity-spawn", false, "Log when living entities are spawned (dev)");
        entityDespawnLogging = new BoolSetting("logging.entity-despawn", false, "Log when living entities are despawned (dev)");
        entityDeathLogging = new BoolSetting("logging.entity-death", false, "Log when an entity is destroyed (dev)");
        logWithStackTraces = new BoolSetting("logging.detailed-logging", false, "Add stack traces to dev logging");
        dumpChunksOnDeadlock = new BoolSetting("logging.dump-chunks-on-deadlock", false, "Dump chunks in the event of a deadlock (helps to debug the deadlock)");
        dumpHeapOnDeadlock = new BoolSetting("logging.dump-heap-on-deadlock", false, "Dump the heap in the event of a deadlock (helps to debug the deadlock)");
        dumpThreadsOnWarn = new BoolSetting("logging.dump-threads-on-warn", false, "Dump the the server thread on deadlock warning (delps to debug the deadlock)");
        logEntityCollisionChecks = new BoolSetting("logging.entity-collision-checks", false, "Whether to log entity collision/count checks");
        logEntitySpeedRemoval = new BoolSetting("logging.entity-speed-removal", false, "Whether to log entity removals due to speed");
        largeCollisionLogSize = new IntSetting("logging.collision-warn-size", 200, "Number of colliding entities in one spot before logging a warning. Set to 0 to disable");
        largeEntityCountLogSize = new IntSetting("logging.entity-count-warn-size", 0, "Number of entities in one dimension logging a warning. Set to 0 to disable");
        loadChunkOnRequest = new BoolSetting("settings.load-chunk-on-request", true, "Forces Chunk Loading on 'Provide' requests (speedup for mods that don't check if a chunk is loaded");
        loadChunkOnForgeTick = new BoolSetting("settings.load-chunk-on-forge-tick", false, "Forces Chunk Loading during Forge Server Tick events");
        checkEntityBoundingBoxes = new BoolSetting("settings.check-entity-bounding-boxes", false, "Removes an entity that exceeds the max bounding box size.");
        checkEntityMaxSpeeds = new BoolSetting("settings.check-entity-max-speeds", false, "Removes any entity that exceeds max speed.");
        largeBoundingBoxLogSize = new IntSetting("settings.entity-bounding-box-max-size", 1000, "Max size of an entity's bounding box before removing it (either being too large or bugged and 'moving' too fast)");
        entityMaxSpeed = new IntSetting("settings.entity-max-speed", 100, "Square of the max speed of an entity before removing it");
        enableThreadContentionMonitoring = new BoolSetting("debug.thread-contention-monitoring", false, "Set true to enable Java's thread contention monitoring for thread dumps");
        infiniteWaterSource = new BoolSetting("world-settings.default.infinite-water-source", true, "Vanilla water source behavior - is infinite");
        flowingLavaDecay = new BoolSetting("world-settings.default.flowing-lava-decay", false, "Lava behaves like vanilla water when source block is removed");
        fakePlayerLogin = new BoolSetting("fake-players.do-login", false, "Raise login events for fake players");
        remapPluginFile = new BoolSetting("plugin-settings.default.remap-plugin-file", false, "Remap the plugin file (dev)");
        settings.put(CauldronConfig.dumpMaterials.path, dumpMaterials);
        settings.put(CauldronConfig.disableWarnings.path, disableWarnings);
        settings.put(CauldronConfig.worldLeakDebug.path, worldLeakDebug);
        settings.put(CauldronConfig.connectionLogging.path, connectionLogging);
        settings.put(CauldronConfig.tileEntityPlaceLogging.path, tileEntityPlaceLogging);
        settings.put(CauldronConfig.tickIntervalLogging.path, tickIntervalLogging);
        settings.put(CauldronConfig.chunkLoadLogging.path, chunkLoadLogging);
        settings.put(CauldronConfig.chunkUnloadLogging.path, chunkUnloadLogging);
        settings.put(CauldronConfig.entitySpawnLogging.path, entitySpawnLogging);
        settings.put(CauldronConfig.entityDespawnLogging.path, entityDespawnLogging);
        settings.put(CauldronConfig.entityDeathLogging.path, entityDeathLogging);
        settings.put(CauldronConfig.logWithStackTraces.path, logWithStackTraces);
        settings.put(CauldronConfig.dumpChunksOnDeadlock.path, dumpChunksOnDeadlock);
        settings.put(CauldronConfig.dumpHeapOnDeadlock.path, dumpHeapOnDeadlock);
        settings.put(CauldronConfig.dumpThreadsOnWarn.path, dumpThreadsOnWarn);
        settings.put(CauldronConfig.logEntityCollisionChecks.path, logEntityCollisionChecks);
        settings.put(CauldronConfig.logEntitySpeedRemoval.path, logEntitySpeedRemoval);
        settings.put(CauldronConfig.largeCollisionLogSize.path, largeCollisionLogSize);
        settings.put(CauldronConfig.largeEntityCountLogSize.path, largeEntityCountLogSize);
        settings.put(CauldronConfig.loadChunkOnRequest.path, loadChunkOnRequest);
        settings.put(CauldronConfig.loadChunkOnForgeTick.path, loadChunkOnForgeTick);
        settings.put(CauldronConfig.checkEntityBoundingBoxes.path, checkEntityBoundingBoxes);
        settings.put(CauldronConfig.checkEntityMaxSpeeds.path, checkEntityMaxSpeeds);
        settings.put(CauldronConfig.largeBoundingBoxLogSize.path, largeBoundingBoxLogSize);
        settings.put(CauldronConfig.enableThreadContentionMonitoring.path, enableThreadContentionMonitoring);
        settings.put(CauldronConfig.infiniteWaterSource.path, infiniteWaterSource);
        settings.put(CauldronConfig.flowingLavaDecay.path, flowingLavaDecay);
        settings.put(CauldronConfig.fakePlayerLogin.path, fakePlayerLogin);
        settings.put(CauldronConfig.remapPluginFile.path, remapPluginFile);
    }
}

