/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>();
    private static List<ArrayList<abp>> idToStack = Lists.newArrayList();
    private static List<ArrayList<abp>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMap();
    public static final ArrayList<abp> EMPTY_LIST = new UnmodifiableArrayList<abp>(Lists.newArrayList());
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new abp(ahz.r, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new abp(ahz.s, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new abp(ahz.f, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new abp((ahu)ahz.bx, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", ahz.ad);
            OreDictionary.registerOre("stairWood", ahz.bF);
            OreDictionary.registerOre("stairWood", ahz.bG);
            OreDictionary.registerOre("stairWood", ahz.bH);
            OreDictionary.registerOre("stairWood", ahz.ck);
            OreDictionary.registerOre("stairWood", ahz.cl);
            OreDictionary.registerOre("stickWood", abq.y);
            OreDictionary.registerOre("treeSapling", new abp(ahz.g, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new abp((ahu)ahz.t, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new abp((ahu)ahz.u, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("oreGold", ahz.o);
            OreDictionary.registerOre("oreIron", ahz.p);
            OreDictionary.registerOre("oreLapis", ahz.x);
            OreDictionary.registerOre("oreDiamond", ahz.ag);
            OreDictionary.registerOre("oreRedstone", ahz.ax);
            OreDictionary.registerOre("oreEmerald", ahz.bA);
            OreDictionary.registerOre("oreQuartz", ahz.bY);
            OreDictionary.registerOre("oreCoal", ahz.q);
            OreDictionary.registerOre("blockGold", ahz.R);
            OreDictionary.registerOre("blockIron", ahz.S);
            OreDictionary.registerOre("blockLapis", ahz.y);
            OreDictionary.registerOre("blockDiamond", ahz.ah);
            OreDictionary.registerOre("blockRedstone", ahz.bX);
            OreDictionary.registerOre("blockEmerald", ahz.bE);
            OreDictionary.registerOre("blockQuartz", ahz.ca);
            OreDictionary.registerOre("blockCoal", ahz.ci);
            OreDictionary.registerOre("blockGlassColorless", ahz.w);
            OreDictionary.registerOre("blockGlass", ahz.w);
            OreDictionary.registerOre("blockGlass", new abp((ahu)ahz.cn, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", ahz.aZ);
            OreDictionary.registerOre("paneGlass", ahz.aZ);
            OreDictionary.registerOre("paneGlass", new abp((ahu)ahz.co, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("ingotIron", abq.j);
            OreDictionary.registerOre("ingotGold", abq.k);
            OreDictionary.registerOre("ingotBrick", abq.aC);
            OreDictionary.registerOre("ingotBrickNether", abq.bT);
            OreDictionary.registerOre("nuggetGold", abq.bl);
            OreDictionary.registerOre("gemDiamond", abq.i);
            OreDictionary.registerOre("gemEmerald", abq.bC);
            OreDictionary.registerOre("gemQuartz", abq.bU);
            OreDictionary.registerOre("dustRedstone", abq.ax);
            OreDictionary.registerOre("dustGlowstone", abq.aO);
            OreDictionary.registerOre("gemLapis", new abp(abq.aR, 1, 4));
            OreDictionary.registerOre("slimeball", abq.aH);
            OreDictionary.registerOre("glowstone", ahz.aN);
            OreDictionary.registerOre("cropWheat", abq.O);
            OreDictionary.registerOre("cropPotato", abq.bG);
            OreDictionary.registerOre("cropCarrot", abq.bF);
            OreDictionary.registerOre("stone", ahz.b);
            OreDictionary.registerOre("cobblestone", ahz.e);
            OreDictionary.registerOre("sandstone", new abp(ahz.A, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("dye", new abp(abq.aR, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("record", abq.cd);
            OreDictionary.registerOre("record", abq.ce);
            OreDictionary.registerOre("record", abq.cf);
            OreDictionary.registerOre("record", abq.cg);
            OreDictionary.registerOre("record", abq.ch);
            OreDictionary.registerOre("record", abq.ci);
            OreDictionary.registerOre("record", abq.cj);
            OreDictionary.registerOre("record", abq.ck);
            OreDictionary.registerOre("record", abq.cl);
            OreDictionary.registerOre("record", abq.cm);
            OreDictionary.registerOre("record", abq.cn);
            OreDictionary.registerOre("record", abq.co);
        }
        HashMap<abp, String> replacements = new HashMap<abp, String>();
        replacements.put(new abp(abq.y), "stickWood");
        replacements.put(new abp(ahz.f), "plankWood");
        replacements.put(new abp(ahz.f, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new abp(ahz.b), "stone");
        replacements.put(new abp(ahz.b, 1, Short.MAX_VALUE), "stone");
        replacements.put(new abp(ahz.e), "cobblestone");
        replacements.put(new abp(ahz.e, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new abp(abq.k), "ingotGold");
        replacements.put(new abp(abq.j), "ingotIron");
        replacements.put(new abp(abq.i), "gemDiamond");
        replacements.put(new abp(abq.bC), "gemEmerald");
        replacements.put(new abp(abq.ax), "dustRedstone");
        replacements.put(new abp(abq.aO), "dustGlowstone");
        replacements.put(new abp(ahz.aN), "glowstone");
        replacements.put(new abp(abq.aH), "slimeball");
        replacements.put(new abp(ahz.w), "blockGlassColorless");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            abp dye = new abp(abq.aR, 1, i);
            abp block = new abp((ahu)ahz.cn, 1, 15 - i);
            abp pane = new abp((ahu)ahz.co, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        abp[] replaceStacks = replacements.keySet().toArray(new abp[replacements.keySet().size()]);
        abp[] exclusions = new abp[]{new abp(ahz.y), new abp(abq.aX), new abp(ahz.aV), new abp((ahu)ahz.U, 1, Short.MAX_VALUE), new abp(ahz.ar), new abp(ahz.bK), new abp(ahz.ad), new abp(ahz.bF), new abp(ahz.bG), new abp(ahz.bH), new abp(ahz.ck), new abp(ahz.cl), new abp(ahz.aZ), new abp((ahu)ahz.cn)};
        List recipes = adq.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            abp output;
            adt recipe;
            if (obj instanceof adt) {
                recipe = (adt)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || output == null || !OreDictionary.containsMatch(true, recipe.c, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof adu) || (output = (recipe = (adu)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || output == null || !OreDictionary.containsMatch(true, recipe.b.toArray(new abp[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((ads)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((adu)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            FMLLog.info("Replaced %d ore recipies", recipesToRemove.size());
        }
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            idToStack.add(new ArrayList());
            idToStackUn.add(new UnmodifiableArrayList<abp>(idToStack.get(val)));
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    @Deprecated
    public static int getOreID(abp stack) {
        if (stack == null || stack.b() == null) {
            return -1;
        }
        int id = abn.b((abn)stack.b());
        List<Integer> ids = stackToId.get(id);
        if (ids == null || ids.size() == 0) {
            ids = stackToId.get(id | stack.k() + 1 << 16);
        }
        return ids != null && ids.size() > 0 ? ids.get(0) : -1;
    }

    public static int[] getOreIDs(abp stack) {
        if (stack == null || stack.b() == null) {
            return new int[0];
        }
        HashSet<Integer> set = new HashSet<Integer>();
        int id = abn.b((abn)stack.b());
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.k() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static ArrayList<abp> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    @Deprecated
    public static ArrayList<abp> getOres(Integer id) {
        return OreDictionary.getOres((int)id);
    }

    private static ArrayList<abp> getOres(int id) {
        while (idToName.size() < id + 1) {
            String name = "Filler: " + idToName.size();
            idToName.add(name);
            nameToId.put(name, idToName.size() - 1);
            idToStack.add(null);
            idToStackUn.add(EMPTY_LIST);
        }
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, abp[] inputs, abp ... targets) {
        for (abp input : inputs) {
            for (abp target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsMatch(boolean strict, List<abp> inputs, abp ... targets) {
        for (abp input : inputs) {
            for (abp target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(abp target, abp input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.b() == input.b() && (target.k() == Short.MAX_VALUE && !strict || target.k() == input.k());
    }

    public static void registerOre(String name, abn ore) {
        OreDictionary.registerOre(name, new abp(ore));
    }

    public static void registerOre(String name, ahu ore) {
        OreDictionary.registerOre(name, new abp(ore));
    }

    public static void registerOre(String name, abp ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    @Deprecated
    public static void registerOre(int id, abn ore) {
        OreDictionary.registerOre(id, new abp(ore));
    }

    @Deprecated
    public static void registerOre(int id, ahu ore) {
        OreDictionary.registerOre(id, new abp(ore));
    }

    @Deprecated
    public static void registerOre(int id, abp ore) {
        OreDictionary.registerOreImpl(OreDictionary.getOreName(id), ore);
    }

    private static void registerOreImpl(String name, abp ore) {
        ArrayList ids;
        if ("Unknown".equals(name)) {
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        int hash = abn.b((abn)ore.b());
        if (ore.k() != Short.MAX_VALUE) {
            hash |= ore.k() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.m();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            List ores = idToStack.get(id);
            if (ores == null) continue;
            for (abp ore : ores) {
                ArrayList ids;
                int hash = abn.b((abn)ore.b());
                if (ore.k() != Short.MAX_VALUE) {
                    hash |= ore.k() + 1 << 16;
                }
                if ((ids = stackToId.get(hash)) == null) {
                    ids = Lists.newArrayList();
                    stackToId.put(hash, ids);
                }
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    private static class UnmodifiableArrayList<E>
    extends ArrayList<E> {
        final ArrayList<? extends E> list;

        UnmodifiableArrayList(ArrayList<? extends E> list) {
            super(0);
            this.list = list;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a2) {
            return this.list.toArray(a2);
        }

        @Override
        public String toString() {
            return this.list.toString();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.list.containsAll(coll);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = UnmodifiableArrayList.this.list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = UnmodifiableArrayList.this.list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final abp Ore;

        public OreRegisterEvent(String name, abp ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

