/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R1.entity;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.Validate;
import org.bukkit.Achievement;
import org.bukkit.BanList;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_7_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_7_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_7_R1.CraftServer;
import org.bukkit.craftbukkit.v1_7_R1.CraftSound;
import org.bukkit.craftbukkit.v1_7_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_7_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R1.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_7_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_7_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_7_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_7_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_7_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_7_R1.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<String, Player> hiddenPlayers = new MapMaker().weakValues().makeMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private final Player.Spigot spigot = new Player.Spigot(){

        @Override
        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.getHandle().collidesWithEntities;
        }

        @Override
        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.getHandle().collidesWithEntities = collides;
            CraftPlayer.this.getHandle().l = collides;
        }

        @Override
        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().af().a(CraftPlayer.this.getHandle(), 0, false);
            }
        }

        @Override
        public String getLocale() {
            return CraftPlayer.this.getHandle().bN;
        }
    };

    public CraftPlayer(CraftServer server, mm entity) {
        super(server, (xl)entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().d(this.getName());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().a(this.getName());
        } else {
            this.server.getHandle().b(this.getName());
        }
        this.perm.recalculatePermissions();
    }

    @Override
    public boolean isOnline() {
        for (Object obj : this.server.getHandle().a) {
            mm player = (mm)obj;
            if (!player.b_().equalsIgnoreCase(this.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.getHandle().a == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().a.a.b();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    @Override
    public double getEyeHeight() {
        return this.getEyeHeight(false);
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        if (ignoreSneaking) {
            return 1.62;
        }
        if (this.isSneaking()) {
            return 1.54;
        }
        return 1.62;
    }

    @Override
    public void sendRawMessage(String message) {
        if (this.getHandle().a == null) {
            return;
        }
        for (fa component : CraftChatMessage.fromString(message)) {
            this.getHandle().a.a((fk)new ga(component));
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String[] messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public String getDisplayName() {
        return this.getHandle().displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this.getHandle().displayName = name;
    }

    @Override
    public String getPlayerListName() {
        return this.getHandle().listName;
    }

    @Override
    public void setPlayerListName(String name) {
        String oldName = this.getHandle().listName;
        if (name == null) {
            name = this.getName();
        }
        if (oldName.equals(name)) {
            return;
        }
        if (name.length() > 16) {
            throw new IllegalArgumentException("Player list names can only be a maximum of 16 characters long");
        }
        for (int i = 0; i < this.server.getHandle().a.size(); ++i) {
            if (!((mm)this.server.getHandle().a.get((int)i)).listName.equals(name)) continue;
            throw new IllegalArgumentException(name + " is already assigned as a player list name for someone");
        }
        this.getHandle().listName = name;
        hc oldpacket = new hc(oldName, false, 9999);
        hc packet = new hc(name, true, this.getHandle().i);
        for (int i = 0; i < this.server.getHandle().a.size(); ++i) {
            mm entityplayer = (mm)this.server.getHandle().a.get(i);
            if (entityplayer.a == null || !entityplayer.getBukkitEntity().canSee(this)) continue;
            entityplayer.a.a((fk)oldpacket);
            entityplayer.a.a((fk)packet);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        boolean nameEquals = this.getName().equalsIgnoreCase(other.getName());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return nameEquals && idEquals;
    }

    @Override
    public void kickPlayer(String message) {
        if (Thread.currentThread() != MinecraftServer.G().primaryThread) {
            throw new IllegalStateException("Asynchronous player kick!");
        }
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.c(message == null ? "" : message);
    }

    @Override
    public void setCompassTarget(Location loc) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.a((fk)new ht(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
    }

    @Override
    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    @Override
    public void chat(String msg) {
        if (this.getHandle().a == null) {
            return;
        }
        this.getHandle().a.chat(msg, false);
    }

    @Override
    public boolean performCommand(String command) {
        return this.server.dispatchCommand(this, command);
    }

    @Override
    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "bd";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bassattack";
            }
        }
        this.getHandle().a.a((fk)new gt("note." + instrumentName, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, (float)note));
    }

    @Override
    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().a == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument.ordinal()) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "bd";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bassattack";
            }
        }
        this.getHandle().a.a((fk)new gt("note." + instrumentName, (double)loc.getBlockX(), (double)loc.getBlockY(), (double)loc.getBlockZ(), 3.0f, (float)note.getId()));
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        this.playSound(loc, CraftSound.getSound(sound), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        if (loc == null || sound == null || this.getHandle().a == null) {
            return;
        }
        double x = (double)loc.getBlockX() + 0.5;
        double y2 = (double)loc.getBlockY() + 0.5;
        double z2 = (double)loc.getBlockZ() + 0.5;
        gt packet = new gt(sound, x, y2, z2, volume, pitch);
        this.getHandle().a.a((fk)packet);
    }

    @Override
    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().a == null) {
            return;
        }
        int packetData = effect.getId();
        gr packet = new gr(packetData, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), data, false);
        this.getHandle().a.a((fk)packet);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    @Override
    public void sendBlockChange(Location loc, Material material, byte data) {
        this.sendBlockChange(loc, material.getId(), data);
    }

    @Override
    public void sendBlockChange(Location loc, int material, byte data) {
        if (this.getHandle().a == null) {
            return;
        }
        fy packet = new fy(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), (afn)((CraftWorld)loc.getWorld()).getHandle());
        packet.d = CraftMagicNumbers.getBlock(material);
        packet.e = data;
        this.getHandle().a.a((fk)packet);
    }

    @Override
    public boolean sendChunkChange(Location loc, int sx, int sy, int sz, byte[] data) {
        if (this.getHandle().a == null) {
            return false;
        }
        throw new NotImplementedException("Chunk changes do not yet work");
    }

    @Override
    public void sendMap(MapView map) {
        if (this.getHandle().a == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        for (int x = 0; x < 128; ++x) {
            byte[] bytes = new byte[131];
            bytes[1] = (byte)x;
            for (int y2 = 0; y2 < 128; ++y2) {
                bytes[y2 + 3] = data.buffer[y2 * 128 + x];
            }
            gv packet = new gv((int)map.getId(), bytes);
            this.getHandle().a.a((fk)packet);
        }
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        mm entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.L) {
            return false;
        }
        if (entity.a == null || entity.a.isDisconnected()) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent(this, from, to, cause);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        this.eject();
        this.leaveVehicle();
        from = event.getFrom();
        to = event.getTo();
        mj fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        mj toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().bp != this.getHandle().bo) {
            this.getHandle().k();
        }
        if (fromWorld == toWorld) {
            entity.a.teleport(to);
        } else {
            this.server.getHandle().respawnPlayer(entity, toWorld.dimension, true, to, true);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().b(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().an();
    }

    @Override
    public boolean isSprinting() {
        return this.getHandle().ao();
    }

    @Override
    public void setSprinting(boolean sprinting) {
        this.getHandle().c(sprinting);
    }

    @Override
    public void loadData() {
        this.server.getHandle().l.b((xl)this.getHandle());
    }

    @Override
    public void saveData() {
        this.server.getHandle().l.a((xl)this.getHandle());
    }

    @Override
    @Deprecated
    public void updateInventory() {
        this.getHandle().a(this.getHandle().bp);
    }

    @Override
    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().checkSleepStatus();
    }

    @Override
    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    @Override
    public void awardAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        if (achievement.hasParent() && !this.hasAchievement(achievement.getParent())) {
            this.awardAchievement(achievement.getParent());
        }
        this.getHandle().x().a((xl)this.getHandle(), (nv)CraftStatistic.getNMSAchievement(achievement), 1);
        this.getHandle().x().b(this.getHandle());
    }

    @Override
    public void removeAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        for (Achievement achieve : Achievement.values()) {
            if (achieve.getParent() != achievement || !this.hasAchievement(achieve)) continue;
            this.removeAchievement(achieve);
        }
        this.getHandle().x().a((xl)this.getHandle(), (nv)CraftStatistic.getNMSAchievement(achievement), 0);
    }

    @Override
    public boolean hasAchievement(Achievement achievement) {
        Validate.notNull((Object)((Object)achievement), (String)"Achievement cannot be null");
        return this.getHandle().x().a(CraftStatistic.getNMSAchievement(achievement));
    }

    @Override
    public void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic) {
        this.decrementStatistic(statistic, 1);
    }

    @Override
    public int getStatistic(Statistic statistic) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        return this.getHandle().x().a(CraftStatistic.getNMSStatistic(statistic));
    }

    @Override
    public void incrementStatistic(Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, this.getStatistic(statistic) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (String)"Must supply additional paramater for this statistic");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        nv nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        this.getHandle().x().a((xl)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material) {
        this.incrementStatistic(statistic, material, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material) {
        this.decrementStatistic(statistic, material, 1);
    }

    @Override
    public int getStatistic(Statistic statistic, Material material) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        nv nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        return this.getHandle().x().a(nmsStatistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, material, this.getStatistic(statistic, material) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, Material material, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (String)"This statistic does not take a Material parameter");
        nv nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied Material does not have a corresponding statistic");
        this.getHandle().x().a((xl)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        this.incrementStatistic(statistic, entityType, 1);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        this.decrementStatistic(statistic, entityType, 1);
    }

    @Override
    public int getStatistic(Statistic statistic, EntityType entityType) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)entityType), (String)"EntityType cannot be null");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        nv nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        return this.getHandle().x().a(nmsStatistic);
    }

    @Override
    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, entityType, this.getStatistic(statistic, entityType) + amount);
    }

    @Override
    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        Validate.isTrue((amount > 0 ? 1 : 0) != 0, (String)"Amount must be greater than 0");
        this.setStatistic(statistic, entityType, this.getStatistic(statistic, entityType) - amount);
    }

    @Override
    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        Validate.notNull((Object)((Object)statistic), (String)"Statistic cannot be null");
        Validate.notNull((Object)((Object)entityType), (String)"EntityType cannot be null");
        Validate.isTrue((newValue >= 0 ? 1 : 0) != 0, (String)"Value must be greater than or equal to 0");
        Validate.isTrue((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (String)"This statistic does not take an EntityType parameter");
        nv nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Validate.notNull((Object)nmsStatistic, (String)"The supplied EntityType does not have a corresponding statistic");
        this.getHandle().x().a((xl)this.getHandle(), nmsStatistic, newValue);
    }

    @Override
    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    @Override
    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    @Override
    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    @Override
    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    @Override
    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    @Override
    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    @Override
    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    @Override
    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    @Override
    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    @Override
    public void setBanned(boolean value) {
        if (value) {
            this.server.getBanList(BanList.Type.NAME).addBan(this.getName(), null, null, null);
        } else {
            this.server.getBanList(BanList.Type.NAME).pardon(this.getName());
        }
    }

    @Override
    public boolean isWhitelisted() {
        return this.server.getHandle().h().contains(this.getName().toLowerCase());
    }

    @Override
    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().f(this.getName().toLowerCase());
        } else {
            this.server.getHandle().g(this.getName().toLowerCase());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().a == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        if (mode != this.getGameMode()) {
            PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this, mode);
            this.server.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            this.getHandle().c.a(afw.a((int)mode.getValue()));
            this.getHandle().S = 0.0f;
            this.getHandle().a.a((fk)new gm(3, (float)mode.getValue()));
        }
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue(this.getHandle().c.b().a());
    }

    @Override
    public void giveExp(int exp) {
        this.getHandle().v(exp);
    }

    @Override
    public void giveExpLevels(int levels) {
        this.getHandle().a(levels);
    }

    @Override
    public float getExp() {
        return this.getHandle().bI;
    }

    @Override
    public void setExp(float exp) {
        this.getHandle().bI = exp;
        this.getHandle().bT = -1;
    }

    @Override
    public int getLevel() {
        return this.getHandle().bG;
    }

    @Override
    public void setLevel(int level) {
        this.getHandle().bG = level;
        this.getHandle().bT = -1;
    }

    @Override
    public int getTotalExperience() {
        return this.getHandle().bH;
    }

    @Override
    public void setTotalExperience(int exp) {
        this.getHandle().bH = exp;
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().bO().c;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().bO().c = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().bO().b;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().bO().b = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().bO().a;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().bO().a = value;
    }

    @Override
    public Location getBedSpawnLocation() {
        World world = this.getServer().getWorld(this.getHandle().spawnWorld);
        r bed = this.getHandle().bL();
        if (world != null && bed != null && (bed = xl.a((afn)((CraftWorld)world).getHandle(), (r)bed, (boolean)this.getHandle().bM())) != null) {
            return new Location(world, bed.a, bed.b, bed.c);
        }
        return null;
    }

    @Override
    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    @Override
    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().a(null, override);
        } else {
            this.getHandle().a(new r(location.getBlockX(), location.getBlockY(), location.getBlockZ()), override);
            this.getHandle().spawnWorld = location.getWorld().getName();
        }
    }

    @Override
    public void hidePlayer(Player player) {
        Validate.notNull((Object)player, (String)"hidden player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.put(player.getName(), player);
        md tracker = ((mj)this.entity.p).K;
        mm other = ((CraftPlayer)player).getHandle();
        mo entry = (mo)tracker.d.a(other.y());
        if (entry != null) {
            entry.c(this.getHandle());
        }
        this.getHandle().a.a((fk)new hc(player.getPlayerListName(), false, 9999));
    }

    @Override
    public void showPlayer(Player player) {
        Validate.notNull((Object)player, (String)"shown player cannot be null");
        if (this.getHandle().a == null) {
            return;
        }
        if (this.equals(player)) {
            return;
        }
        if (!this.hiddenPlayers.containsKey(player.getName())) {
            return;
        }
        this.hiddenPlayers.remove(player.getName());
        md tracker = ((mj)this.entity.p).K;
        mm other = ((CraftPlayer)player).getHandle();
        mo entry = (mo)tracker.d.a(other.y());
        if (entry != null && !entry.o.contains(this.getHandle())) {
            entry.b(this.getHandle());
        }
        this.getHandle().a.a((fk)new hc(player.getPlayerListName(), true, this.getHandle().i));
    }

    @Override
    public boolean canSee(Player player) {
        return !this.hiddenPlayers.containsKey(player.getName());
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    @Override
    public Player getPlayer() {
        return this;
    }

    public mm getHandle() {
        return (mm)this.entity;
    }

    public void setHandle(mm entity) {
        super.setHandle((xl)entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + '}';
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        }
        return this.hash;
    }

    @Override
    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    @Override
    public long getLastPlayed() {
        return this.lastPlayed;
    }

    @Override
    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public void readExtraData(dg nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.c("bukkit")) {
            dg data = nbttagcompound.m("bukkit");
            if (data.c("firstPlayed")) {
                this.firstPlayed = data.g("firstPlayed");
                this.lastPlayed = data.g("lastPlayed");
            }
            if (data.c("newExp")) {
                mm handle = this.getHandle();
                handle.newExp = data.f("newExp");
                handle.newTotalExp = data.f("newTotalExp");
                handle.newLevel = data.f("newLevel");
                handle.expToDrop = data.f("expToDrop");
                handle.keepLevel = data.n("keepLevel");
            }
        }
    }

    public void setExtraData(dg nbttagcompound) {
        if (!nbttagcompound.c("bukkit")) {
            nbttagcompound.a("bukkit", (du)new dg());
        }
        dg data = nbttagcompound.m("bukkit");
        mm handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
    }

    @Override
    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    @Override
    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, new ManuallyAbandonedConversationCanceller()));
    }

    @Override
    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    @Override
    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    @Override
    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        if (this.getHandle().a == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            gi packet = new gi(channel, message);
            this.getHandle().a.a((fk)packet);
        }
    }

    @Override
    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    @Override
    public void setResourcePack(String url) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        this.getHandle().a(url);
    }

    public void addChannel(String channel) {
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent(new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel)) {
            this.server.getPluginManager().callEvent(new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().a == null) {
            return;
        }
        Set<String> listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().a.a((fk)new gi("REGISTER", stream.toByteArray()));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        ye container = this.getHandle().bp;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        this.getHandle().a(container, prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    @Override
    public boolean isFlying() {
        return this.getHandle().bF.b;
    }

    @Override
    public void setFlying(boolean value) {
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().bF.b = value;
        this.getHandle().q();
    }

    @Override
    public boolean getAllowFlight() {
        return this.getHandle().bF.c;
    }

    @Override
    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().bF.b = false;
        }
        this.getHandle().bF.c = value;
        this.getHandle().q();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().bU > 0) {
            return Math.max(this.getHandle().bU, this.getHandle().ae);
        }
        return this.getHandle().ae;
    }

    @Override
    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        mm player = this.getHandle();
        player.bF.f = Math.max(value, 1.0E-4f) / 2.0f;
        player.q();
    }

    @Override
    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        mm player = this.getHandle();
        player.bF.g = Math.max(value, 1.0E-4f) / 2.0f;
        player.q();
    }

    @Override
    public float getFlySpeed() {
        return this.getHandle().bF.f * 2.0f;
    }

    @Override
    public float getWalkSpeed() {
        return this.getHandle().bF.g * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().o();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().o();
    }

    @Override
    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    @Override
    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        mx playerConnection = this.getHandle().a;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.isDisconnected()) {
            // empty if block
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    @Override
    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    @Override
    public double getHealthScale() {
        return this.healthScale;
    }

    @Override
    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    @Override
    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        this.health = health;
    }

    public void updateScaledHealth() {
        sc attributemapserver = (sc)this.getHandle().bc();
        Set set = attributemapserver.b();
        this.injectScaledMaxHealth(set, true);
        this.getHandle().z().b(6, (Object)Float.valueOf(this.getScaledHealth()));
        this.getHandle().a.a((fk)new hp(this.getScaledHealth(), this.getHandle().bO().a(), this.getHandle().bO().e()));
        this.getHandle().a.a((fk)new hy(this.getHandle().y(), (Collection)set));
        set.clear();
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void injectScaledMaxHealth(Collection collection, boolean force) {
        if (!this.scaledHealth && !force) {
            return;
        }
        for (Object genericInstance : collection) {
            rt attribute = ((ru)genericInstance).a();
            if (!attribute.a().equals("generic.maxHealth")) continue;
            collection.remove(genericInstance);
            break;
        }
        collection.add(new rz(this.getHandle().bc(), (rt)new sa("generic.maxHealth", this.scaledHealth ? this.healthScale : this.getMaxHealth(), 0.0, 3.4028234663852886E38).a("Max Health").a(true)));
    }

    @Override
    public Player.Spigot spigot() {
        return this.spigot;
    }
}

