/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import org.bukkit.craftbukkit.v1_7_R1.util.LongHash;

public class FlatMap<V> {
    private static final int FLAT_LOOKUP_SIZE = 512;
    private final Object[][] flatLookup = new Object[1024][1024];

    public void put(long msw, long lsw, V value) {
        long acx = Math.abs(msw);
        long acz2 = Math.abs(lsw);
        if (acx < 512L && acz2 < 512L) {
            this.flatLookup[(int)(msw + 512L)][(int)(lsw + 512L)] = value;
        }
    }

    public void put(long key, V value) {
        this.put(LongHash.msw(key), LongHash.lsw(key), value);
    }

    public void remove(long key) {
        this.put(key, null);
    }

    public void remove(long msw, long lsw) {
        this.put(msw, lsw, null);
    }

    public boolean contains(long msw, long lsw) {
        return this.get(msw, lsw) != null;
    }

    public boolean contains(long key) {
        return this.get(key) != null;
    }

    public V get(long msw, long lsw) {
        long acx = Math.abs(msw);
        long acz2 = Math.abs(lsw);
        if (acx < 512L && acz2 < 512L) {
            return (V)this.flatLookup[(int)(msw + 512L)][(int)(lsw + 512L)];
        }
        return null;
    }

    public V get(long key) {
        return this.get(LongHash.msw(key), LongHash.lsw(key));
    }
}

