/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.SqlUpdate;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiSqlUpdate;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.persist.PersistExecute;
import java.sql.SQLException;

public final class PersistRequestUpdateSql
extends PersistRequest {
    private final SpiSqlUpdate updateSql;
    private int rowCount;
    private String bindLog;
    private SqlType sqlType;
    private String tableName;
    private String description;

    public PersistRequestUpdateSql(SpiEbeanServer server, SqlUpdate updateSql, SpiTransaction t, PersistExecute persistExecute) {
        super(server, t, persistExecute);
        this.type = PersistRequest.Type.UPDATESQL;
        this.updateSql = (SpiSqlUpdate)updateSql;
    }

    public int executeNow() {
        return this.persistExecute.executeSqlUpdate(this);
    }

    public int executeOrQueue() {
        return this.executeStatement();
    }

    public SpiSqlUpdate getUpdateSql() {
        return this.updateSql;
    }

    public void checkRowCount(int count) throws SQLException {
        this.rowCount = count;
    }

    public boolean useGeneratedKeys() {
        return false;
    }

    public void setGeneratedKey(Object idValue) {
    }

    public void setType(SqlType sqlType, String tableName, String description) {
        this.sqlType = sqlType;
        this.tableName = tableName;
        this.description = description;
    }

    public void setBindLog(String bindLog) {
        this.bindLog = bindLog;
    }

    public void postExecute() throws SQLException {
        if (this.transaction.isLogSummary()) {
            String m = this.description + " table[" + this.tableName + "] rows[" + this.rowCount + "] bind[" + this.bindLog + "]";
            this.transaction.logInternal(m);
        }
        if (this.updateSql.isAutoTableMod()) {
            switch (this.sqlType) {
                case SQL_INSERT: {
                    this.transaction.getEvent().add(this.tableName, true, false, false);
                    break;
                }
                case SQL_UPDATE: {
                    this.transaction.getEvent().add(this.tableName, false, true, false);
                    break;
                }
                case SQL_DELETE: {
                    this.transaction.getEvent().add(this.tableName, false, false, true);
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SqlType {
        SQL_UPDATE,
        SQL_DELETE,
        SQL_INSERT,
        SQL_UNKNOWN;

    }
}

