/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.functions.GenericIterableFactory;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;

public class FMLControlledNamespacedRegistry<I>
extends cv {
    private final Class<I> superType;
    private String optionalDefaultName;
    private I optionalDefaultObject;
    private int maxId;
    private int minId;
    private char discriminator;
    private final Map<String, String> aliases = new HashMap<String, String>();

    FMLControlledNamespacedRegistry(String optionalDefault, int maxIdValue, int minIdValue, Class<I> type, char discriminator) {
        this.superType = type;
        this.discriminator = discriminator;
        this.optionalDefaultName = optionalDefault;
        this.maxId = maxIdValue;
        this.minId = minIdValue;
    }

    void validateContent(int maxId, String type, BitSet availabilityMap, Set<Integer> blockedIds, FMLControlledNamespacedRegistry<ahu> iBlockRegistry) {
        for (I obj : this.typeSafeIterable()) {
            int id = this.getId(obj);
            String name = this.c(obj);
            if (id < 0) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s, doesn't yield an id.", type, obj, name));
            }
            if (id > maxId) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, name %s uses the too large id %d.", type, obj, name));
            }
            if (name == null) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, doesn't yield a name.", type, obj, id));
            }
            if (name.isEmpty()) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, yields an empty name.", type, obj, id));
            }
            if (name.indexOf(58) == -1) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, has the non-prefixed name %s.", type, obj, id, name));
            }
            if (this.getRaw(id) != obj) {
                throw new IllegalStateException(String.format("Registry entry for id %d, name %s, doesn't yield the expected %s %s.", id, name, type, obj));
            }
            if (this.getRaw(name) != obj) {
                throw new IllegalStateException(String.format("Registry entry for name %s, id %d, doesn't yield the expected %s %s.", name, id, type, obj));
            }
            if (this.getId(name) != id) {
                throw new IllegalStateException(String.format("Registry entry for name %s doesn't yield the expected id %d.", name, id));
            }
            if (!availabilityMap.get(id)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as empty.", type, obj, id, name));
            }
            if (blockedIds.contains(id)) {
                throw new IllegalStateException(String.format("Registry entry for %s %s, id %d, name %s, marked as dangling.", type, obj, id, name));
            }
            if (!(obj instanceof zt)) continue;
            ahu block = ((zt)obj).a;
            if (iBlockRegistry.getId(block) != id) {
                throw new IllegalStateException(String.format("Registry entry for ItemBlock %s, id %d, is missing or uses the non-matching id %d.", obj, id, iBlockRegistry.getId(block)));
            }
            if (id <= 4095) continue;
            throw new IllegalStateException(String.format("ItemBlock %s uses the id %d outside the block id range", name, id));
        }
    }

    void set(FMLControlledNamespacedRegistry<I> registry) {
        if (this.superType != registry.superType) {
            throw new IllegalArgumentException("incompatible registry");
        }
        this.discriminator = registry.discriminator;
        this.optionalDefaultName = registry.optionalDefaultName;
        this.maxId = registry.maxId;
        this.minId = registry.minId;
        this.aliases.clear();
        this.aliases.putAll(registry.aliases);
        this.a = new cs();
        this.c.clear();
        for (I thing : registry.typeSafeIterable()) {
            this.addObjectRaw(registry.getId(thing), registry.c(thing), thing);
        }
    }

    @Deprecated
    public void a(int id, String name, Object thing) {
        GameData.getMain().register(thing, name, id);
    }

    @Deprecated
    public void a(Object objName, Object obj) {
        String name = (String)objName;
        I thing = this.superType.cast(obj);
        if (name == null) {
            throw new NullPointerException("Can't use a null-name for the registry.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Can't use an empty name for the registry.");
        }
        if (thing == null) {
            throw new NullPointerException("Can't add null-object to the registry.");
        }
        name = FMLControlledNamespacedRegistry.c((String)name);
        String existingName = this.c(thing);
        if (existingName == null) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), not resolvable", name, thing);
        } else if (existingName.equals(name)) {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), already added", name, thing);
        } else {
            FMLLog.bigWarning("Ignoring putObject(%s, %s), adding alias to %s instead", name, thing, existingName);
            this.addAlias(name, existingName);
        }
    }

    public I a(String name) {
        I object = this.getRaw(name);
        return object == null ? this.optionalDefaultObject : object;
    }

    public I a(int id) {
        I object = this.getRaw(id);
        return object == null ? this.optionalDefaultObject : object;
    }

    @Deprecated
    public I get(int id) {
        return this.a(id);
    }

    @Deprecated
    public I get(String name) {
        return this.a(name);
    }

    public int getId(I thing) {
        return this.b(thing);
    }

    public I getRaw(int id) {
        return this.superType.cast(super.a(id));
    }

    public I getRaw(String name) {
        I ret = this.superType.cast(super.a(name));
        if (ret == null && (name = this.aliases.get(name)) != null) {
            return this.getRaw(name);
        }
        return ret;
    }

    public boolean b(String name) {
        boolean ret = super.b(name);
        if (!ret && (name = this.aliases.get(name)) != null) {
            return this.b(name);
        }
        return ret;
    }

    public int getId(String itemName) {
        I obj = this.getRaw(itemName);
        if (obj == null) {
            return -1;
        }
        return this.getId(obj);
    }

    @Deprecated
    public boolean contains(String itemName) {
        return this.b(itemName);
    }

    public Iterable<I> typeSafeIterable() {
        FMLControlledNamespacedRegistry self = this;
        return GenericIterableFactory.newCastingIterable(self, this.superType);
    }

    public void serializeInto(Map<String, Integer> idMapping) {
        for (I thing : this.typeSafeIterable()) {
            idMapping.put(this.discriminator + this.c(thing), this.getId(thing));
        }
    }

    public Map<String, String> getAliases() {
        return ImmutableMap.copyOf(this.aliases);
    }

    int add(int id, String name, I thing, BitSet availabilityMap) {
        int idToUse;
        if (name == null) {
            throw new NullPointerException(String.format("Can't use a null-name for the registry, object %s.", thing));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't use an empty name for the registry, object %s.", thing));
        }
        if (name.indexOf(58) == -1) {
            throw new IllegalArgumentException(String.format("Can't add the name (%s) without a prefix, object %s", name, thing));
        }
        if (thing == null) {
            throw new NullPointerException(String.format("Can't add null-object to the registry, name %s.", name));
        }
        if (name.equals(this.optionalDefaultName) && this.optionalDefaultObject == null) {
            this.optionalDefaultObject = thing;
        }
        if ((idToUse = id) < 0 || availabilityMap.get(idToUse)) {
            idToUse = availabilityMap.nextClearBit(this.minId);
        }
        if (idToUse > this.maxId) {
            throw new RuntimeException(String.format("Invalid id %d - maximum id range exceeded.", idToUse));
        }
        if (this.getRaw(name) == thing) {
            FMLLog.bigWarning("The object %s has been registered twice for the same name %s.", thing, name);
            return this.getId(thing);
        }
        if (this.getRaw(name) != null) {
            throw new IllegalArgumentException(String.format("The name %s has been registered twice, for %s and %s.", name, this.getRaw(name), thing));
        }
        if (this.getId(thing) >= 0) {
            int foundId = this.getId(thing);
            I otherThing = this.getRaw(foundId);
            throw new IllegalArgumentException(String.format("The object %s{%x} has been registered twice, using the names %s and %s. (Other object at this id is %s{%x})", thing, System.identityHashCode(thing), this.c(thing), name, otherThing, System.identityHashCode(otherThing)));
        }
        if (GameData.isFrozen(this)) {
            FMLLog.bigWarning("The object %s (name %s) is being added too late.", thing, name);
        }
        this.addObjectRaw(idToUse, name, thing);
        FMLLog.finer("Registry add: %s %d %s (req. id %d)", name, idToUse, thing, id);
        return idToUse;
    }

    void addAlias(String from, String to) {
        this.aliases.put(from, to);
        FMLLog.finer("Registry alias: %s -> %s", from, to);
    }

    Map<String, Integer> getEntriesNotIn(FMLControlledNamespacedRegistry<I> registry) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (I thing : this.typeSafeIterable()) {
            if (registry.b.containsKey(thing)) continue;
            ret.put(this.c(thing), this.getId(thing));
        }
        return ret;
    }

    void dump() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (I thing : this.typeSafeIterable()) {
            ids.add(this.getId(thing));
        }
        Collections.sort(ids);
        Iterator<Object> i$ = ids.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            I thing = this.getRaw(id);
            FMLLog.finer("Registry: %s %d %s", this.c(thing), id, thing);
        }
    }

    private void addObjectRaw(int id, String name, I thing) {
        if (name == null) {
            throw new NullPointerException("The name to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (thing == null) {
            throw new NullPointerException("The object to be added to the registry is null. This can only happen with a corrupted registry state. Reflection/ASM hackery? Registry bug?");
        }
        if (!this.superType.isInstance(thing)) {
            throw new IllegalArgumentException("The object to be added to the registry is not of the right type. Reflection/ASM hackery? Registry bug?");
        }
        boolean isBlock = thing instanceof ahu;
        Material material = Material.addMaterial(id, name, isBlock);
        if (material != null) {
            if (isBlock) {
                FMLLog.info("Injected new Forge block material %s with ID %d.", material.name(), material.getId());
            } else {
                FMLLog.info("Injected new Forge item material %s with ID %d.", material.name(), material.getId());
            }
        }
        this.a.a(thing, id);
        super.a((Object)name, thing);
    }

    public I getDefaultValue() {
        return this.optionalDefaultObject;
    }
}

