/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.avaje.ebean.config.DataSourceConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.SQLitePlatform;
import com.avaje.ebeaninternal.server.lib.sql.TransactionIsolation;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.FMLLog;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import jline.console.ConsoleReader;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.CraftBanList;
import org.bukkit.craftbukkit.CraftOfflinePlayer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.command.CraftSimpleCommandMap;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.help.SimpleHelpMap;
import org.bukkit.craftbukkit.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.inventory.CraftRecipe;
import org.bukkit.craftbukkit.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.inventory.RecipeIterator;
import org.bukkit.craftbukkit.map.CraftMapView;
import org.bukkit.craftbukkit.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.potion.CraftPotionBrewer;
import org.bukkit.craftbukkit.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.updater.AutoUpdater;
import org.bukkit.craftbukkit.updater.BukkitDLUpdaterService;
import org.bukkit.craftbukkit.util.CraftIconCache;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.util.DatFileFilter;
import org.bukkit.craftbukkit.util.Versioning;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.Potion;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.spigotmc.SpigotConfig;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import za.co.mcportcentral.MCPCConfig;
import za.co.mcportcentral.MCPCHooks;

public final class CraftServer
implements Server {
    private final String serverName = "MCPC+";
    private final String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftSimpleCommandMap craftCommandMap = new CraftSimpleCommandMap(this);
    private final SimpleCommandMap commandMap = new SimpleCommandMap(this);
    private final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final PluginManager pluginManager = new SimplePluginManager(this, this.commandMap);
    protected final MinecraftServer console;
    protected final li playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    public YamlConfiguration configuration = MinecraftServer.configuration;
    private YamlConfiguration commandsConfiguration = MinecraftServer.commandsConfiguration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
    private final Map<String, OfflinePlayer> offlinePlayers = new MapMaker().softValues().makeMap();
    private final AutoUpdater updater;
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int ambientSpawn = -1;
    public int chunkGCPeriod = -1;
    public int chunkGCLoadThresh = 0;
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    private final BooleanWrapper online = new BooleanWrapper();
    public CraftScoreboardManager scoreboardManager;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandBlockCommands = false;

    public CraftServer(MinecraftServer console, ld playerList) {
        this.console = console;
        this.playerList = (li)playerList;
        this.serverVersion = CraftServer.class.getPackage().getImplementationVersion();
        this.online.value = console.getPropertyManager().a("online-mode", true);
        Bukkit.setServer(this);
        aef.l.getClass();
        Potion.setPotionBrewer(new CraftPotionBrewer());
        qi.q.getClass();
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        ((SimplePluginManager)this.pluginManager).useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.monsterSpawn = this.configuration.getInt("spawn-limits.monsters");
        this.animalSpawn = this.configuration.getInt("spawn-limits.animals");
        this.waterAnimalSpawn = this.configuration.getInt("spawn-limits.water-animals");
        this.ambientSpawn = this.configuration.getInt("spawn-limits.ambient");
        console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value(this.configuration.getString("settings.deprecated-verbose"));
        this.chunkGCPeriod = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.chunkGCLoadThresh = this.configuration.getInt("chunk-gc.load-threshold");
        this.loadIcon();
        MCPCConfig.init();
        this.updater = new AutoUpdater(new BukkitDLUpdaterService(this.configuration.getString("auto-updater.host")), this.getLogger(), this.configuration.getString("auto-updater.preferred-channel"));
        this.updater.setEnabled(false);
        this.updater.setSuggestChannels(this.configuration.getBoolean("auto-updater.suggest-channels"));
        this.updater.getOnBroken().addAll(this.configuration.getStringList("auto-updater.on-broken"));
        this.updater.getOnUpdate().addAll(this.configuration.getStringList("auto-updater.on-update"));
        this.updater.check(this.serverVersion);
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandBlockCommands || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)MinecraftServer.options.valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)MinecraftServer.options.valueOf("commands-settings");
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getConfigFile(), ex);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getCommandsConfigFile(), ex);
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        File pluginFolder = (File)MinecraftServer.options.valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format("Loading %s", plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        CraftBlock.initMappings();
        CraftEntity.initMappings();
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.loadPlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands();
            this.commandMap.registerServerAliases();
            this.loadCustomPermissions();
            DefaultPermissions.registerCorePermissions();
            this.helpMap.initializeCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands() {
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ae(), "/achievement give <stat_name> [player]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ag(), "/ban <playername> [reason]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new af(), "/ban-ip <ip-address|playername>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ax(), "/banlist [ips]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ai(), "/clear <playername> [item] [metadata]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new al(), "/defaultgamemode <mode>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new aj(), "/deop <playername>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new aq(), "/difficulty <new difficulty>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new am(), "/effect <player> <effect|clear> [seconds] [amplifier]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ao(), "/enchant <playername> <enchantment ID> [enchantment level]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ar(), "/gamemode <mode> [player]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new as(), "/gamerule <rulename> [true|false]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new at(), "/give <playername> <item> [amount] [metadata] [dataTag]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new au(), "/help [page|commandname]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bn(), "/setidletimeout <Minutes until kick>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new av(), "/kick <playername> [reason]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new aw(), "/kill [playername]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ay(), "/list"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new an(), "/me <actiontext>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bb(), "/op <playername>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bd(), "/pardon <playername>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bc(), "/pardon-ip <ip-address>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new be(), "/playsound <sound> <playername> [x] [y] [z] [volume] [pitch] [minimumVolume]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ah(), "/say <message>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bj(), "/scoreboard"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bp(), "/seed"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bl(), "/setblock <x> <y> <z> <tilename> [datavalue] [oldblockHandling] [dataTag]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bm(), "/setworldspawn [x] [y] [z]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bo(), "/spawnpoint <playername> [x] [y] [z]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bq(), "/spreadplayers <x> <z> [spreadDistance] [maxRange] [respectTeams] <playernames>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bt(), "/summon <EntityName> [x] [y] [z] [dataTag]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bu(), "/tp [player] <target>\n/tp [player] <x> <y> <z>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new az(), "/tell <playername> <message>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ba(), "/tellraw <playername> <raw message>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bx(), "/testfor <playername | selector> [dataTag]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bw(), "/testforblock <x> <y> <z> <tilename> [datavalue] [dataTag]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new by(), "/time set <value>\n/time add <value>"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new bz(), "/toggledownfall"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ca(), "/weather <clear/rain/thunder> [duration in seconds]"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new cb(), "/whitelist (add|remove) <player>\n/whitelist (on|off|list|reload)"));
        this.commandMap.register("minecraft", new VanillaCommandWrapper((y)new ap(), "/xp <amount> [player]\n/xp <amount>L [player]"));
    }

    private void loadPlugin(Plugin plugin) {
        try {
            this.pluginManager.enablePlugin(plugin);
            List<Permission> perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    @Override
    public String getName() {
        return "MCPC+";
    }

    @Override
    public String getVersion() {
        return this.serverVersion + " (MC: " + this.console.A() + ")";
    }

    @Override
    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    @Override
    public Player[] getOnlinePlayers() {
        List online = this.playerList.a;
        Player[] players = new Player[online.size()];
        for (int i = 0; i < players.length; ++i) {
            players[i] = ((mm)online.get((int)i)).a.getPlayerB();
        }
        return players;
    }

    @Override
    public Player getPlayer(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        Player[] players = this.getOnlinePlayers();
        Player found = null;
        String lowerName = name.toLowerCase();
        int delta = Integer.MAX_VALUE;
        for (Player player : players) {
            if (!player.getName().toLowerCase().startsWith(lowerName)) continue;
            int curDelta = player.getName().length() - lowerName.length();
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta == 0) break;
        }
        return found;
    }

    @Override
    public Player getPlayerExact(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        String lname = name.toLowerCase();
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().equalsIgnoreCase(lname)) continue;
            return player;
        }
        return null;
    }

    @Override
    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    public Player getPlayer(mm entity) {
        return entity.a.getPlayerB();
    }

    @Override
    public List<Player> matchPlayer(String partialName) {
        Validate.notNull((Object)partialName, (String)"PartialName cannot be null");
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase().contains(partialName.toLowerCase())) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.l();
    }

    @Override
    public int getPort() {
        return this.getConfigInt("server-port", 25565);
    }

    @Override
    public int getViewDistance() {
        return this.getConfigInt("view-distance", 10);
    }

    @Override
    public String getIp() {
        return this.getConfigString("server-ip", "");
    }

    @Override
    public String getServerName() {
        return this.getConfigString("server-name", "Unknown Server");
    }

    @Override
    public String getServerId() {
        return this.getConfigString("server-id", "unnamed");
    }

    @Override
    public String getWorldType() {
        return this.getConfigString("level-type", "DEFAULT");
    }

    @Override
    public boolean getGenerateStructures() {
        return this.getConfigBoolean("generate-structures", true);
    }

    @Override
    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    @Override
    public boolean getAllowNether() {
        return this.getConfigBoolean("allow-nether", true);
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    @Override
    public boolean hasWhitelist() {
        return this.getConfigBoolean("white-list", false);
    }

    private String getConfigString(String variable, String defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    private int getConfigInt(String variable, int defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    private boolean getConfigBoolean(String variable, boolean defaultValue) {
        return this.console.getPropertyManager().a(variable, defaultValue);
    }

    @Override
    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    @Override
    public File getUpdateFolderFile() {
        return new File((File)MinecraftServer.options.valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    public int getPingPacketLimit() {
        return this.configuration.getInt("settings.ping-packet-limit", 100);
    }

    @Override
    public long getConnectionThrottle() {
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Override
    public int getTicksPerAnimalSpawns() {
        return this.configuration.getInt("ticks-per.animal-spawns");
    }

    @Override
    public int getTicksPerMonsterSpawns() {
        return this.configuration.getInt("ticks-per.monster-spawns");
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Override
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public li getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, ku serverCommand) {
        Conversable conversable;
        if (sender instanceof Conversable && (conversable = (Conversable)((Object)sender)).isConversing()) {
            conversable.acceptConversationInput(serverCommand.a);
            return true;
        }
        try {
            this.playerCommandState = true;
            int space = serverCommand.a.indexOf(" ");
            if (this.getCommandMap().getCommand(serverCommand.a.substring(0, space != -1 ? space : serverCommand.a.length())) != null) {
                boolean bl2 = this.dispatchCommand(sender, serverCommand.a);
                return bl2;
            }
            this.craftCommandMap.setVanillaConsoleSender(serverCommand.b);
            boolean bl3 = this.dispatchVanillaCommand(sender, serverCommand.a);
            return bl3;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.a + '\"', ex);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    @Override
    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)commandLine, (String)"CommandLine cannot be null");
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (sender instanceof ConsoleCommandSender) {
            this.craftCommandMap.setVanillaConsoleSender((ac)this.console);
        }
        return this.dispatchVanillaCommand(sender, commandLine);
    }

    public boolean dispatchVanillaCommand(CommandSender sender, String commandLine) {
        if (this.craftCommandMap.dispatch(sender, commandLine)) {
            return true;
        }
        sender.sendMessage(SpigotConfig.unknownCommandMessage);
        return false;
    }

    public String getBukkitToForgeMapping(String name) {
        String result = MCPCConfig.getString("bukkit-to-forge-mappings." + name, name, false);
        return result;
    }

    @Override
    public void reload() {
        lg config;
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        ((lj)this.console).l = config = new lg(MinecraftServer.options);
        boolean animals = config.a("spawn-animals", this.console.X());
        boolean monsters = config.a("spawn-monsters", ((mj)this.console.worlds.get((int)0)).r != pq.a);
        pq difficulty = pq.a((int)config.a("difficulty", ((mj)this.console.worlds.get((int)0)).r.ordinal()));
        this.online.value = config.a("online-mode", this.console.W());
        this.console.e(config.a("spawn-animals", this.console.X()));
        this.console.g(config.a("pvp", this.console.Z()));
        this.console.h(config.a("allow-flight", this.console.aa()));
        this.console.n(config.a("motd", this.console.ac()));
        this.monsterSpawn = this.configuration.getInt("spawn-limits.monsters");
        this.animalSpawn = this.configuration.getInt("spawn-limits.animals");
        this.waterAnimalSpawn = this.configuration.getInt("spawn-limits.water-animals");
        this.ambientSpawn = this.configuration.getInt("spawn-limits.ambient");
        this.warningState = Warning.WarningState.value(this.configuration.getString("settings.deprecated-verbose"));
        this.printSaveWarning = false;
        this.console.autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.chunkGCPeriod = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.chunkGCLoadThresh = this.configuration.getInt("chunk-gc.load-threshold");
        this.loadIcon();
        this.playerList.f().e();
        this.playerList.e().e();
        SpigotConfig.init();
        MCPCConfig.init();
        for (mj world : this.console.worlds) {
            world.r = difficulty;
            world.a(monsters, animals);
            world.ticksPerAnimalSpawns = this.getTicksPerAnimalSpawns() < 0 ? 400L : (long)this.getTicksPerAnimalSpawns();
            world.ticksPerMonsterSpawns = this.getTicksPerMonsterSpawns() < 0 ? 1L : (long)this.getTicksPerMonsterSpawns();
            world.spigotConfig.init();
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.resetRecipes();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        SpigotConfig.registerCommands();
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            String author = "<NoAuthorGiven>";
            if (plugin.getDescription().getAuthors().size() > 0) {
                author = plugin.getDescription().getAuthors().get(0);
            }
            this.getLogger().log(Level.SEVERE, String.format("Nag author: '%s' of '%s' about the following: %s", author, plugin.getDescription().getName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML: " + ex.toString());
            return;
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML.", ex);
            try {
                stream.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + file + " is empty, ignoring it");
            return;
        }
        List<Permission> permsList = Permission.loadPermissions(perms, "Permission node '%s' in " + file + " is invalid", Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.SEVERE, "Permission in " + file + " was already defined", ex);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=MCPC+,serverVersion=" + this.serverVersion + ",minecraftVersion=" + this.console.A() + '}';
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name(name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name(name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    @Override
    public World createWorld(WorldCreator creator) {
        Validate.notNull((Object)creator, (String)"Creator may not be null");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        afy type = afy.a((String)creator.type().getName());
        boolean generateStructures = creator.generateStructures();
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("File exists with the name '" + name + "' and isn't a folder");
        }
        if (world != null) {
            return world;
        }
        boolean hardcore = false;
        afv worldSettings = new afv(creator.seed(), afw.a((int)this.getDefaultGameMode().getValue()), generateStructures, hardcore, type);
        mj worldserver = DimensionManager.initDimension(creator, worldSettings);
        this.pluginManager.callEvent(new WorldInitEvent(worldserver.getWorld()));
        MCPCHooks.craftWorldLoading = true;
        System.out.print("Preparing start region for level " + (this.console.worlds.size() - 1) + " (Dimension: " + worldserver.t.i + ", Seed: " + worldserver.G() + ")");
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            int short1 = 196;
            long i = System.currentTimeMillis();
            for (int j = -short1; j <= short1; j += 16) {
                for (int k2 = -short1; k2 <= short1; k2 += 16) {
                    long l = System.currentTimeMillis();
                    if (l < i) {
                        i = l;
                    }
                    if (l > i + 1000L) {
                        int i1 = (short1 * 2 + 1) * (short1 * 2 + 1);
                        int j1 = (j + short1) * (short1 * 2 + 1) + k2 + 1;
                        System.out.println("Preparing spawn area for " + worldserver.getWorld().getName() + ", " + j1 * 100 / i1 + "%");
                        i = l;
                    }
                    r chunkcoordinates = worldserver.J();
                    worldserver.b.c(chunkcoordinates.a + j >> 4, chunkcoordinates.c + k2 >> 4);
                }
            }
        }
        this.pluginManager.callEvent(new WorldLoadEvent(worldserver.getWorld()));
        MCPCHooks.craftWorldLoading = false;
        return worldserver.getWorld();
    }

    @Override
    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    @Override
    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        mj handle = ((CraftWorld)world).getHandle();
        if (!this.console.worlds.contains(handle)) {
            return false;
        }
        if (handle.h.size() > 0) {
            return false;
        }
        WorldUnloadEvent e = new WorldUnloadEvent(handle.getWorld());
        this.pluginManager.callEvent(e);
        if (e.isCancelled()) {
            return false;
        }
        if (save) {
            try {
                handle.a(true, null);
                handle.n();
                WorldSaveEvent event = new WorldSaveEvent(handle.getWorld());
                this.getPluginManager().callEvent(event);
            }
            catch (afs ex) {
                this.getLogger().log(Level.SEVERE, null, ex);
                FMLLog.log(org.apache.logging.log4j.Level.ERROR, ex, "Failed to save world " + handle.getWorld().getName() + " while unloading it.", new Object[0]);
            }
        }
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload((afn)handle));
        this.worlds.remove(world.getName().toLowerCase());
        DimensionManager.setWorld(handle.t.i, null);
        return true;
    }

    public MinecraftServer getServer() {
        return this.console;
    }

    @Override
    public World getWorld(String name) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.worlds.get(name.toLowerCase());
    }

    @Override
    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            System.out.println("World " + world.getName() + " is a duplicate of another world and has been prevented from loading. Please delete the uid.dat file from " + world.getName() + "'s world directory if you want to be able to load the duplicate world.");
            return;
        }
        this.worlds.put(world.getName().toLowerCase(), world);
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public ConsoleReader getReader() {
        return this.console.reader;
    }

    @Override
    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    @Override
    public void savePlayers() {
        this.checkSaveState();
        this.playerList.g();
    }

    @Override
    public void configureDbConfig(ServerConfig config) {
        Validate.notNull((Object)config, (String)"Config cannot be null");
        DataSourceConfig ds = new DataSourceConfig();
        ds.setDriver(this.configuration.getString("database.driver"));
        ds.setUrl(this.configuration.getString("database.url"));
        ds.setUsername(this.configuration.getString("database.username"));
        ds.setPassword(this.configuration.getString("database.password"));
        ds.setIsolationLevel(TransactionIsolation.getLevel((String)this.configuration.getString("database.isolation")));
        if (ds.getDriver().contains("sqlite")) {
            config.setDatabasePlatform((DatabasePlatform)new SQLitePlatform());
            config.getDatabasePlatform().getDbDdlSyntax().setIdentity("");
        }
        config.setDataSourceConfig(ds);
    }

    @Override
    public boolean addRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else {
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    @Override
    public List<Recipe> getRecipesFor(ItemStack result) {
        Validate.notNull((Object)result, (String)"Result cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    @Override
    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    @Override
    public void clearRecipes() {
        adq.a().b.clear();
        adm.a().b.clear();
        adm.a().customRecipes.clear();
    }

    @Override
    public void resetRecipes() {
        adq.a().b = new adq().b;
        adm.a().b = new adm().b;
        adm.a().customRecipes.clear();
    }

    @Override
    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.configuration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ImmutableList commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    @Override
    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    @Override
    public int getSpawnRadius() {
        return ((lj)this.console).l.a("spawn-protection", 16);
    }

    @Override
    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", value);
        this.saveConfig();
    }

    @Override
    public boolean getOnlineMode() {
        return this.online.value;
    }

    @Override
    public boolean getAllowFlight() {
        return this.console.aa();
    }

    @Override
    public boolean isHardcore() {
        return this.console.k();
    }

    @Override
    public boolean useExactLoginLocation() {
        return this.configuration.getBoolean("settings.use-exact-login-location");
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    @Override
    public CraftMapView getMap(short id) {
        ayc collection = ((mj)this.console.worlds.get((int)0)).z;
        awu worldmap = (awu)collection.a(awu.class, "map_" + id);
        if (worldmap == null) {
            return null;
        }
        return worldmap.mapView;
    }

    @Override
    public CraftMapView createMap(World world) {
        Validate.notNull((Object)world, (String)"World cannot be null");
        abp stack = new abp((abn)abq.aY, 1, -1);
        awu worldmap = abq.aY.a(stack, (afn)((CraftWorld)world).getHandle());
        return worldmap.mapView;
    }

    @Override
    public void shutdown() {
        this.console.q();
    }

    @Override
    public int broadcast(String message, String permission) {
        int count = 0;
        Set<Permissible> permissibles = this.getPluginManager().getPermissionSubscriptions(permission);
        for (Permissible permissible : permissibles) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            CommandSender user = (CommandSender)permissible;
            user.sendMessage(message);
            ++count;
        }
        return count;
    }

    @Override
    public OfflinePlayer getOfflinePlayer(String name) {
        return this.getOfflinePlayer(name, false);
    }

    public OfflinePlayer getOfflinePlayer(String name, boolean search) {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        OfflinePlayer result = this.getPlayerExact(name);
        String lname = name.toLowerCase();
        if (result == null) {
            result = this.offlinePlayers.get(lname);
            if (result == null) {
                if (search) {
                    axc storage = (axc)((mj)this.console.worlds.get(0)).L();
                    for (String dat : storage.getPlayerDir().list(new DatFileFilter())) {
                        String datName = dat.substring(0, dat.length() - 4);
                        if (!datName.equalsIgnoreCase(name)) continue;
                        name = datName;
                        break;
                    }
                }
                result = new CraftOfflinePlayer(this, name);
                this.offlinePlayers.put(lname, result);
            }
        } else {
            this.offlinePlayers.remove(lname);
        }
        return result;
    }

    @Override
    public Set<String> getIPBans() {
        return new HashSet<String>(this.playerList.f().c().keySet());
    }

    @Override
    public void banIP(String address) {
        Validate.notNull((Object)address, (String)"Address cannot be null.");
        this.getBanList(BanList.Type.IP).addBan(address, null, null, null);
    }

    @Override
    public void unbanIP(String address) {
        Validate.notNull((Object)address, (String)"Address cannot be null.");
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    @Override
    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (Object name : this.playerList.e().c().keySet()) {
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    @Override
    public BanList getBanList(BanList.Type type) {
        Validate.notNull((Object)((Object)type), (String)"Type cannot be null");
        switch (type) {
            case IP: {
                return new CraftBanList(this.playerList.f());
            }
        }
        return new CraftBanList(this.playerList.e());
    }

    @Override
    public void setWhitelist(boolean value) {
        this.playerList.m = value;
        this.console.getPropertyManager().a("white-list", (Object)value);
    }

    @Override
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (Object name : this.playerList.h()) {
            if (((String)name).length() == 0 || ((String)name).startsWith("#")) continue;
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    @Override
    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (Object name : this.playerList.i()) {
            result.add(this.getOfflinePlayer((String)name));
        }
        return result;
    }

    @Override
    public void reloadWhitelist() {
        this.playerList.j();
    }

    @Override
    public GameMode getDefaultGameMode() {
        return GameMode.getByValue(((mj)this.console.worlds.get(0)).M().r().a());
    }

    @Override
    public void setDefaultGameMode(GameMode mode) {
        Validate.notNull((Object)((Object)mode), (String)"Mode cannot be null");
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().x.a(afw.a((int)mode.getValue()));
        }
    }

    @Override
    public ConsoleCommandSender getConsoleSender() {
        return this.console.console;
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    public void detectListNameConflict(mm entityPlayer) {
        for (int i = 0; i < this.getHandle().a.size(); ++i) {
            mm testEntityPlayer = (mm)this.getHandle().a.get(i);
            if (testEntityPlayer == entityPlayer || !testEntityPlayer.listName.equals(entityPlayer.listName)) continue;
            String oldName = entityPlayer.listName;
            int spaceLeft = 16 - oldName.length();
            entityPlayer.listName = spaceLeft <= 1 ? oldName.subSequence(0, oldName.length() - 2 - spaceLeft) + String.valueOf(System.currentTimeMillis() % 99L) : oldName + String.valueOf(System.currentTimeMillis() % 99L);
            return;
        }
    }

    @Override
    public File getWorldContainer() {
        if (DimensionManager.getWorld(0) != null) {
            return ((axc)DimensionManager.getWorld(0).L()).b();
        }
        if (this.container == null) {
            this.container = new File(this.configuration.getString("settings.world-container", "."));
        }
        return this.container;
    }

    @Override
    public OfflinePlayer[] getOfflinePlayers() {
        axc storage = (axc)((mj)this.console.worlds.get(0)).L();
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            players.add(this.getOfflinePlayer(file.substring(0, file.length() - 4), false));
        }
        players.addAll(Arrays.asList(this.getOnlinePlayers()));
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.getMessenger(), source, channel, message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    public void onPlayerJoin(Player player) {
        if (this.updater.isEnabled() && this.updater.getCurrent() != null && player.hasPermission("bukkit.broadcast.admin")) {
            if (this.updater.getCurrent().isBroken() && this.updater.getOnBroken().contains("warn-ops")) {
                player.sendMessage((Object)((Object)ChatColor.DARK_RED) + "The version of CraftBukkit that this server is running is known to be broken. Please consider updating to the latest version at dl.bukkit.org.");
            } else if (this.updater.isUpdateAvailable() && this.updater.getOnUpdate().contains("warn-ops")) {
                player.sendMessage((Object)((Object)ChatColor.DARK_PURPLE) + "The version of CraftBukkit that this server is running is out of date. Please consider updating to the latest version at dl.bukkit.org.");
            }
        }
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        return new CraftInventoryCustom(owner, type);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Validate.isTrue((size % 9 == 0 ? 1 : 0) != 0, (String)"Chests must have a size that is a multiple of 9!");
        return new CraftInventoryCustom(owner, size);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Validate.isTrue((size % 9 == 0 ? 1 : 0) != 0, (String)"Chests must have a size that is a multiple of 9!");
        return new CraftInventoryCustom(owner, size, title);
    }

    @Override
    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    public CraftSimpleCommandMap getCraftCommandMap() {
        return this.craftCommandMap;
    }

    @Override
    public int getMonsterSpawnLimit() {
        return this.monsterSpawn;
    }

    @Override
    public int getAnimalSpawnLimit() {
        return this.animalSpawn;
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        return this.waterAnimalSpawn;
    }

    @Override
    public int getAmbientSpawnLimit() {
        return this.ambientSpawn;
    }

    @Override
    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.primaryThread);
    }

    @Override
    public String getMotd() {
        return this.console.ac();
    }

    @Override
    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(ac sender, String message) {
        if (!(sender instanceof mm)) {
            return ImmutableList.of();
        }
        CraftPlayer player = ((mm)sender).getBukkitEntity();
        if (message.startsWith("/")) {
            return this.tabCompleteCommand(player, message);
        }
        return this.tabCompleteChat(player, message);
    }

    public List<String> tabCompleteCommand(Player player, String message) {
        if (!SpigotConfig.tabComplete && !message.contains(" ")) {
            return ImmutableList.of();
        }
        ArrayList<String> completions = new ArrayList<String>();
        try {
            List<String> vanillaCompletions;
            message = message.substring(1);
            List<String> bukkitCompletions = this.getCommandMap().tabComplete(player, message);
            if (bukkitCompletions != null) {
                completions.addAll(bukkitCompletions);
            }
            if ((vanillaCompletions = org.spigotmc.VanillaCommandWrapper.complete(player, message)) != null) {
                completions.addAll(vanillaCompletions);
            }
        }
        catch (CommandException ex) {
            player.sendMessage((Object)((Object)ChatColor.RED) + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        Player[] players = this.getOnlinePlayers();
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p2 : players) {
            if (!player.canSee(p2) || !StringUtil.startsWithIgnoreCase(p2.getName(), token)) continue;
            completions.add(p2.getName());
        }
        this.pluginManager.callEvent(event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    @Override
    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    @Override
    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning || this.console.autosavePeriod <= 0) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    @Override
    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    @Override
    public CraftIconCache loadServerIcon(File file) throws Exception {
        Validate.notNull((Object)file, (String)"File cannot be null");
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a file");
        }
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    @Override
    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Validate.notNull((Object)image, (String)"Image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        ByteBuf bytebuf = Unpooled.buffer();
        Validate.isTrue((image.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide");
        Validate.isTrue((image.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high");
        ImageIO.write((RenderedImage)image, "PNG", (OutputStream)new ByteBufOutputStream(bytebuf));
        ByteBuf bytebuf1 = Base64.encode((ByteBuf)bytebuf);
        return new CraftIconCache("data:image/png;base64," + bytebuf1.toString(Charsets.UTF_8));
    }

    @Override
    public void setIdleTimeout(int threshold) {
        this.console.d(threshold);
    }

    @Override
    public int getIdleTimeout() {
        return this.console.aq();
    }

    @Override
    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        CraftItemFactory.instance();
    }

    private final class BooleanWrapper {
        private boolean value = true;

        private BooleanWrapper() {
        }
    }
}

