/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftAmbient;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.craftbukkit.entity.CraftArrow;
import org.bukkit.craftbukkit.entity.CraftBat;
import org.bukkit.craftbukkit.entity.CraftBlaze;
import org.bukkit.craftbukkit.entity.CraftBoat;
import org.bukkit.craftbukkit.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.entity.CraftChicken;
import org.bukkit.craftbukkit.entity.CraftComplexPart;
import org.bukkit.craftbukkit.entity.CraftCow;
import org.bukkit.craftbukkit.entity.CraftCreature;
import org.bukkit.craftbukkit.entity.CraftCreeper;
import org.bukkit.craftbukkit.entity.CraftEgg;
import org.bukkit.craftbukkit.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.entity.CraftEnderman;
import org.bukkit.craftbukkit.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.entity.CraftFallingSand;
import org.bukkit.craftbukkit.entity.CraftFireball;
import org.bukkit.craftbukkit.entity.CraftFirework;
import org.bukkit.craftbukkit.entity.CraftFish;
import org.bukkit.craftbukkit.entity.CraftFlying;
import org.bukkit.craftbukkit.entity.CraftGhast;
import org.bukkit.craftbukkit.entity.CraftGiant;
import org.bukkit.craftbukkit.entity.CraftHanging;
import org.bukkit.craftbukkit.entity.CraftHorse;
import org.bukkit.craftbukkit.entity.CraftIronGolem;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.craftbukkit.entity.CraftItemFrame;
import org.bukkit.craftbukkit.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.entity.CraftLeash;
import org.bukkit.craftbukkit.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.craftbukkit.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.entity.CraftMonster;
import org.bukkit.craftbukkit.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.entity.CraftOcelot;
import org.bukkit.craftbukkit.entity.CraftPainting;
import org.bukkit.craftbukkit.entity.CraftPig;
import org.bukkit.craftbukkit.entity.CraftPigZombie;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.entity.CraftProjectile;
import org.bukkit.craftbukkit.entity.CraftSheep;
import org.bukkit.craftbukkit.entity.CraftSilverfish;
import org.bukkit.craftbukkit.entity.CraftSkeleton;
import org.bukkit.craftbukkit.entity.CraftSlime;
import org.bukkit.craftbukkit.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.entity.CraftSnowball;
import org.bukkit.craftbukkit.entity.CraftSnowman;
import org.bukkit.craftbukkit.entity.CraftSpider;
import org.bukkit.craftbukkit.entity.CraftSquid;
import org.bukkit.craftbukkit.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.entity.CraftTameableAnimal;
import org.bukkit.craftbukkit.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.craftbukkit.entity.CraftWaterMob;
import org.bukkit.craftbukkit.entity.CraftWeather;
import org.bukkit.craftbukkit.entity.CraftWitch;
import org.bukkit.craftbukkit.entity.CraftWither;
import org.bukkit.craftbukkit.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.craftbukkit.entity.CraftZombie;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import za.co.mcportcentral.entity.CraftCustomEntity;

public abstract class CraftEntity
implements Entity {
    protected final CraftServer server;
    protected qn entity;
    private EntityDamageEvent lastDamageEvent;
    private final Entity.Spigot spigot = new Entity.Spigot(){

        @Override
        public boolean isInvulnerable() {
            return CraftEntity.this.getHandle().aw();
        }
    };

    public CraftEntity(CraftServer server, qn entity) {
        this.server = server;
        this.entity = entity;
    }

    public static CraftEntity getEntity(CraftServer server, qn entity) {
        if (entity instanceof rh) {
            if (entity instanceof xl) {
                if (entity instanceof mm) {
                    return new CraftPlayer(server, (mm)entity);
                }
                return new CraftPlayer(server, FakePlayerFactory.get(DimensionManager.getWorld(entity.p.t.i), ((xl)entity).bH()));
            }
            if (entity instanceof rp) {
                if (entity instanceof ur) {
                    if (entity instanceof us) {
                        return new CraftChicken(server, (us)entity);
                    }
                    if (entity instanceof ut) {
                        if (entity instanceof uy) {
                            return new CraftMushroomCow(server, (uy)entity);
                        }
                        return new CraftCow(server, (ut)entity);
                    }
                    if (entity instanceof va) {
                        return new CraftPig(server, (va)entity);
                    }
                    if (entity instanceof rs) {
                        if (entity instanceof vh) {
                            return new CraftWolf(server, (vh)entity);
                        }
                        if (entity instanceof uz) {
                            return new CraftOcelot(server, (uz)entity);
                        }
                        return new CraftTameableAnimal(server, (rs)entity);
                    }
                    if (entity instanceof vb) {
                        return new CraftSheep(server, (vb)entity);
                    }
                    if (entity instanceof uu) {
                        return new CraftHorse(server, (uu)entity);
                    }
                    return new CraftAnimals(server, (ur)entity);
                }
                if (entity instanceof ws) {
                    if (entity instanceof xc) {
                        if (entity instanceof wt) {
                            return new CraftPigZombie(server, (wt)entity);
                        }
                        return new CraftZombie(server, (xc)entity);
                    }
                    if (entity instanceof wl) {
                        return new CraftCreeper(server, (wl)entity);
                    }
                    if (entity instanceof wm) {
                        return new CraftEnderman(server, (wm)entity);
                    }
                    if (entity instanceof ww) {
                        return new CraftSilverfish(server, (ww)entity);
                    }
                    if (entity instanceof wq) {
                        return new CraftGiant(server, (wq)entity);
                    }
                    if (entity instanceof wx) {
                        return new CraftSkeleton(server, (wx)entity);
                    }
                    if (entity instanceof wj) {
                        return new CraftBlaze(server, (wj)entity);
                    }
                    if (entity instanceof xb) {
                        return new CraftWitch(server, (xb)entity);
                    }
                    if (entity instanceof vo) {
                        return new CraftWither(server, (vo)entity);
                    }
                    if (entity instanceof wz) {
                        if (entity instanceof wk) {
                            return new CraftCaveSpider(server, (wk)entity);
                        }
                        return new CraftSpider(server, (wz)entity);
                    }
                    return new CraftMonster(server, (ws)entity);
                }
                if (entity instanceof vg) {
                    if (entity instanceof ve) {
                        return new CraftSquid(server, (ve)entity);
                    }
                    return new CraftWaterMob(server, (vg)entity);
                }
                if (entity instanceof ux) {
                    if (entity instanceof vd) {
                        return new CraftSnowman(server, (vd)entity);
                    }
                    if (entity instanceof vf) {
                        return new CraftIronGolem(server, (vf)entity);
                    }
                    return new CraftLivingEntity(server, (rh)entity);
                }
                if (entity instanceof xh) {
                    return new CraftVillager(server, (xh)entity);
                }
                return new CraftCreature(server, (rp)entity);
            }
            if (entity instanceof wy) {
                if (entity instanceof wr) {
                    return new CraftMagmaCube(server, (wr)entity);
                }
                return new CraftSlime(server, (wy)entity);
            }
            if (entity instanceof rd) {
                if (entity instanceof wp) {
                    return new CraftGhast(server, (wp)entity);
                }
                return new CraftFlying(server, (rd)entity);
            }
            if (entity instanceof vm) {
                return new CraftEnderDragon(server, (vm)entity);
            }
            if (entity instanceof up) {
                if (entity instanceof uq) {
                    return new CraftBat(server, (uq)entity);
                }
                return new CraftAmbient(server, (up)entity);
            }
            return new CraftLivingEntity(server, (rh)entity);
        }
        if (entity instanceof vk) {
            vk part = (vk)entity;
            if (part.a instanceof vm) {
                return new CraftEnderDragonPart(server, (vk)entity);
            }
            return new CraftComplexPart(server, (vk)entity);
        }
        if (entity instanceof rc) {
            return new CraftExperienceOrb(server, (rc)entity);
        }
        if (entity instanceof xo) {
            return new CraftArrow(server, (xo)entity);
        }
        if (entity instanceof vu) {
            return new CraftBoat(server, (vu)entity);
        }
        if (entity instanceof xw) {
            if (entity instanceof xx) {
                return new CraftEgg(server, (xx)entity);
            }
            if (entity instanceof xv) {
                return new CraftSnowball(server, (xv)entity);
            }
            if (entity instanceof ya) {
                return new CraftThrownPotion(server, (ya)entity);
            }
            if (entity instanceof xy) {
                return new CraftEnderPearl(server, (xy)entity);
            }
            if (entity instanceof xz) {
                return new CraftThrownExpBottle(server, (xz)entity);
            }
            return new CraftProjectile(server, (qn)((xw)entity));
        }
        if (entity instanceof vv) {
            return new CraftFallingSand(server, (vv)entity);
        }
        if (entity instanceof xq) {
            if (entity instanceof xu) {
                return new CraftSmallFireball(server, (xu)entity);
            }
            if (entity instanceof xs) {
                return new CraftLargeFireball(server, (xs)entity);
            }
            if (entity instanceof yb) {
                return new CraftWitherSkull(server, (yb)entity);
            }
            return new CraftFireball(server, (xq)entity);
        }
        if (entity instanceof xp) {
            return new CraftEnderSignal(server, (xp)entity);
        }
        if (entity instanceof vl) {
            return new CraftEnderCrystal(server, (vl)entity);
        }
        if (entity instanceof vq) {
            return new CraftFish(server, (vq)entity);
        }
        if (entity instanceof vw) {
            return new CraftItem(server, (vw)entity);
        }
        if (entity instanceof vs) {
            if (entity instanceof vt) {
                return new CraftLightningStrike(server, (vt)entity);
            }
            return new CraftWeather(server, (vs)entity);
        }
        if (entity instanceof vx) {
            if (entity instanceof wc) {
                return new CraftMinecartFurnace(server, (wc)entity);
            }
            if (entity instanceof vy) {
                return new CraftMinecartChest(server, (vy)entity);
            }
            if (entity instanceof wh) {
                return new CraftMinecartTNT(server, (wh)entity);
            }
            if (entity instanceof wd) {
                return new CraftMinecartHopper(server, (wd)entity);
            }
            if (entity instanceof wf) {
                return new CraftMinecartMobSpawner(server, (wf)entity);
            }
            if (entity instanceof we) {
                return new CraftMinecartRideable(server, (vx)((we)entity));
            }
            if (entity instanceof vz) {
                return new CraftMinecartCommand(server, (vz)entity);
            }
            return new CraftMinecart(server, (vx)entity);
        }
        if (entity instanceof re) {
            if (entity instanceof rn) {
                return new CraftPainting(server, (rn)entity);
            }
            if (entity instanceof rf) {
                return new CraftItemFrame(server, (rf)entity);
            }
            if (entity instanceof rg) {
                return new CraftLeash(server, (rg)entity);
            }
            return new CraftHanging(server, (re)entity);
        }
        if (entity instanceof wi) {
            return new CraftTNTPrimed(server, (wi)entity);
        }
        if (entity instanceof xr) {
            return new CraftFirework(server, (xr)entity);
        }
        if (entity instanceof qn) {
            return new CraftCustomEntity(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + entity == null ? null : entity.getClass() + ": " + entity));
    }

    public static Class<? extends Entity> getEntityClass(Class<? extends qn> nmsClass) {
        if (rh.class.isAssignableFrom(nmsClass)) {
            if (xl.class.isAssignableFrom(nmsClass)) {
                if (mm.class.isAssignableFrom(nmsClass)) {
                    return CraftPlayer.class;
                }
                return CraftPlayer.class;
            }
            if (rp.class.isAssignableFrom(nmsClass)) {
                if (ur.class.isAssignableFrom(nmsClass)) {
                    if (us.class.isAssignableFrom(nmsClass)) {
                        return CraftChicken.class;
                    }
                    if (ut.class.isAssignableFrom(nmsClass)) {
                        if (uy.class.isAssignableFrom(nmsClass)) {
                            return CraftMushroomCow.class;
                        }
                        return CraftCow.class;
                    }
                    if (va.class.isAssignableFrom(nmsClass)) {
                        return CraftPig.class;
                    }
                    if (rs.class.isAssignableFrom(nmsClass)) {
                        if (vh.class.isAssignableFrom(nmsClass)) {
                            return CraftWolf.class;
                        }
                        if (uz.class.isAssignableFrom(nmsClass)) {
                            return CraftOcelot.class;
                        }
                        return CraftTameableAnimal.class;
                    }
                    if (vb.class.isAssignableFrom(nmsClass)) {
                        return CraftSheep.class;
                    }
                    if (uu.class.isAssignableFrom(nmsClass)) {
                        return CraftHorse.class;
                    }
                    return CraftAnimals.class;
                }
                if (ws.class.isAssignableFrom(nmsClass)) {
                    if (xc.class.isAssignableFrom(nmsClass)) {
                        if (wt.class.isAssignableFrom(nmsClass)) {
                            return CraftPigZombie.class;
                        }
                        return CraftZombie.class;
                    }
                    if (wl.class.isAssignableFrom(nmsClass)) {
                        return CraftCreeper.class;
                    }
                    if (wm.class.isAssignableFrom(nmsClass)) {
                        return CraftEnderman.class;
                    }
                    if (ww.class.isAssignableFrom(nmsClass)) {
                        return CraftSilverfish.class;
                    }
                    if (wq.class.isAssignableFrom(nmsClass)) {
                        return CraftGiant.class;
                    }
                    if (wx.class.isAssignableFrom(nmsClass)) {
                        return CraftSkeleton.class;
                    }
                    if (wj.class.isAssignableFrom(nmsClass)) {
                        return CraftBlaze.class;
                    }
                    if (xb.class.isAssignableFrom(nmsClass)) {
                        return CraftWitch.class;
                    }
                    if (vo.class.isAssignableFrom(nmsClass)) {
                        return CraftWither.class;
                    }
                    if (wz.class.isAssignableFrom(nmsClass)) {
                        if (wk.class.isAssignableFrom(nmsClass)) {
                            return CraftCaveSpider.class;
                        }
                        return CraftSpider.class;
                    }
                    return CraftMonster.class;
                }
                if (vg.class.isAssignableFrom(nmsClass)) {
                    if (ve.class.isAssignableFrom(nmsClass)) {
                        return CraftSquid.class;
                    }
                    return CraftWaterMob.class;
                }
                if (ux.class.isAssignableFrom(nmsClass)) {
                    if (vd.class.isAssignableFrom(nmsClass)) {
                        return CraftSnowman.class;
                    }
                    if (vf.class.isAssignableFrom(nmsClass)) {
                        return CraftIronGolem.class;
                    }
                    return CraftLivingEntity.class;
                }
                if (xh.class.isAssignableFrom(nmsClass)) {
                    return CraftVillager.class;
                }
                return CraftCreature.class;
            }
            if (wy.class.isAssignableFrom(nmsClass)) {
                if (wr.class.isAssignableFrom(nmsClass)) {
                    return CraftMagmaCube.class;
                }
                return CraftSlime.class;
            }
            if (rd.class.isAssignableFrom(nmsClass)) {
                if (wp.class.isAssignableFrom(nmsClass)) {
                    return CraftGhast.class;
                }
                return CraftFlying.class;
            }
            if (vm.class.isAssignableFrom(nmsClass)) {
                return CraftEnderDragon.class;
            }
            if (up.class.isAssignableFrom(nmsClass)) {
                if (uq.class.isAssignableFrom(nmsClass)) {
                    return CraftBat.class;
                }
                return CraftAmbient.class;
            }
            return CraftLivingEntity.class;
        }
        if (vk.class.isAssignableFrom(nmsClass)) {
            return CraftComplexPart.class;
        }
        if (rc.class.isAssignableFrom(nmsClass)) {
            return CraftExperienceOrb.class;
        }
        if (xo.class.isAssignableFrom(nmsClass)) {
            return CraftArrow.class;
        }
        if (vu.class.isAssignableFrom(nmsClass)) {
            return CraftBoat.class;
        }
        if (xw.class.isAssignableFrom(nmsClass)) {
            if (xx.class.isAssignableFrom(nmsClass)) {
                return CraftEgg.class;
            }
            if (xv.class.isAssignableFrom(nmsClass)) {
                return CraftSnowball.class;
            }
            if (ya.class.isAssignableFrom(nmsClass)) {
                return CraftThrownPotion.class;
            }
            if (xy.class.isAssignableFrom(nmsClass)) {
                return CraftEnderPearl.class;
            }
            if (xz.class.isAssignableFrom(nmsClass)) {
                return CraftThrownExpBottle.class;
            }
            return CraftProjectile.class;
        }
        if (vv.class.isAssignableFrom(nmsClass)) {
            return CraftFallingSand.class;
        }
        if (xq.class.isAssignableFrom(nmsClass)) {
            if (xu.class.isAssignableFrom(nmsClass)) {
                return CraftSmallFireball.class;
            }
            if (xs.class.isAssignableFrom(nmsClass)) {
                return CraftLargeFireball.class;
            }
            if (yb.class.isAssignableFrom(nmsClass)) {
                return CraftWitherSkull.class;
            }
            return CraftFireball.class;
        }
        if (xp.class.isAssignableFrom(nmsClass)) {
            return CraftEnderSignal.class;
        }
        if (vl.class.isAssignableFrom(nmsClass)) {
            return CraftEnderCrystal.class;
        }
        if (vq.class.isAssignableFrom(nmsClass)) {
            return CraftFish.class;
        }
        if (vw.class.isAssignableFrom(nmsClass)) {
            return CraftItem.class;
        }
        if (vs.class.isAssignableFrom(nmsClass)) {
            if (vt.class.isAssignableFrom(nmsClass)) {
                return CraftLightningStrike.class;
            }
            return CraftWeather.class;
        }
        if (vx.class.isAssignableFrom(nmsClass)) {
            if (wc.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartFurnace.class;
            }
            if (vy.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartChest.class;
            }
            if (wh.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartTNT.class;
            }
            if (wd.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartHopper.class;
            }
            if (wf.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartMobSpawner.class;
            }
            if (we.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartRideable.class;
            }
            if (vz.class.isAssignableFrom(nmsClass)) {
                return CraftMinecartCommand.class;
            }
            return CraftMinecart.class;
        }
        if (re.class.isAssignableFrom(nmsClass)) {
            if (rn.class.isAssignableFrom(nmsClass)) {
                return CraftPainting.class;
            }
            if (rf.class.isAssignableFrom(nmsClass)) {
                return CraftItemFrame.class;
            }
            if (rg.class.isAssignableFrom(nmsClass)) {
                return CraftLeash.class;
            }
            return CraftHanging.class;
        }
        if (wi.class.isAssignableFrom(nmsClass)) {
            return CraftTNTPrimed.class;
        }
        if (xr.class.isAssignableFrom(nmsClass)) {
            return CraftFirework.class;
        }
        if (qn.class.isAssignableFrom(nmsClass)) {
            return CraftCustomEntity.class;
        }
        throw new AssertionError("Unknown entity class " + nmsClass == null ? null : nmsClass);
    }

    public static void initMappings() {
        for (Map.Entry<Class<? extends qn>, String> entry : EntityRegistry.entityTypeMap.entrySet()) {
            Class<? extends qn> entityClass = entry.getKey();
            String entityName = entry.getValue();
            int entityId = CraftEntity.getEntityTypeIDfromClass(entityClass);
            Class<? extends Entity> bukkitEntityClass = CraftEntity.getEntityClass(entityClass);
            EnumHelper.addBukkitEntityType(entityName, bukkitEntityClass, entityId, false);
        }
    }

    private static int getEntityTypeIDfromClass(Class entityClass) {
        Map classToIDMapping = (Map)ReflectionHelper.getPrivateValue(qt.class, null, "field_75624_e", "classToIDMapping");
        if (classToIDMapping.containsKey(entityClass)) {
            return (Integer)classToIDMapping.get(entityClass);
        }
        Map IDtoClassMapping = (Map)ReflectionHelper.getPrivateValue(qt.class, null, "field_75623_d", "IDtoClassMapping");
        for (Map.Entry entry : IDtoClassMapping.entrySet()) {
            int entityId = (Integer)entry.getKey();
            Class thisEntityClass = (Class)entry.getValue();
            if (!thisEntityClass.getName().equals(entityClass.getName())) continue;
            return entityId;
        }
        return -Math.abs(entityClass.getName().hashCode() ^ entityClass.getName().hashCode() >>> 16);
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.t, this.entity.u, this.entity.v, this.entity.z, this.entity.A);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.t);
            loc.setY(this.entity.u);
            loc.setZ(this.entity.v);
            loc.setYaw(this.entity.z);
            loc.setPitch(this.entity.A);
        }
        return loc;
    }

    @Override
    public Vector getVelocity() {
        return new Vector(this.entity.w, this.entity.x, this.entity.y);
    }

    @Override
    public void setVelocity(Vector vel) {
        this.entity.w = vel.getX();
        this.entity.x = vel.getY();
        this.entity.y = vel.getZ();
        this.entity.I = true;
    }

    @Override
    public boolean isOnGround() {
        if (this.entity instanceof xo) {
            return ((xo)this.entity).isInGround();
        }
        return this.entity.E;
    }

    @Override
    public World getWorld() {
        if (this.entity.p.getWorld() == null) {
            return DimensionManager.getWorld(0).getWorld();
        }
        return this.entity.p.getWorld();
    }

    @Override
    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.entity.n != null || this.entity.m != null || this.entity.L) {
            return false;
        }
        this.entity.p = ((CraftWorld)location.getWorld()).getHandle();
        this.entity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        return true;
    }

    @Override
    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    @Override
    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    @Override
    public List<Entity> getNearbyEntities(double x, double y2, double z2) {
        List notchEntityList = this.entity.p.b(this.entity, this.entity.D.b(x, y2, z2));
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (qn e : notchEntityList) {
            bukkitEntityList.add(e.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    @Override
    public int getEntityId() {
        return this.entity.y();
    }

    @Override
    public int getFireTicks() {
        return this.entity.e;
    }

    @Override
    public int getMaxFireTicks() {
        return this.entity.ac;
    }

    @Override
    public void setFireTicks(int ticks) {
        this.entity.e = ticks;
    }

    @Override
    public void remove() {
        this.entity.L = true;
    }

    @Override
    public boolean isDead() {
        return !this.entity.Z();
    }

    @Override
    public boolean isValid() {
        return this.entity.Z() && this.entity.valid;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    @Override
    public Entity getPassenger() {
        return this.isEmpty() ? null : this.getHandle().m.getBukkitEntity();
    }

    @Override
    public boolean setPassenger(Entity passenger) {
        if (passenger instanceof CraftEntity) {
            ((CraftEntity)passenger).getHandle().setPassengerOf(this.getHandle());
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getHandle().m == null;
    }

    @Override
    public boolean eject() {
        if (this.getHandle().m == null) {
            return false;
        }
        this.getHandle().m.setPassengerOf(null);
        return true;
    }

    @Override
    public float getFallDistance() {
        return this.getHandle().S;
    }

    @Override
    public void setFallDistance(float distance) {
        this.getHandle().S = distance;
    }

    @Override
    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    @Override
    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    @Override
    public UUID getUniqueId() {
        return this.getHandle().as;
    }

    @Override
    public int getTicksLived() {
        return this.getHandle().ab;
    }

    @Override
    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().ab = value;
    }

    public qn getHandle() {
        return this.entity;
    }

    @Override
    public void playEffect(EntityEffect type) {
        this.getHandle().p.a(this.getHandle(), type.getData());
    }

    public void setHandle(qn entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isInsideVehicle() {
        return this.getHandle().n != null;
    }

    @Override
    public boolean leaveVehicle() {
        if (this.getHandle().n == null) {
            return false;
        }
        this.getHandle().setPassengerOf(null);
        return true;
    }

    @Override
    public Entity getVehicle() {
        if (this.getHandle().n == null) {
            return null;
        }
        return this.getHandle().n.getBukkitEntity();
    }

    @Override
    public Entity.Spigot spigot() {
        return this.spigot;
    }
}

