/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.SkullMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("SkullOwner", "skull-owner");
    static final int MAX_OWNER_LENGTH = 16;
    private String player;

    CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.player = skullMeta.player;
    }

    CraftMetaSkull(dg tag) {
        super(tag);
        if (tag.c(CraftMetaSkull.SKULL_OWNER.NBT)) {
            this.player = tag.j(CraftMetaSkull.SKULL_OWNER.NBT);
        }
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        this.setOwner(CraftMetaItem.SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
    }

    @Override
    void applyToItem(dg tag) {
        super.applyToItem(tag);
        if (this.hasOwner()) {
            tag.a(CraftMetaSkull.SKULL_OWNER.NBT, this.player);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return !this.hasOwner();
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case SKULL_ITEM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    @Override
    public boolean hasOwner() {
        return !Strings.isNullOrEmpty((String)this.player);
    }

    @Override
    public String getOwner() {
        return this.player;
    }

    @Override
    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        this.player = name;
        return true;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.player.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            return this.hasOwner() ? that.hasOwner() && this.player.equals(that.player) : !that.hasOwner();
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasOwner()) {
            return builder.put((Object)CraftMetaSkull.SKULL_OWNER.BUKKIT, (Object)this.player);
        }
        return builder;
    }
}

