/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.util.WeakCollection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, ayr scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        if (Thread.currentThread() != MinecraftServer.G().primaryThread) {
            throw new IllegalStateException("Asynchronous scoreboard creation");
        }
        CraftScoreboard scoreboard = new CraftScoreboard((ayr)new lf(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue((boolean)(bukkitScoreboard instanceof CraftScoreboard), (String)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        ayr oldboard = this.getPlayerBoard(player).getHandle();
        ayr newboard = scoreboard.getHandle();
        mm entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<aym> removed = new HashSet<aym>();
        for (int i = 0; i < 3; ++i) {
            aym scoreboardobjective = oldboard.a(i);
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.a.a((fk)new hq(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (ayn scoreboardteam : oldboard.g()) {
            entityplayer.a.a((fk)new hr(scoreboardteam, 1));
        }
        this.server.af().a((lf)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public Collection<ayo> getScoreboardScores(ayw criteria, String name, Collection<ayo> collection) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            ayr board = scoreboard.board;
            for (aym objective : board.a(criteria)) {
                collection.add(board.a(name, objective));
            }
        }
        return collection;
    }

    public void updateAllScoresForList(ayw criteria, String name, List<mm> of) {
        for (ayo score : this.getScoreboardScores(criteria, name, new ArrayList<ayo>())) {
            score.a(of);
        }
    }
}

