/*
 * Decompiled with CFR 0.152.
 */
package za.co.mcportcentral;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import za.co.mcportcentral.MCPCConfig;

public class MCPCWorldConfig {
    private final String worldName;
    private final YamlConfiguration config;
    private boolean verbose;

    public MCPCWorldConfig(String worldName) {
        this.worldName = worldName.toLowerCase();
        this.config = MCPCConfig.config;
        if (worldName.toLowerCase().contains("dummy")) {
            return;
        }
        try {
            this.init();
        }
        catch (Throwable t) {
            this.log("Something bad happened while trying init the mcpc config for [" + worldName + "]");
            t.printStackTrace();
        }
    }

    public void init() {
        MCPCConfig.readConfig(MCPCWorldConfig.class, this);
    }

    public void save() {
        MCPCConfig.save();
    }

    private void log(String s) {
        if (this.verbose) {
            Bukkit.getLogger().info(s);
        }
    }

    public void set(String path, Object val) {
        this.config.set(path, val);
    }

    public boolean isBoolean(String path) {
        return this.config.isBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getBoolean("world-settings." + this.worldName + "." + path, this.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getDouble("world-settings." + this.worldName + "." + path, this.config.getDouble("world-settings.default." + path));
    }

    private int getInt(String path, int def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getInt("world-settings." + this.worldName + "." + path, this.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getList("world-settings." + this.worldName + "." + path, this.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.config.addDefault("world-settings.default." + path, def);
        return this.config.getString("world-settings." + this.worldName + "." + path, this.config.getString("world-settings.default." + path));
    }
}

