/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebeaninternal.server.cache.DefaultCacheHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerCacheManager
implements ServerCacheManager {
    private final DefaultCacheHolder beanCache;
    private final DefaultCacheHolder queryCache;
    private final ServerCacheFactory cacheFactory;

    public DefaultServerCacheManager(ServerCacheFactory cacheFactory, ServerCacheOptions defaultBeanOptions, ServerCacheOptions defaultQueryOptions) {
        this.cacheFactory = cacheFactory;
        this.beanCache = new DefaultCacheHolder(cacheFactory, defaultBeanOptions, true);
        this.queryCache = new DefaultCacheHolder(cacheFactory, defaultQueryOptions, false);
    }

    @Override
    public void init(EbeanServer server) {
        this.cacheFactory.init(server);
    }

    @Override
    public void clear(Class<?> beanType) {
        if (this.isBeanCaching(beanType)) {
            this.getBeanCache(beanType).clear();
        }
        if (this.isQueryCaching(beanType)) {
            this.getQueryCache(beanType).clear();
        }
    }

    @Override
    public void clearAll() {
        this.beanCache.clearAll();
        this.queryCache.clearAll();
    }

    @Override
    public ServerCache getQueryCache(Class<?> beanType) {
        return this.queryCache.getCache(beanType);
    }

    @Override
    public ServerCache getBeanCache(Class<?> beanType) {
        return this.beanCache.getCache(beanType);
    }

    @Override
    public boolean isBeanCaching(Class<?> beanType) {
        return this.beanCache.isCaching(beanType);
    }

    public boolean isQueryCaching(Class<?> beanType) {
        return this.queryCache.isCaching(beanType);
    }
}

