/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.ByteHashFactory;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.AbstractHashFactory;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

abstract class ByteHashFactorySO
extends AbstractHashFactory {
    final byte lower;
    final byte upper;
    final boolean randomFree;
    final boolean randomRemoved;
    final byte freeValue;
    final byte removedValue;

    ByteHashFactorySO(HashConfig hashConf, int defaultExpectedSize, byte lower, byte upper) {
        super(hashConf, defaultExpectedSize);
        this.lower = lower;
        this.upper = upper;
        if ((byte)(lower - 1) == upper) {
            this.randomFree = false;
            this.randomRemoved = true;
            this.removedValue = 0;
            this.freeValue = 0;
        } else {
            this.randomFree = false;
            this.freeValue = lower < upper && (lower > 0 || upper < 0) || upper < lower && lower > 0 && upper < 0 ? (byte)0 : (byte)(lower - 1);
            if ((byte)(lower - 2) == upper) {
                this.randomRemoved = true;
                this.removedValue = 0;
            } else {
                this.randomRemoved = false;
                this.removedValue = upper + 1 != 0 ? (byte)(upper + 1) : (byte)(upper + 2);
            }
        }
    }

    public final byte getLowerKeyDomainBound() {
        return this.lower;
    }

    public final byte getUpperKeyDomainBound() {
        return this.upper;
    }

    byte getFree() {
        if (this.randomFree) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return (byte)((Random)random).nextInt();
        }
        return this.freeValue;
    }

    String keySpecialString() {
        return ",lowerKeyDomainBound=" + ByteHashFactorySO.boundAsString(this.getLowerKeyDomainBound()) + ",upperKeyDomainBound=" + ByteHashFactorySO.boundAsString(this.getUpperKeyDomainBound());
    }

    private static String boundAsString(byte bound) {
        return "" + bound;
    }

    int keySpecialHashCode(int hashCode) {
        hashCode = hashCode * 31 + Primitives.hashCode((byte)this.getLowerKeyDomainBound());
        return hashCode * 31 + Primitives.hashCode((byte)this.getUpperKeyDomainBound());
    }

    boolean keySpecialEquals(ByteHashFactory other) {
        return this.getLowerKeyDomainBound() == other.getLowerKeyDomainBound() && this.getUpperKeyDomainBound() == other.getUpperKeyDomainBound();
    }
}

