/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.hash.ImmutableParallelKVFloatLHashSO;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.hash.HashFloatSet;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public abstract class ImmutableParallelKVFloatLHashGO
extends ImmutableParallelKVFloatLHashSO {
    @Override
    @Nonnull
    public long[] table() {
        return this.table;
    }

    public int capacity() {
        return this.table.length;
    }

    public void forEach(Consumer<? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)));
        }
    }

    public void forEach(FloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key));
        }
    }

    public boolean forEachWhile(FloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key))) continue;
            terminated = true;
            break;
        }
        return !terminated;
    }

    public boolean allContainingIn(FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.allContainingIn((InternalFloatCollectionOps)c);
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(Float.intBitsToFloat(key))) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    boolean allContainingIn(InternalFloatCollectionOps c) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE || c.contains(key)) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    public boolean reverseAddAllTo(FloatCollection c) {
        if (c instanceof InternalFloatCollectionOps) {
            return this.reverseAddAllTo((InternalFloatCollectionOps)c);
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= c.add(Float.intBitsToFloat(key));
        }
        return changed;
    }

    boolean reverseAddAllTo(InternalFloatCollectionOps c) {
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= c.add(key);
        }
        return changed;
    }

    public boolean reverseRemoveAllFrom(FloatSet s) {
        if (s instanceof InternalFloatCollectionOps) {
            return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
        }
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= s.removeFloat(Float.intBitsToFloat(key));
        }
        return changed;
    }

    boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
        if (this.isEmpty() || s.isEmpty()) {
            return false;
        }
        boolean changed = false;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            changed |= s.removeFloat(key);
        }
        return changed;
    }

    public FloatIterator iterator() {
        return new NoRemovedIterator();
    }

    public FloatCursor setCursor() {
        return new NoRemovedCursor();
    }

    @Nonnull
    public Object[] toArray() {
        int size = this.size();
        Object[] result = new Object[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(key));
        }
        return result;
    }

    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> elementType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(elementType, size);
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }
        int resultIndex = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(key));
        }
        if (a.length > resultIndex) {
            a[resultIndex] = null;
        }
        return a;
    }

    @Nonnull
    public float[] toFloatArray() {
        int size = this.size();
        float[] result = new float[size];
        if (size == 0) {
            return result;
        }
        int resultIndex = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            result[resultIndex++] = Float.intBitsToFloat(key);
        }
        return result;
    }

    @Nonnull
    public float[] toArray(float[] a) {
        int size = this.size();
        if (a.length < size) {
            a = new float[size];
        }
        if (size == 0) {
            if (a.length > 0) {
                a[0] = 0.0f;
            }
            return a;
        }
        int resultIndex = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            a[resultIndex++] = Float.intBitsToFloat(key);
        }
        if (a.length > resultIndex) {
            a[resultIndex] = 0.0f;
        }
        return a;
    }

    public int setHashCode() {
        int hashCode = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key;
        }
        return hashCode;
    }

    public String setToString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        long[] tab = this.table;
        long base = LONG_BASE + FLOAT_KEY_OFFSET;
        long off = (long)tab.length << 3;
        while ((off -= 8L) >= 0L) {
            int key = U.getInt(tab, base + off);
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ').append(Float.intBitsToFloat(key)).append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        sb.setCharAt(0, '[');
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    abstract boolean justRemove(int var1);

    public boolean removeIf(Predicate<? super Float> filter) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatPredicate filter) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        throw new UnsupportedOperationException();
    }

    boolean removeAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull Collection<?> c) {
        if (c instanceof FloatCollection) {
            return this.retainAll(thisC, (FloatCollection)c);
        }
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull FloatCollection c) {
        throw new UnsupportedOperationException();
    }

    private boolean retainAll(@Nonnull HashFloatSet thisC, @Nonnull InternalFloatCollectionOps c) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedCursor
    implements FloatCursor {
        final long[] tab;
        int index;
        int curKey;

        NoRemovedCursor() {
            this.tab = ImmutableParallelKVFloatLHashGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (index != this.index) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            long[] tab = this.tab;
            for (int i = this.index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.index = i;
                this.curKey = key;
                return true;
            }
            this.curKey = 0x7FFFFFFE;
            this.index = -1;
            return false;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedIterator
    implements FloatIterator {
        final long[] tab;
        int nextIndex;
        float next;

        NoRemovedIterator() {
            this.tab = ImmutableParallelKVFloatLHashGO.this.table;
            long[] tab = ImmutableParallelKVFloatLHashGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = Float.intBitsToFloat(key);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            int nextI = this.nextIndex;
            if (nextI >= 0) {
                long[] tab = this.tab;
                float prev = this.next;
                while (--nextI >= 0) {
                    long entry = tab[nextI];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.next = Float.intBitsToFloat(key);
                    break;
                }
                this.nextIndex = nextI;
                return prev;
            }
            throw new NoSuchElementException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(key)));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key));
            }
            if (nextI != this.nextIndex) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

