/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.hash.HashContainerFactory;
import com.koloboke.collect.impl.Containers;
import com.koloboke.collect.impl.hash.ImmutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.LHashCapacities;
import com.koloboke.collect.impl.hash.LHashObjSetFactorySO;
import com.koloboke.collect.impl.hash.MutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.SeparateKVObjLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashObjSetGO;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.collect.set.hash.HashObjSetFactory;
import com.koloboke.function.Consumer;
import com.koloboke.function.Predicate;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;

public abstract class LHashObjSetFactoryGO<E>
extends LHashObjSetFactorySO<E> {
    public LHashObjSetFactoryGO(HashConfig hashConf, int defaultExpectedSize, boolean isNullAllowed) {
        super(hashConf, defaultExpectedSize, isNullAllowed);
    }

    abstract HashObjSetFactory<E> thisWith(HashConfig var1, int var2, boolean var3);

    abstract HashObjSetFactory<E> lHashLikeThisWith(HashConfig var1, int var2, boolean var3);

    abstract HashObjSetFactory<E> qHashLikeThisWith(HashConfig var1, int var2, boolean var3);

    public final HashObjSetFactory<E> withHashConfig(@Nonnull HashConfig hashConf) {
        if (LHashCapacities.configIsSuitableForMutableLHash((HashConfig)hashConf)) {
            return this.lHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.isNullKeyAllowed());
        }
        return this.qHashLikeThisWith(hashConf, this.getDefaultExpectedSize(), this.isNullKeyAllowed());
    }

    public final HashObjSetFactory<E> withDefaultExpectedSize(int defaultExpectedSize) {
        if (defaultExpectedSize == this.getDefaultExpectedSize()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), defaultExpectedSize, this.isNullKeyAllowed());
    }

    public String toString() {
        return "HashObjSetFactory[" + this.commonString() + this.keySpecialString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashObjSetFactory) {
            HashObjSetFactory factory = (HashObjSetFactory)obj;
            return this.commonEquals((HashContainerFactory<?>)factory) && this.keySpecialEquals(factory);
        }
        return false;
    }

    public int hashCode() {
        return this.keySpecialHashCode(this.commonHashCode());
    }

    private <E2 extends E> UpdatableLHashObjSetGO<E2> shrunk(UpdatableLHashObjSetGO<E2> set) {
        Predicate shrinkCondition = this.hashConf.getShrinkCondition();
        if (shrinkCondition != null && shrinkCondition.test(set)) {
            set.shrink();
        }
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet() {
        return this.newUpdatableSet(this.getDefaultExpectedSize());
    }

    @Nonnull
    public <E2 extends E> MutableLHashObjSetGO<E2> newMutableSet() {
        return this.newMutableSet(this.getDefaultExpectedSize());
    }

    private static int sizeOr(Iterable elems, int defaultSize) {
        return elems instanceof Collection ? ((Collection)elems).size() : defaultSize;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elements) {
        return this.newUpdatableSet((Iterable)elements, LHashObjSetFactoryGO.sizeOr(elements, this.getDefaultExpectedSize()));
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2) {
        long expectedSize = LHashObjSetFactoryGO.sizeOr(elems1, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, Containers.sizeAsInt((long)(expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems2, 0))));
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3) {
        long expectedSize = LHashObjSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems2, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, Containers.sizeAsInt((long)(expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems3, 0))));
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4) {
        long expectedSize = LHashObjSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems3, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, Containers.sizeAsInt((long)(expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems4, 0))));
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5) {
        long expectedSize = LHashObjSetFactoryGO.sizeOr(elems1, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems2, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems3, 0);
        expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems4, 0);
        return this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, Containers.sizeAsInt((long)(expectedSize += (long)LHashObjSetFactoryGO.sizeOr(elems5, 0))));
    }

    @Override
    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elements, int expectedSize) {
        return this.shrunk((UpdatableLHashObjSetGO<E2>)super.newUpdatableSet((Iterable)elements, expectedSize));
    }

    private static <E> void addAll(UpdatableLHashObjSetGO<E> set, Iterable<? extends E> elems) {
        if (elems instanceof Collection) {
            set.addAll((Collection)elems);
        } else {
            for (E e : elems) {
                set.add(e);
            }
        }
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        LHashObjSetFactoryGO.addAll(set, elems1);
        LHashObjSetFactoryGO.addAll(set, elems2);
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        LHashObjSetFactoryGO.addAll(set, elems1);
        LHashObjSetFactoryGO.addAll(set, elems2);
        LHashObjSetFactoryGO.addAll(set, elems3);
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        LHashObjSetFactoryGO.addAll(set, elems1);
        LHashObjSetFactoryGO.addAll(set, elems2);
        LHashObjSetFactoryGO.addAll(set, elems3);
        LHashObjSetFactoryGO.addAll(set, elems4);
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        LHashObjSetFactoryGO.addAll(set, elems1);
        LHashObjSetFactoryGO.addAll(set, elems2);
        LHashObjSetFactoryGO.addAll(set, elems3);
        LHashObjSetFactoryGO.addAll(set, elems4);
        LHashObjSetFactoryGO.addAll(set, elems5);
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterator<? extends E2> elements) {
        return this.newUpdatableSet((Iterator)elements, this.getDefaultExpectedSize());
    }

    @Override
    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(Iterator<? extends E2> elements, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        while (elements.hasNext()) {
            set.add(elements.next());
        }
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier) {
        return this.newUpdatableSet((java.util.function.Consumer)elementsSupplier, this.getDefaultExpectedSize());
    }

    @Override
    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        elementsSupplier.accept(new Consumer<E2>((UpdatableLHashObjSetGO)set){
            final /* synthetic */ UpdatableLHashObjSetGO val$set;
            {
                this.val$set = updatableLHashObjSetGO;
            }

            public void accept(E2 e) {
                this.val$set.add(e);
            }
        });
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(E2[] elements) {
        return this.newUpdatableSet((Object[])elements, elements.length);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSet(E2[] elements, int expectedSize) {
        HashObjSet set = this.newUpdatableSet(expectedSize);
        for (E2 e : elements) {
            set.add(e);
        }
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSetOf(E2 e1) {
        HashObjSet set = this.newUpdatableSet(1);
        set.add(e1);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSetOf(E2 e1, E2 e2) {
        HashObjSet set = this.newUpdatableSet(2);
        set.add(e1);
        set.add(e2);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSetOf(E2 e1, E2 e2, E2 e3) {
        HashObjSet set = this.newUpdatableSet(3);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSetOf(E2 e1, E2 e2, E2 e3, E2 e4) {
        HashObjSet set = this.newUpdatableSet(4);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        return set;
    }

    @Nonnull
    public <E2 extends E> UpdatableLHashObjSetGO<E2> newUpdatableSetOf(E2 e1, E2 e2, E2 e3, E2 e4, E2 e5, E2 ... restElements) {
        HashObjSet set = this.newUpdatableSet(5 + restElements.length);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        set.add(e4);
        set.add(e5);
        for (E2 e : restElements) {
            set.add(e);
        }
        return this.shrunk((UpdatableLHashObjSetGO<E2>)set);
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elements, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elements) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterator<? extends E2> elements) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(Iterator<? extends E2> elements, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((java.util.function.Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((java.util.function.Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(E2[] elements) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Object[])elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSet(E2[] elements, int expectedSize) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Object[])elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2, E2 e3) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2, E2 e3, E2 e4) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3, (Object)e4));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newMutableSetOf(E2 e1, E2 e2, E2 e3, E2 e4, E2 e5, E2 ... restElements) {
        MutableLHashObjSetGO set = this.uninitializedMutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3, (Object)e4, (Object)e5, (Object[])restElements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elements, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elements) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterable<? extends E2> elems1, Iterable<? extends E2> elems2, Iterable<? extends E2> elems3, Iterable<? extends E2> elems4, Iterable<? extends E2> elems5) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterable)elems1, (Iterable)elems2, (Iterable)elems3, (Iterable)elems4, (Iterable)elems5));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterator<? extends E2> elements) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterator)elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(Iterator<? extends E2> elements, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Iterator)elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((java.util.function.Consumer)elementsSupplier));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(java.util.function.Consumer<Consumer<E2>> elementsSupplier, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((java.util.function.Consumer)elementsSupplier, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(E2[] elements) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Object[])elements));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSet(E2[] elements, int expectedSize) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSet((Object[])elements, expectedSize));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2, E2 e3) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2, E2 e3, E2 e4) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3, (Object)e4));
        return set;
    }

    @Nonnull
    public <E2 extends E> HashObjSet<E2> newImmutableSetOf(E2 e1, E2 e2, E2 e3, E2 e4, E2 e5, E2 ... restElements) {
        ImmutableLHashObjSetGO set = this.uninitializedImmutableSet();
        set.move((SeparateKVObjLHash)this.newUpdatableSetOf((Object)e1, (Object)e2, (Object)e3, (Object)e4, (Object)e5, (Object[])restElements));
        return set;
    }
}

