/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableLHashObjSet;
import com.koloboke.collect.impl.hash.ImmutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.LHashObjSetFactoryGO;
import com.koloboke.collect.impl.hash.MutableLHashObjSet;
import com.koloboke.collect.impl.hash.MutableLHashObjSetGO;
import com.koloboke.collect.impl.hash.QHashObjSetFactoryImpl;
import com.koloboke.collect.impl.hash.UpdatableLHashObjSet;
import com.koloboke.collect.impl.hash.UpdatableLHashObjSetGO;
import com.koloboke.collect.set.hash.HashObjSetFactory;
import javax.annotation.Nonnull;

public final class LHashObjSetFactoryImpl<E>
extends LHashObjSetFactoryGO<E> {
    public LHashObjSetFactoryImpl() {
        this(HashConfig.getDefault(), 10, false);
    }

    public LHashObjSetFactoryImpl(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        super(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Nonnull
    public HashObjSetFactory<E> withEquivalence(@Nonnull Equivalence<? super E> equivalence) {
        if (equivalence.equals((Object)Equivalence.defaultEquality())) {
            return this;
        }
        return new WithCustomEquivalence<E>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
    }

    @Nonnull
    public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
        if (nullAllowed == this.isNullKeyAllowed()) {
            return this;
        }
        return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
    }

    @Override
    HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new QHashObjSetFactoryImpl(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    @Override
    HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
        return new LHashObjSetFactoryImpl<E>(hashConf, defaultExpectedSize, isNullKeyAllowed);
    }

    static final class WithCustomEquivalence<E>
    extends LHashObjSetFactoryGO<E> {
        final Equivalence<E> equivalence;

        public WithCustomEquivalence(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed, Equivalence<E> equivalence) {
            super(hashConf, defaultExpectedSize, isNullKeyAllowed);
            this.equivalence = equivalence;
        }

        @Override
        @Nonnull
        public Equivalence<E> getEquivalence() {
            return this.equivalence;
        }

        @Override
        <E2 extends E> MutableLHashObjSetGO<E2> uninitializedMutableSet() {
            MutableLHashObjSet.WithCustomEquivalence set = new MutableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> UpdatableLHashObjSetGO<E2> uninitializedUpdatableSet() {
            UpdatableLHashObjSet.WithCustomEquivalence set = new UpdatableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Override
        <E2 extends E> ImmutableLHashObjSetGO<E2> uninitializedImmutableSet() {
            ImmutableLHashObjSet.WithCustomEquivalence set = new ImmutableLHashObjSet.WithCustomEquivalence();
            set.equivalence = this.equivalence;
            return set;
        }

        @Nonnull
        public HashObjSetFactory<E> withEquivalence(@Nonnull Equivalence<? super E> equivalence) {
            if (equivalence.equals((Object)Equivalence.defaultEquality())) {
                return new LHashObjSetFactoryImpl(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed());
            }
            if (this.equivalence.equals(equivalence)) {
                return this;
            }
            return new WithCustomEquivalence<E>(this.getHashConfig(), this.getDefaultExpectedSize(), this.isNullKeyAllowed(), equivalence);
        }

        @Nonnull
        public HashObjSetFactory<E> withNullKeyAllowed(boolean nullAllowed) {
            if (nullAllowed == this.isNullKeyAllowed()) {
                return this;
            }
            return this.thisWith(this.getHashConfig(), this.getDefaultExpectedSize(), nullAllowed);
        }

        @Override
        HashObjSetFactory<E> thisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> qHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new QHashObjSetFactoryImpl.WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }

        @Override
        HashObjSetFactory<E> lHashLikeThisWith(HashConfig hashConf, int defaultExpectedSize, boolean isNullKeyAllowed) {
            return new WithCustomEquivalence<E>(hashConf, defaultExpectedSize, isNullKeyAllowed, this.equivalence);
        }
    }
}

