/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.impl.LongArrays;
import com.koloboke.collect.impl.PrimitiveConstants;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.HashConfigWrapper;
import com.koloboke.collect.impl.hash.MutableQHash;
import com.koloboke.collect.impl.hash.ParallelKVLongQHash;
import com.koloboke.collect.impl.hash.QHash;
import java.util.ConcurrentModificationException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class MutableParallelKVLongQHashSO
extends MutableQHash
implements ParallelKVLongQHash,
PrimitiveConstants,
UnsafeConstants {
    long freeValue;
    long removedValue;
    long[] table;

    void copy(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = (long[])hash.table().clone();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    void move(ParallelKVLongQHash hash) {
        super.copy(hash);
        this.freeValue = hash.freeValue();
        if (hash.supportRemoved()) {
            this.removedValue = hash.removedValue();
        }
        this.table = hash.table();
        if (!hash.supportRemoved()) {
            this.removedValue = this.freeValue;
            this.removedValue = this.findNewFreeOrRemoved();
        }
    }

    final void init(HashConfigWrapper configWrapper, int size, long freeValue, long removedValue) {
        this.freeValue = freeValue;
        this.removedValue = removedValue;
        super.init(configWrapper, size);
    }

    @Override
    public long freeValue() {
        return this.freeValue;
    }

    @Override
    public boolean supportRemoved() {
        return true;
    }

    @Override
    public long removedValue() {
        return this.removedValue;
    }

    public boolean contains(Object key) {
        return this.contains((Long)key);
    }

    public boolean contains(long key) {
        return this.index(key) >= 0;
    }

    int index(long key) {
        long free = this.freeValue;
        if (key != free && key != this.removedValue) {
            long[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVLongKeyMixing.mix((long)key) % capacity;
            long cur = tab[index];
            if (cur == key) {
                return index;
            }
            if (cur == free) {
                return -1;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 2;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = tab[bIndex]) == key) {
                    return bIndex;
                }
                if (cur == free) {
                    return -1;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = tab[fIndex]) == key) {
                    return fIndex;
                }
                if (cur == free) {
                    return -1;
                }
                step += 4;
            }
        }
        return -1;
    }

    private long findNewFreeOrRemoved() {
        long newFree;
        long free = this.freeValue;
        long removed = this.removedValue;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while ((newFree = ((Random)random).nextLong()) == free || newFree == removed || this.index(newFree) >= 0) {
        }
        return newFree;
    }

    long changeFree() {
        int mc = this.modCount();
        long newFree = this.findNewFreeOrRemoved();
        this.incrementModCount();
        LongArrays.replaceAllKeys((long[])this.table, (long)this.freeValue, (long)newFree);
        this.freeValue = newFree;
        if (++mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newFree;
    }

    long changeRemoved() {
        int mc = this.modCount();
        long newRemoved = this.findNewFreeOrRemoved();
        this.incrementModCount();
        ++mc;
        if (!this.noRemoved()) {
            LongArrays.replaceAllKeys((long[])this.table, (long)this.removedValue, (long)newRemoved);
        }
        this.removedValue = newRemoved;
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return newRemoved;
    }

    @Override
    void allocateArrays(int capacity) {
        this.table = new long[capacity * 2];
        if (this.freeValue != 0L) {
            LongArrays.fillKeys((long[])this.table, (long)this.freeValue);
        }
    }

    @Override
    public void clear() {
        super.clear();
        LongArrays.fillKeys((long[])this.table, (long)this.freeValue);
    }

    @Override
    void removeAt(int index) {
        this.table[index] = this.removedValue;
    }
}

