/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.LongCollection;
import com.koloboke.collect.LongCursor;
import com.koloboke.collect.impl.CommonLongCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalLongCollectionOps;
import com.koloboke.collect.impl.hash.MutableLongQHashSetSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVLongQHash;
import com.koloboke.collect.set.LongSet;
import com.koloboke.collect.set.hash.HashLongSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class MutableQHashLongSetGO
extends MutableLongQHashSetSO
implements HashLongSet,
InternalLongCollectionOps {
    @Override
    final void copy(SeparateKVLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVLongQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonLongCollectionOps.containsAll((LongCollection)this, c);
    }

    @Nonnull
    public LongCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Long e) {
        return this.add((long)e);
    }

    public boolean add(long key) {
        block24: {
            long removed = this.removedValue;
            long free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != free) {
                int firstRemoved;
                if (cur == key) {
                    return false;
                }
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == free) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == free) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == key) {
                                return false;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block24;
                    }
                    if (cur == key) {
                        return false;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                this.incrementModCount();
                keys[firstRemoved] = key;
                this.postRemovedSlotInsertHook();
                return true;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postFreeSlotInsertHook();
        return true;
    }

    public boolean addAll(@Nonnull Collection<? extends Long> c) {
        return CommonLongCollectionOps.addAll((LongCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeLong((Long)key);
    }

    @Override
    boolean justRemove(long key) {
        return this.removeLong(key);
    }

    public boolean removeLong(long key) {
        long removed;
        long free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            long[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVLongKeyMixing.mix((long)key) % capacity;
            long cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        if (c instanceof LongCollection) {
            InternalLongCollectionOps c2;
            if (c instanceof InternalLongCollectionOps && (c2 = (InternalLongCollectionOps)c).size() < this.size()) {
                return c2.reverseRemoveAllFrom((LongSet)this);
            }
            return this.removeAll((HashLongSet)this, (LongCollection)c);
        }
        return this.removeAll((HashLongSet)this, c);
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

