/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.ByteCollection;
import com.koloboke.collect.ByteCursor;
import com.koloboke.collect.ByteIterator;
import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractByteValueView;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonByteByteMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalByteByteMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVByteByteMapSO;
import com.koloboke.collect.impl.hash.ParallelKVByteByteQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.ByteByteCursor;
import com.koloboke.collect.set.ByteSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.ByteBinaryOperator;
import com.koloboke.function.ByteByteConsumer;
import com.koloboke.function.ByteBytePredicate;
import com.koloboke.function.ByteByteToByteFunction;
import com.koloboke.function.ByteConsumer;
import com.koloboke.function.BytePredicate;
import com.koloboke.function.ByteUnaryOperator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashParallelKVByteByteMapGO
extends MutableQHashParallelKVByteByteMapSO {
    final void copy(ParallelKVByteByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVByteByteQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public byte defaultValue() {
        return 0;
    }

    public boolean containsEntry(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    public Byte get(Object key) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public byte get(byte key) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    public Byte getOrDefault(Object key, Byte defaultValue) {
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == k) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public byte getOrDefault(byte key, byte defaultValue) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (byte)(entry = tab[bIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (byte)(entry = tab[fIndex])) == key) {
                    return (byte)(entry >>> 8);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Byte, ? super Byte> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Byte)key, (Byte)((byte)(entry >>> 8)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((Byte)key, (Byte)((byte)(entry >>> 8)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(ByteByteConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(ByteBytePredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || predicate.test(key, (byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed || predicate.test(key, (byte)(entry >>> 8))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public ByteByteCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonByteByteMapOps.containsAllEntries((InternalByteByteMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || m.containsEntry(key, (byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed || m.containsEntry(key, (byte)(entry >>> 8))) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalByteByteMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                m.justPut(key, (byte)(entry >>> 8));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                m.justPut(key, (byte)(entry >>> 8));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Byte, Byte>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ByteCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                hashCode += key ^ (byte)(entry >>> 8);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                hashCode += key ^ (byte)(entry >>> 8);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((byte)(entry >>> 8));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
                if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)bIndex << 1)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)fIndex << 1)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
                if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)bIndex << 1)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getByte(newTab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)fIndex << 1)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Byte put(Byte key, Byte value) {
        char entry;
        int index;
        char[] tab;
        block26: {
            byte k = key;
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (char)(k & 0xFF | value << 8);
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (char)(k & 0xFF | value << 8);
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (char)(k & 0xFF | value << 8);
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (char)(k & 0xFF | value << 8);
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(k & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (char)(k & 0xFF | value << 8);
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(k & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    public byte put(byte key, byte value) {
        char entry;
        int index;
        char[] tab;
        block26: {
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = (char)(key & 0xFF | value << 8);
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = (char)(key & 0xFF | value << 8);
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = (char)(key & 0xFF | value << 8);
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = (char)(key & 0xFF | value << 8);
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        byte prevValue = (byte)(entry >>> 8);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
        return prevValue;
    }

    public Byte putIfAbsent(Byte key, Byte value) {
        int firstRemoved;
        byte k = key;
        byte removed = this.removedValue;
        byte free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        } else if (k == removed) {
            removed = this.changeRemoved();
        }
        char[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return (byte)(entry >>> 8);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = (char)(k & 0xFF | value << 8);
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return (byte)(entry >>> 8);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = (char)(k & 0xFF | value << 8);
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return (byte)(entry >>> 8);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (byte)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (char)(k & 0xFF | value << 8);
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (char)(k & 0xFF | value << 8);
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (byte)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (char)(k & 0xFF | value << 8);
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = (char)(k & 0xFF | value << 8);
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public byte putIfAbsent(byte key, byte value) {
        int firstRemoved;
        byte removed = this.removedValue;
        byte free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        } else if (key == removed) {
            removed = this.changeRemoved();
        }
        char[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
        char entry = tab[index];
        byte cur = (byte)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = (char)(key & 0xFF | value << 8);
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (byte)(entry >>> 8);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = (char)(key & 0xFF | value << 8);
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (byte)(entry >>> 8);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = (char)(key & 0xFF | value << 8);
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (byte)(entry >>> 8);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (byte)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = (char)(key & 0xFF | value << 8);
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (byte)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = (char)(key & 0xFF | value << 8);
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public void justPut(byte key, byte value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putByte(this.table, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
    }

    public Byte compute(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        char entry;
        int index;
        char[] tab;
        byte removed;
        byte k;
        block28: {
            k = key;
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                Byte newValue2;
                block29: {
                    if (cur != free) {
                        Byte newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply((Byte)k, null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = (char)(k & 0xFF | newValue3 << 8);
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply((Byte)k, null)) != null) {
                    this.incrementModCount();
                    tab[index] = (char)(k & 0xFF | newValue2 << 8);
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        this.incrementModCount();
        U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
        this.postRemoveHook();
        return null;
    }

    public byte compute(byte key, ByteByteToByteFunction remappingFunction) {
        byte newValue;
        char entry;
        int index;
        char[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = remappingFunction.applyAsByte(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | newValue2 << 8);
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsByte(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | newValue << 8);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public Byte computeIfAbsent(Byte key, Function<? super Byte, ? extends Byte> mappingFunction) {
        Byte value;
        byte k;
        block27: {
            k = key;
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == k) {
                return (byte)(entry >>> 8);
            }
            if (cur != free) {
                Byte value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == k) {
                                return (byte)(entry >>> 8);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == k) {
                                return (byte)(entry >>> 8);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                        return (byte)(entry >>> 8);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                        return (byte)(entry >>> 8);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply((Byte)k)) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = (char)(k & 0xFF | value2 << 8);
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply((Byte)k)) != null) {
            this.incrementModCount();
            tab[index] = (char)(k & 0xFF | value << 8);
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public byte computeIfAbsent(byte key, ByteUnaryOperator mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur == key) {
                return (byte)(entry >>> 8);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                return (byte)(entry >>> 8);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                return (byte)(entry >>> 8);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        return (byte)(entry >>> 8);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        return (byte)(entry >>> 8);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                byte value = mappingFunction.applyAsByte(key);
                this.incrementModCount();
                tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        byte value = mappingFunction.applyAsByte(key);
        this.incrementModCount();
        tab[index] = (char)(key & 0xFF | value << 8);
        this.postFreeSlotInsertHook();
        return value;
    }

    public Byte computeIfPresent(Byte key, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        byte removed;
        byte k = key;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (k != free && k != (removed = this.removedValue)) {
            Byte newValue;
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply((Byte)k, (Byte)((byte)(entry >>> 8)))) != null) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return newValue;
            }
            this.incrementModCount();
            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public byte computeIfPresent(byte key, ByteByteToByteFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            byte newValue = remappingFunction.applyAsByte(key, (byte)(entry >>> 8));
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Byte merge(Byte key, Byte value, BiFunction<? super Byte, ? super Byte, ? extends Byte> remappingFunction) {
        Byte newValue;
        char entry;
        int index;
        char[] tab;
        byte removed;
        block27: {
            byte k = key;
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            byte free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(k & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (char)(k & 0xFF | value << 8);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Byte)((byte)(entry >>> 8)), value)) != null) {
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
            return newValue;
        }
        this.incrementModCount();
        U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
        this.postRemoveHook();
        return null;
    }

    public byte merge(byte key, byte value, ByteBinaryOperator remappingFunction) {
        char entry;
        int index;
        char[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | value << 8);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | value << 8);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        byte newValue = remappingFunction.applyAsByte((byte)(entry >>> 8), value);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public byte addValue(byte key, byte value) {
        byte newValue;
        char entry;
        int index;
        char[] tab;
        block24: {
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = (byte)(this.defaultValue() + value);
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | newValue2 << 8);
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (byte)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | newValue << 8);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (byte)((byte)(entry >>> 8) + value);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public byte addValue(byte key, byte addition, byte initialValue) {
        byte newValue;
        char entry;
        int index;
        char[] tab;
        block24: {
            byte removed = this.removedValue;
            byte free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (byte)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (byte)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        byte newValue2 = (byte)(initialValue + addition);
                        this.incrementModCount();
                        tab[firstRemoved] = (char)(key & 0xFF | newValue2 << 8);
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (byte)(initialValue + addition);
                this.incrementModCount();
                tab[index] = (char)(key & 0xFF | newValue << 8);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (byte)((byte)(entry >>> 8) + addition);
        U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Byte, ? extends Byte> m) {
        CommonByteByteMapOps.putAll((InternalByteByteMapOps)this, m);
    }

    public Byte replace(Byte key, Byte value) {
        byte free;
        byte k = key;
        if (k != (free = this.freeValue) && k != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return null;
    }

    public byte replace(byte key, byte value) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            byte oldValue = (byte)(entry >>> 8);
            U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Byte key, Byte oldValue, Byte newValue) {
        return this.replace((byte)key, (byte)oldValue, (byte)newValue);
    }

    public boolean replace(byte key, byte oldValue, byte newValue) {
        byte free = this.freeValue;
        if (key != free && key != this.removedValue) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((byte)(entry >>> 8) == oldValue) {
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)index << 1), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Byte, ? super Byte, ? extends Byte> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.apply((Byte)key, (Byte)((byte)(entry >>> 8))));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.apply((Byte)key, (Byte)((byte)(entry >>> 8))));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(ByteByteToByteFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.applyAsByte(key, (byte)(entry >>> 8)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                U.putByte(tab, CHAR_BASE + BYTE_VALUE_OFFSET + ((long)i << 1), function.applyAsByte(key, (byte)(entry >>> 8)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Byte remove(Object key) {
        byte removed;
        byte free;
        byte k = (Byte)key;
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)k) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            byte val = (byte)(entry >>> 8);
            this.incrementModCount();
            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public byte remove(byte key) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            byte val = (byte)(entry >>> 8);
            this.incrementModCount();
            U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove((Byte)key, (Byte)value);
    }

    public boolean remove(byte key, byte value) {
        byte removed;
        byte free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVByteKeyMixing.mix((byte)key) % capacity;
            char entry = tab[index];
            byte cur = (byte)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (byte)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (byte)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((byte)(entry >>> 8) == value) {
                this.incrementModCount();
                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)index << 1), removed);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(ByteBytePredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        byte free = this.freeValue;
        byte removed = this.removedValue;
        char[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || !filter.test(key, (byte)(entry >>> 8))) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed || !filter.test(key, (byte)(entry >>> 8))) continue;
                this.incrementModCount();
                ++mc;
                U.putByte(tab, CHAR_BASE + BYTE_KEY_OFFSET + ((long)i << 1), removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements ByteByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept(key, (byte)(entry >>> 8));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte key() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public byte value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(byte value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte removed = this.removed;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free || key == removed) continue;
                        this.next = (byte)(entry >>> 8);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ByteCursor {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public byte elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ByteIterator {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        byte next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                if ((byte)entry == free) continue;
                this.next = (byte)(entry >>> 8);
                break;
            }
            this.nextIndex = nextI;
        }

        public byte nextByte() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        if ((byte)entry == free) continue;
                        this.next = (byte)(entry >>> 8);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Byte> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((Byte)((byte)(entry >>> 8)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ByteConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                if ((byte)entry == free) continue;
                action.accept((byte)(entry >>> 8));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Byte next() {
            return this.nextByte();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                byte removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            byte removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    byte removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index;
        byte curKey;
        byte curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            this.index = this.tab.length;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (index != this.index || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Byte, Byte> elem() {
            byte curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                char[] tab = this.tab;
                byte free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (byte)(entry >>> 8);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            byte free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)this.index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Byte, Byte>> {
        final char[] tab;
        final byte free;
        final byte removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVByteByteMapGO.this.table;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            byte free = this.free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                char entry = tab[nextI];
                byte key = (byte)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] tab = this.tab;
            byte free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char entry = tab[i];
                byte key = (byte)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Byte, Byte> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] tab = this.tab;
                    byte free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char entry = tab[nextI];
                        byte key = (byte)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (byte)(entry >>> 8));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
            UnsafeConstants.U.putByte(this.tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)index << 1), this.removed);
            MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractByteValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashParallelKVByteByteMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashParallelKVByteByteMapGO.this.containsValue(o);
        }

        public boolean contains(byte v) {
            return MutableQHashParallelKVByteByteMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Byte> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    action.accept((Byte)((byte)(entry >>> 8)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    action.accept((Byte)((byte)(entry >>> 8)));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ByteConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    action.accept((byte)(entry >>> 8));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    action.accept((byte)(entry >>> 8));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(BytePredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || predicate.test((byte)(entry >>> 8))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || predicate.test((byte)(entry >>> 8))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ByteCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || c.contains((byte)(entry >>> 8))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ByteCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    changed |= c.add((byte)(entry >>> 8));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((byte)(entry >>> 8));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ByteSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    changed |= s.removeByte((byte)(entry >>> 8));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeByte((byte)(entry >>> 8));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ByteIterator iterator() {
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            if (!MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ByteCursor cursor() {
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            if (!MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    result[resultIndex++] = (byte)(entry >>> 8);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (byte)(entry >>> 8);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    a[resultIndex++] = (byte)(entry >>> 8);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (byte)(entry >>> 8);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public byte[] toByteArray() {
            int size = this.size();
            byte[] result = new byte[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    result[resultIndex++] = (byte)(entry >>> 8);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (byte)(entry >>> 8);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public byte[] toArray(byte[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new byte[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    a[resultIndex++] = (byte)(entry >>> 8);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (byte)(entry >>> 8);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free) continue;
                    sb.append(' ').append((byte)(entry >>> 8)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((byte)(entry >>> 8)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeByte((Byte)o);
        }

        public boolean removeByte(byte v) {
            return MutableQHashParallelKVByteByteMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashParallelKVByteByteMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Byte> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || !filter.test((Byte)((byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !filter.test((Byte)((byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(BytePredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || !filter.test((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !filter.test((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.removeAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || !c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || !c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ByteCollection) {
                return this.retainAll((ByteCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ByteCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    if ((byte)entry == free || c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || c.contains((byte)(entry >>> 8))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends ByteByteEntry {
        private byte key;
        private byte value;

        ReusableEntry() {
        }

        ReusableEntry with(byte key, byte value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }
    }

    class MutableEntry
    extends ByteByteEntry {
        final int modCount;
        private final int index;
        final byte key;
        private byte value;

        MutableEntry(int modCount, int index, byte key, byte value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public byte key() {
            return this.key;
        }

        @Override
        public byte value() {
            return this.value;
        }

        public Byte setValue(Byte newValue) {
            byte unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            byte oldValue = this.value;
            this.value = unwrappedNewValue = newValue.byteValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(byte newValue) {
            UnsafeConstants.U.putByte(MutableQHashParallelKVByteByteMapGO.this.table, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_VALUE_OFFSET + ((long)this.index << 1), newValue);
        }
    }

    abstract class ByteByteEntry
    extends AbstractEntry<Byte, Byte> {
        ByteByteEntry() {
        }

        abstract byte key();

        public final Byte getKey() {
            return this.key();
        }

        abstract byte value();

        public final Byte getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                byte k2 = (Byte)e2.getKey();
                byte v2 = (Byte)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((byte)this.key()) ^ Primitives.hashCode((byte)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Byte, Byte>>
    implements HashObjSet<Map.Entry<Byte, Byte>>,
    InternalObjCollectionOps<Map.Entry<Byte, Byte>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Byte, Byte>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVByteByteMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashParallelKVByteByteMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashParallelKVByteByteMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVByteByteMapGO.this.containsEntry((Byte)e.getKey(), (Byte)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (byte)(entry >>> 8));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Byte, Byte>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || predicate.test((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || predicate.test((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Byte, Byte>> iterator() {
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            if (!MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Byte, Byte>> cursor() {
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            if (!MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, (byte)(entry >>> 8)));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Byte, Byte>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8)));
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashParallelKVByteByteMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((byte)(entry >>> 8));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((byte)(entry >>> 8));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVByteByteMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                byte key = (Byte)e.getKey();
                byte value = (Byte)e.getValue();
                return MutableQHashParallelKVByteByteMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Byte, Byte>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || !filter.test((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !filter.test((Map.Entry<Byte, Byte>)((Object)new MutableEntry(mc, i, key, (byte)(entry >>> 8))))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || !c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || !c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVByteByteMapGO.this.modCount();
            byte free = MutableQHashParallelKVByteByteMapGO.this.freeValue;
            byte removed = MutableQHashParallelKVByteByteMapGO.this.removedValue;
            char[] tab = MutableQHashParallelKVByteByteMapGO.this.table;
            if (MutableQHashParallelKVByteByteMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    char entry = tab[i];
                    byte key = (byte)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (byte)(entry >>> 8)))) continue;
                    MutableQHashParallelKVByteByteMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putByte(tab, UnsafeConstants.CHAR_BASE + UnsafeConstants.BYTE_KEY_OFFSET + ((long)i << 1), removed);
                    MutableQHashParallelKVByteByteMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVByteByteMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashParallelKVByteByteMapGO.this.doClear();
        }
    }
}

