/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.ShortCollection;
import com.koloboke.collect.ShortCursor;
import com.koloboke.collect.ShortIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.AbstractShortValueView;
import com.koloboke.collect.impl.CommonCharShortMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharShortMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.MutableQHashParallelKVCharShortMapSO;
import com.koloboke.collect.impl.hash.ParallelKVCharShortQHash;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.map.CharShortCursor;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.ShortSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharShortConsumer;
import com.koloboke.function.CharShortPredicate;
import com.koloboke.function.CharShortToShortFunction;
import com.koloboke.function.CharToShortFunction;
import com.koloboke.function.ShortBinaryOperator;
import com.koloboke.function.ShortConsumer;
import com.koloboke.function.ShortPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashParallelKVCharShortMapGO
extends MutableQHashParallelKVCharShortMapSO {
    final void copy(ParallelKVCharShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVCharShortQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public short defaultValue() {
        return 0;
    }

    public boolean containsEntry(char key, short value) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16) == value;
            }
            if (cur == free) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16) == value;
                }
                if (cur == free) {
                    return false;
                }
                step += 2;
            }
        }
        return false;
    }

    public Short get(Object key) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return null;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return null;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return null;
                }
                step += 2;
            }
        }
        return null;
    }

    public short get(char key) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return this.defaultValue();
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return this.defaultValue();
                }
                step += 2;
            }
        }
        return this.defaultValue();
    }

    public Short getOrDefault(Object key, Short defaultValue) {
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == k) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public short getOrDefault(char key, short defaultValue) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == free) {
                return defaultValue;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = (char)(entry = tab[bIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = (char)(entry = tab[fIndex])) == key) {
                    return (short)(entry >>> 16);
                }
                if (cur == free) {
                    return defaultValue;
                }
                step += 2;
            }
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Short> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(Character.valueOf(key), (Short)((short)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(key), (Short)((short)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharShortConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (short)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharShortPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || predicate.test(key, (short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || predicate.test(key, (short)(entry >>> 16))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharShortCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharShortMapOps.containsAllEntries((InternalCharShortMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || m.containsEntry(key, (short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || m.containsEntry(key, (short)(entry >>> 16))) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharShortMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                m.justPut(key, (short)(entry >>> 16));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                m.justPut(key, (short)(entry >>> 16));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Short>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public ShortCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                hashCode += key ^ (short)(entry >>> 16);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                hashCode += key ^ (short)(entry >>> 16);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append((short)(entry >>> 16));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        int[] newTab = this.table;
        int capacity = newTab.length;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
                if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
                if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2)) != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)bIndex << 2)) == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (U.getChar(newTab, INT_BASE + CHAR_KEY_OFFSET + ((long)fIndex << 2)) == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newTab[index] = entry;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Short put(Character key, Short value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            char k = key.charValue();
            char removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = k | value << 16;
                this.postFreeSlotInsertHook();
                return null;
            }
            if (cur != k) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = k | value << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = k | value << 16;
                                this.postFreeSlotInsertHook();
                                return null;
                            }
                            if (cur == k) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = k | value << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = k | value << 16;
                            this.postFreeSlotInsertHook();
                            return null;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value << 16;
                        this.postRemovedSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public short put(char key, short value) {
        int entry;
        int index;
        int[] tab;
        block26: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur == free) {
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postFreeSlotInsertHook();
                return this.defaultValue();
            }
            if (cur != key) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == free) {
                                this.incrementModCount();
                                tab[bIndex] = key | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = bIndex;
                                break block26;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == free) {
                                this.incrementModCount();
                                tab[fIndex] = key | value << 16;
                                this.postFreeSlotInsertHook();
                                return this.defaultValue();
                            }
                            if (cur == key) {
                                index = fIndex;
                                break block26;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[bIndex] = key | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        if (firstRemoved < 0) {
                            this.incrementModCount();
                            tab[fIndex] = key | value << 16;
                            this.postFreeSlotInsertHook();
                            return this.defaultValue();
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
            }
        }
        short prevValue = (short)(entry >>> 16);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
        return prevValue;
    }

    public Short putIfAbsent(Character key, Short value) {
        int firstRemoved;
        char k = key.charValue();
        char removed = this.removedValue;
        char free = this.freeValue;
        if (k == free) {
            free = this.changeFree();
        } else if (k == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postFreeSlotInsertHook();
            return null;
        }
        if (cur == k) {
            return (short)(entry >>> 16);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = k | value << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return (short)(entry >>> 16);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = k | value << 16;
                        this.postFreeSlotInsertHook();
                        return null;
                    }
                    if (cur == k) {
                        return (short)(entry >>> 16);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (char)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = k | value << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k | value << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (char)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = k | value << 16;
                    this.postFreeSlotInsertHook();
                    return null;
                }
                this.incrementModCount();
                tab[firstRemoved] = k | value << 16;
                this.postRemovedSlotInsertHook();
                return null;
            }
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public short putIfAbsent(char key, short value) {
        int firstRemoved;
        char removed = this.removedValue;
        char free = this.freeValue;
        if (key == free) {
            free = this.changeFree();
        } else if (key == removed) {
            removed = this.changeRemoved();
        }
        int[] tab = this.table;
        int capacity = tab.length;
        int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
        int entry = tab[index];
        char cur = (char)entry;
        if (cur == free) {
            this.incrementModCount();
            tab[index] = key | value << 16;
            this.postFreeSlotInsertHook();
            return this.defaultValue();
        }
        if (cur == key) {
            return (short)(entry >>> 16);
        }
        if (cur != removed) {
            if (this.noRemoved()) {
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == free) {
                        this.incrementModCount();
                        tab[bIndex] = key | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (short)(entry >>> 16);
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == free) {
                        this.incrementModCount();
                        tab[fIndex] = key | value << 16;
                        this.postFreeSlotInsertHook();
                        return this.defaultValue();
                    }
                    if (cur == key) {
                        return (short)(entry >>> 16);
                    }
                    step += 2;
                }
            }
            firstRemoved = -1;
        } else {
            firstRemoved = index;
        }
        int bIndex = index;
        int fIndex = index;
        int step = 1;
        while (true) {
            int t;
            if ((bIndex -= step) < 0) {
                bIndex += capacity;
            }
            if ((cur = (char)(entry = tab[bIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[bIndex] = key | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = bIndex;
            }
            if ((t = (fIndex += step) - capacity) >= 0) {
                fIndex = t;
            }
            if ((cur = (char)(entry = tab[fIndex])) == free) {
                if (firstRemoved < 0) {
                    this.incrementModCount();
                    tab[fIndex] = key | value << 16;
                    this.postFreeSlotInsertHook();
                    return this.defaultValue();
                }
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return this.defaultValue();
            }
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur == removed && firstRemoved < 0) {
                firstRemoved = fIndex;
            }
            step += 2;
        }
    }

    public void justPut(char key, short value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putShort(this.table, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
    }

    public Short compute(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int entry;
        int index;
        int[] tab;
        char removed;
        char k;
        block28: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                Short newValue2;
                block29: {
                    if (cur != free) {
                        Short newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                            this.incrementModCount();
                            tab[firstRemoved] = k | newValue3 << 16;
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    tab[index] = k | newValue2 << 16;
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), (Short)((short)(entry >>> 16)))) != null) {
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.incrementModCount();
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public short compute(char key, CharShortToShortFunction remappingFunction) {
        short newValue;
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = remappingFunction.applyAsShort(key, this.defaultValue());
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = remappingFunction.applyAsShort(key, this.defaultValue());
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public Short computeIfAbsent(Character key, Function<? super Character, ? extends Short> mappingFunction) {
        Short value;
        char k;
        block27: {
            k = key.charValue();
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == k) {
                return (short)(entry >>> 16);
            }
            if (cur != free) {
                Short value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                return (short)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                return (short)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        return (short)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        return (short)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(Character.valueOf(k))) != null) {
                    this.incrementModCount();
                    tab[firstRemoved] = k | value2 << 16;
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            tab[index] = k | value << 16;
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public short computeIfAbsent(char key, CharToShortFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur == key) {
                return (short)(entry >>> 16);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                return (short)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                return (short)(entry >>> 16);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        return (short)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        return (short)(entry >>> 16);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                short value = mappingFunction.applyAsShort(key);
                this.incrementModCount();
                tab[firstRemoved] = key | value << 16;
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        short value = mappingFunction.applyAsShort(key);
        this.incrementModCount();
        tab[index] = key | value << 16;
        this.postFreeSlotInsertHook();
        return value;
    }

    public Short computeIfPresent(Character key, BiFunction<? super Character, ? super Short, ? extends Short> remappingFunction) {
        char removed;
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (k != free && k != (removed = this.removedValue)) {
            Short newValue;
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            if ((newValue = remappingFunction.apply(Character.valueOf(k), (Short)((short)(entry >>> 16)))) != null) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return newValue;
            }
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public short computeIfPresent(char key, CharShortToShortFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short newValue = remappingFunction.applyAsShort(key, (short)(entry >>> 16));
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Short merge(Character key, Short value, BiFunction<? super Short, ? super Short, ? extends Short> remappingFunction) {
        Short newValue;
        int entry;
        int index;
        int[] tab;
        char removed;
        block27: {
            char k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = k | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = k | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Short)((short)(entry >>> 16)), value)) != null) {
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
            return newValue;
        }
        this.incrementModCount();
        U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
        this.postRemoveHook();
        return null;
    }

    public short merge(char key, short value, ShortBinaryOperator remappingFunction) {
        int entry;
        int index;
        int[] tab;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        tab[firstRemoved] = key | value << 16;
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                tab[index] = key | value << 16;
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        short newValue = remappingFunction.applyAsShort((short)(entry >>> 16), value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(char key, short value) {
        short newValue;
        int entry;
        int index;
        int[] tab;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = (short)(this.defaultValue() + value);
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (short)(this.defaultValue() + value);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (short)((short)(entry >>> 16) + value);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public short addValue(char key, short addition, short initialValue) {
        short newValue;
        int entry;
        int index;
        int[] tab;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            tab = this.table;
            int capacity = tab.length;
            index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = (char)(entry = tab[bIndex])) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = (char)(entry = tab[fIndex])) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        short newValue2 = (short)(initialValue + addition);
                        this.incrementModCount();
                        tab[firstRemoved] = key | newValue2 << 16;
                        this.postRemovedSlotInsertHook();
                        return newValue2;
                    }
                }
                newValue = (short)(initialValue + addition);
                this.incrementModCount();
                tab[index] = key | newValue << 16;
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        newValue = (short)((short)(entry >>> 16) + addition);
        U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Short> m) {
        CommonCharShortMapOps.putAll((InternalCharShortMapOps)this, m);
    }

    public Short replace(Character key, Short value) {
        char free;
        char k = key.charValue();
        if (k != (free = this.freeValue) && k != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return null;
    }

    public short replace(char key, short value) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short oldValue = (short)(entry >>> 16);
            U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Character key, Short oldValue, Short newValue) {
        return this.replace(key.charValue(), (short)oldValue, (short)newValue);
    }

    public boolean replace(char key, short oldValue, short newValue) {
        char free = this.freeValue;
        if (key != free && key != this.removedValue) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((short)(entry >>> 16) == oldValue) {
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)index << 2), newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Character, ? super Short, ? extends Short> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), (Short)((short)(entry >>> 16))));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.apply(Character.valueOf(key), (Short)((short)(entry >>> 16))));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharShortToShortFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                U.putShort(tab, INT_BASE + SHORT_VALUE_OFFSET + ((long)i << 2), function.applyAsShort(key, (short)(entry >>> 16)));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Short remove(Object key) {
        char removed;
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)k) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return val;
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public short remove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            short val = (short)(entry >>> 16);
            this.incrementModCount();
            U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), (Short)value);
    }

    public boolean remove(char key, short value) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            int[] tab = this.table;
            int capacity = tab.length;
            int index = QHash.ParallelKVCharKeyMixing.mix((char)key) % capacity;
            int entry = tab[index];
            char cur = (char)entry;
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = (char)(entry = tab[bIndex])) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = (char)(entry = tab[fIndex])) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if ((short)(entry >>> 16) == value) {
                this.incrementModCount();
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)index << 2), removed);
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharShortPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        int[] tab = this.table;
        if (this.noRemoved()) {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || !filter.test(key, (short)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = tab.length - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed || !filter.test(key, (short)(entry >>> 16))) continue;
                this.incrementModCount();
                ++mc;
                U.putChar(tab, INT_BASE + CHAR_KEY_OFFSET + ((long)i << 2), removed);
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements CharShortCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements CharShortCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept(key, (short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public short value() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(short value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putShort(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements ShortCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements ShortIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char removed = this.removed;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free || key == removed) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements ShortCursor {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public short elem() {
            if (this.curKey != this.free) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements ShortIterator {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        short next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                if ((char)entry == free) continue;
                this.next = (short)(entry >>> 16);
                break;
            }
            this.nextIndex = nextI;
        }

        public short nextShort() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    short prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        if ((char)entry == free) continue;
                        this.next = (short)(entry >>> 16);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Short> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((Short)((short)(entry >>> 16)));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(ShortConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                if ((char)entry == free) continue;
                action.accept((short)(entry >>> 16));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Short next() {
            return this.nextShort();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Short> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Short> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    char removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        short curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            this.index = this.tab.length;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (index != this.index || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Short> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int[] tab = this.tab;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (short)(entry >>> 16);
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)this.index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Short>> {
        final int[] tab;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = MutableQHashParallelKVCharShortMapGO.this.table;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            char free = this.free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            this.removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int nextI = tab.length;
            while (--nextI >= 0) {
                int entry = tab[nextI];
                char key = (char)entry;
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            int[] tab = this.tab;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                int entry = tab[i];
                char key = (char)entry;
                if (key == free) continue;
                action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
            }
            if (nextI != this.nextIndex || mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Short> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    int[] tab = this.tab;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        int entry = tab[nextI];
                        char key = (char)entry;
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, (short)(entry >>> 16));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
            UnsafeConstants.U.putChar(this.tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)index << 2), this.removed);
            MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractShortValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashParallelKVCharShortMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashParallelKVCharShortMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashParallelKVCharShortMapGO.this.containsValue(o);
        }

        public boolean contains(short v) {
            return MutableQHashParallelKVCharShortMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Short> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    action.accept((Short)((short)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept((Short)((short)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(ShortConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    action.accept((short)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept((short)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(ShortPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || predicate.test((short)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || predicate.test((short)(entry >>> 16))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(ShortCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((short)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((short)(entry >>> 16))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(ShortCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    changed |= c.add((short)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((short)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(ShortSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    changed |= s.removeShort((short)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.removeShort((short)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public ShortIterator iterator() {
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            if (!MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public ShortCursor cursor() {
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            if (!MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    result[resultIndex++] = (short)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (short)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    a[resultIndex++] = (short)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (short)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    result[resultIndex++] = (short)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = (short)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public short[] toArray(short[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new short[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    a[resultIndex++] = (short)(entry >>> 16);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = (short)(entry >>> 16);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free) continue;
                    sb.append(' ').append((short)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ').append((short)(entry >>> 16)).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeShort((Short)o);
        }

        public boolean removeShort(short v) {
            return MutableQHashParallelKVCharShortMapGO.this.removeValue(v);
        }

        public void clear() {
            MutableQHashParallelKVCharShortMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Short> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test((Short)((short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test((Short)((short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(ShortPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !filter.test((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.removeAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || !c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof ShortCollection) {
                return this.retainAll((ShortCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(ShortCollection c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    if ((char)entry == free || c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((short)(entry >>> 16))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharShortEntry {
        private char key;
        private short value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, short value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharShortEntry {
        final int modCount;
        private final int index;
        final char key;
        private short value;

        MutableEntry(int modCount, int index, char key, short value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public short value() {
            return this.value;
        }

        public Short setValue(Short newValue) {
            short unwrappedNewValue;
            if (this.modCount != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            short oldValue = this.value;
            this.value = unwrappedNewValue = newValue.shortValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(short newValue) {
            UnsafeConstants.U.putShort(MutableQHashParallelKVCharShortMapGO.this.table, UnsafeConstants.INT_BASE + UnsafeConstants.SHORT_VALUE_OFFSET + ((long)this.index << 2), newValue);
        }
    }

    abstract class CharShortEntry
    extends AbstractEntry<Character, Short> {
        CharShortEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract short value();

        public final Short getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                short v2 = (Short)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((short)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Short>>
    implements HashObjSet<Map.Entry<Character, Short>>,
    InternalObjCollectionOps<Map.Entry<Character, Short>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Short>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashParallelKVCharShortMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashParallelKVCharShortMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashParallelKVCharShortMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashParallelKVCharShortMapGO.this.containsEntry(((Character)e.getKey()).charValue(), (Short)e.getValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, (short)(entry >>> 16));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Short>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Short>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || predicate.test((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || predicate.test((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Short>> iterator() {
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            if (!MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Short>> cursor() {
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            if (!MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, (short)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Short>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16)));
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashParallelKVCharShortMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((short)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append((short)(entry >>> 16));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashParallelKVCharShortMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                short value = (Short)e.getValue();
                return MutableQHashParallelKVCharShortMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Short>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !filter.test((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !filter.test((Map.Entry<Character, Short>)((Object)new MutableEntry(mc, i, key, (short)(entry >>> 16))))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || !c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || !c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashParallelKVCharShortMapGO.this.modCount();
            char free = MutableQHashParallelKVCharShortMapGO.this.freeValue;
            char removed = MutableQHashParallelKVCharShortMapGO.this.removedValue;
            int[] tab = MutableQHashParallelKVCharShortMapGO.this.table;
            if (MutableQHashParallelKVCharShortMapGO.this.noRemoved()) {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = tab.length - 1; i >= 0; --i) {
                    int entry = tab[i];
                    char key = (char)entry;
                    if (key == free || key == removed || c.contains((Object)e.with(key, (short)(entry >>> 16)))) continue;
                    MutableQHashParallelKVCharShortMapGO.this.incrementModCount();
                    ++mc;
                    UnsafeConstants.U.putChar(tab, UnsafeConstants.INT_BASE + UnsafeConstants.CHAR_KEY_OFFSET + ((long)i << 2), removed);
                    MutableQHashParallelKVCharShortMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashParallelKVCharShortMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashParallelKVCharShortMapGO.this.doClear();
        }
    }
}

