/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.FloatIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractFloatValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonCharFloatMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalCharFloatMapOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.hash.MutableQHashSeparateKVCharFloatMapSO;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVCharFloatQHash;
import com.koloboke.collect.map.CharFloatCursor;
import com.koloboke.collect.set.FloatSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.CharFloatConsumer;
import com.koloboke.function.CharFloatPredicate;
import com.koloboke.function.CharFloatToFloatFunction;
import com.koloboke.function.CharToFloatFunction;
import com.koloboke.function.FloatBinaryOperator;
import com.koloboke.function.FloatConsumer;
import com.koloboke.function.FloatPredicate;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MutableQHashSeparateKVCharFloatMapGO
extends MutableQHashSeparateKVCharFloatMapSO {
    @Override
    final void copy(SeparateKVCharFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVCharFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public float defaultValue() {
        return 0.0f;
    }

    public boolean containsEntry(char key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == Float.floatToIntBits(value);
        }
        return false;
    }

    public boolean containsEntry(char key, int value) {
        int index = this.index(key);
        if (index >= 0) {
            return this.values[index] == value;
        }
        return false;
    }

    public Float get(Object key) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return null;
    }

    public float get(char key) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return this.defaultValue();
    }

    public Float getOrDefault(Object key, Float defaultValue) {
        int index = this.index(((Character)key).charValue());
        if (index >= 0) {
            return Float.valueOf(Float.intBitsToFloat(this.values[index]));
        }
        return defaultValue;
    }

    public float getOrDefault(char key, float defaultValue) {
        int index = this.index(key);
        if (index >= 0) {
            return Float.intBitsToFloat(this.values[index]);
        }
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Character, ? super Float> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(Character.valueOf(key), Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Character.valueOf(key), Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(CharFloatConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(CharFloatPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed || predicate.test(key, Float.intBitsToFloat(vals[i]))) continue;
                terminated = true;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public CharFloatCursor cursor() {
        int mc = this.modCount();
        if (!this.noRemoved()) {
            return new SomeRemovedMapCursor(mc);
        }
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonCharFloatMapOps.containsAllEntries((InternalCharFloatMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalCharFloatMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed || m.containsEntry(key, vals[i])) continue;
                containsAll = false;
                break;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalCharFloatMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                m.justPut(key, vals[i]);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                m.justPut(key, vals[i]);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Character, Float>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public FloatCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                hashCode += key ^ vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                hashCode += key ^ vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                sb.append(' ');
                sb.append(key);
                sb.append('=');
                sb.append(Float.intBitsToFloat(vals[i]));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        this.initForRehash(newCapacity);
        ++mc;
        char[] newKeys = this.set;
        int capacity = newKeys.length;
        int[] newVals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
                if (newKeys[index] != free) {
                    int bIndex = index;
                    int fIndex = index;
                    int step = 1;
                    while (true) {
                        if ((bIndex -= step) < 0) {
                            bIndex += capacity;
                        }
                        if (newKeys[bIndex] == free) {
                            index = bIndex;
                            break;
                        }
                        int t = (fIndex += step) - capacity;
                        if (t >= 0) {
                            fIndex = t;
                        }
                        if (newKeys[fIndex] == free) {
                            index = fIndex;
                            break;
                        }
                        step += 2;
                    }
                }
                newKeys[index] = key;
                newVals[index] = vals[i];
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Float put(Character key, Float value) {
        int index = this.insert(key.charValue(), Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value.floatValue());
        return Float.valueOf(prevValue);
    }

    public float put(char key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        int[] vals = this.values;
        float prevValue = Float.intBitsToFloat(vals[index]);
        vals[index] = Float.floatToIntBits(value);
        return prevValue;
    }

    public Float putIfAbsent(Character key, Float value) {
        int index = this.insert(key.charValue(), Float.floatToIntBits(value.floatValue()));
        if (index < 0) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(this.values[index]));
    }

    public float putIfAbsent(char key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return this.defaultValue();
        }
        return Float.intBitsToFloat(this.values[index]);
    }

    public void justPut(char key, float value) {
        int index = this.insert(key, Float.floatToIntBits(value));
        if (index < 0) {
            return;
        }
        this.values[index] = Float.floatToIntBits(value);
    }

    public void justPut(char key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        this.values[index] = value;
    }

    public Float compute(Character key, BiFunction<? super Character, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        char removed;
        char k;
        block28: {
            k = key.charValue();
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)k) % capacity;
            char cur = keys[index];
            if (cur != k) {
                Float newValue2;
                block29: {
                    if (cur != free) {
                        Float newValue3;
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block29;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block29;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block28;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block29;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        if ((newValue3 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                            this.incrementModCount();
                            keys[firstRemoved] = k;
                            vals[firstRemoved] = Float.floatToIntBits(newValue3.floatValue());
                            this.postRemovedSlotInsertHook();
                            return newValue3;
                        }
                        return null;
                    }
                }
                if ((newValue2 = remappingFunction.apply(Character.valueOf(k), null)) != null) {
                    this.incrementModCount();
                    keys[index] = k;
                    vals[index] = Float.floatToIntBits(newValue2.floatValue());
                    this.postFreeSlotInsertHook();
                    return newValue2;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Character.valueOf(k), Float.valueOf(Float.intBitsToFloat(vals[index])))) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public float compute(char key, CharFloatToFloatFunction remappingFunction) {
        int index;
        int[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Float.floatToIntBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = remappingFunction.applyAsFloat(key, this.defaultValue());
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public Float computeIfAbsent(Character key, Function<? super Character, ? extends Float> mappingFunction) {
        Float value;
        char k;
        block27: {
            k = key.charValue();
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            int[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)k) % capacity;
            char cur = keys[index];
            if (cur == k) {
                return Float.valueOf(Float.intBitsToFloat(vals[index]));
            }
            if (cur != free) {
                Float value2;
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                return Float.valueOf(Float.intBitsToFloat(vals[bIndex]));
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block27;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                return Float.valueOf(Float.intBitsToFloat(vals[fIndex]));
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block27;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        return Float.valueOf(Float.intBitsToFloat(vals[bIndex]));
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        return Float.valueOf(Float.intBitsToFloat(vals[fIndex]));
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block27;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                if ((value2 = mappingFunction.apply(Character.valueOf(k))) != null) {
                    this.incrementModCount();
                    keys[firstRemoved] = k;
                    vals[firstRemoved] = Float.floatToIntBits(value2.floatValue());
                    this.postRemovedSlotInsertHook();
                    return value2;
                }
                return null;
            }
        }
        if ((value = mappingFunction.apply(Character.valueOf(k))) != null) {
            this.incrementModCount();
            keys[index] = k;
            vals[index] = Float.floatToIntBits(value.floatValue());
            this.postFreeSlotInsertHook();
            return value;
        }
        return null;
    }

    public float computeIfAbsent(char key, CharToFloatFunction mappingFunction) {
        block25: {
            if (mappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            int[] vals = this.values;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur == key) {
                return Float.intBitsToFloat(vals[index]);
            }
            if (cur != free) {
                int firstRemoved;
                if (cur != removed) {
                    if (this.noRemoved()) {
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                return Float.intBitsToFloat(vals[bIndex]);
                            }
                            if (cur == free) {
                                index = bIndex;
                                break block25;
                            }
                            int t = (fIndex += step) - capacity;
                            if (t >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                return Float.intBitsToFloat(vals[fIndex]);
                            }
                            if (cur == free) {
                                index = fIndex;
                                break block25;
                            }
                            step += 2;
                        }
                    }
                    firstRemoved = -1;
                } else {
                    firstRemoved = index;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    int t;
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        return Float.intBitsToFloat(vals[bIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = bIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = bIndex;
                    }
                    if ((t = (fIndex += step) - capacity) >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        return Float.intBitsToFloat(vals[fIndex]);
                    }
                    if (cur == free) {
                        if (firstRemoved >= 0) break;
                        index = fIndex;
                        break block25;
                    }
                    if (cur == removed && firstRemoved < 0) {
                        firstRemoved = fIndex;
                    }
                    step += 2;
                }
                float value = mappingFunction.applyAsFloat(key);
                this.incrementModCount();
                keys[firstRemoved] = key;
                vals[firstRemoved] = Float.floatToIntBits(value);
                this.postRemovedSlotInsertHook();
                return value;
            }
        }
        float value = mappingFunction.applyAsFloat(key);
        this.incrementModCount();
        keys[index] = key;
        vals[index] = Float.floatToIntBits(value);
        this.postFreeSlotInsertHook();
        return value;
    }

    public Float computeIfPresent(Character key, BiFunction<? super Character, ? super Float, ? extends Float> remappingFunction) {
        char k = key.charValue();
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(k);
        if (index >= 0) {
            int[] vals = this.values;
            Float newValue = remappingFunction.apply(Character.valueOf(k), Float.valueOf(Float.intBitsToFloat(vals[index])));
            if (newValue != null) {
                vals[index] = Float.floatToIntBits(newValue.floatValue());
                return newValue;
            }
            this.incrementModCount();
            this.set[index] = this.removedValue;
            this.postRemoveHook();
            return null;
        }
        return null;
    }

    public float computeIfPresent(char key, CharFloatToFloatFunction remappingFunction) {
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float newValue = remappingFunction.applyAsFloat(key, Float.intBitsToFloat(vals[index]));
            vals[index] = Float.floatToIntBits(newValue);
            return newValue;
        }
        return this.defaultValue();
    }

    public Float merge(Character key, Float value, BiFunction<? super Float, ? super Float, ? extends Float> remappingFunction) {
        Float newValue;
        int index;
        int[] vals;
        char removed;
        block27: {
            char k = key.charValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            removed = this.removedValue;
            char free = this.freeValue;
            if (k == free) {
                free = this.changeFree();
            } else if (k == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)k) % capacity;
            char cur = keys[index];
            if (cur != k) {
                block28: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == k) {
                                        index = bIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block28;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == k) {
                                        index = fIndex;
                                        break block27;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block28;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == k) {
                                index = bIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == k) {
                                index = fIndex;
                                break block27;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block28;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = k;
                        vals[firstRemoved] = Float.floatToIntBits(value.floatValue());
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = k;
                vals[index] = Float.floatToIntBits(value.floatValue());
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(vals[index])), value)) != null) {
            vals[index] = Float.floatToIntBits(newValue.floatValue());
            return newValue;
        }
        this.incrementModCount();
        keys[index] = removed;
        this.postRemoveHook();
        return null;
    }

    public float merge(char key, float value, FloatBinaryOperator remappingFunction) {
        int index;
        int[] vals;
        block25: {
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                block26: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block26;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block26;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block25;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block26;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Float.floatToIntBits(value);
                        this.postRemovedSlotInsertHook();
                        return value;
                    }
                }
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(value);
                this.postFreeSlotInsertHook();
                return value;
            }
        }
        float newValue = remappingFunction.applyAsFloat(Float.intBitsToFloat(vals[index]), value);
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(char key, float value) {
        int index;
        int[] vals;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = this.defaultValue() + value;
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Float.floatToIntBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = this.defaultValue() + value;
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = Float.intBitsToFloat(vals[index]) + value;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public float addValue(char key, float addition, float initialValue) {
        int index;
        int[] vals;
        block24: {
            char removed = this.removedValue;
            char free = this.freeValue;
            if (key == free) {
                free = this.changeFree();
            } else if (key == removed) {
                removed = this.changeRemoved();
            }
            char[] keys = this.set;
            vals = this.values;
            int capacity = keys.length;
            index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                block25: {
                    if (cur != free) {
                        int firstRemoved;
                        if (cur != removed) {
                            if (this.noRemoved()) {
                                int bIndex = index;
                                int fIndex = index;
                                int step = 1;
                                while (true) {
                                    if ((bIndex -= step) < 0) {
                                        bIndex += capacity;
                                    }
                                    if ((cur = keys[bIndex]) == key) {
                                        index = bIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = bIndex;
                                        break block25;
                                    }
                                    int t = (fIndex += step) - capacity;
                                    if (t >= 0) {
                                        fIndex = t;
                                    }
                                    if ((cur = keys[fIndex]) == key) {
                                        index = fIndex;
                                        break block24;
                                    }
                                    if (cur == free) {
                                        index = fIndex;
                                        break block25;
                                    }
                                    step += 2;
                                }
                            }
                            firstRemoved = -1;
                        } else {
                            firstRemoved = index;
                        }
                        int bIndex = index;
                        int fIndex = index;
                        int step = 1;
                        while (true) {
                            int t;
                            if ((bIndex -= step) < 0) {
                                bIndex += capacity;
                            }
                            if ((cur = keys[bIndex]) == key) {
                                index = bIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = bIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = bIndex;
                            }
                            if ((t = (fIndex += step) - capacity) >= 0) {
                                fIndex = t;
                            }
                            if ((cur = keys[fIndex]) == key) {
                                index = fIndex;
                                break block24;
                            }
                            if (cur == free) {
                                if (firstRemoved >= 0) break;
                                index = fIndex;
                                break block25;
                            }
                            if (cur == removed && firstRemoved < 0) {
                                firstRemoved = fIndex;
                            }
                            step += 2;
                        }
                        float newValue = initialValue + addition;
                        this.incrementModCount();
                        keys[firstRemoved] = key;
                        vals[firstRemoved] = Float.floatToIntBits(newValue);
                        this.postRemovedSlotInsertHook();
                        return newValue;
                    }
                }
                float newValue = initialValue + addition;
                this.incrementModCount();
                keys[index] = key;
                vals[index] = Float.floatToIntBits(newValue);
                this.postFreeSlotInsertHook();
                return newValue;
            }
        }
        float newValue = Float.intBitsToFloat(vals[index]) + addition;
        vals[index] = Float.floatToIntBits(newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Character, ? extends Float> m) {
        CommonCharFloatMapOps.putAll((InternalCharFloatMapOps)this, m);
    }

    public Float replace(Character key, Float value) {
        int index = this.index(key.charValue());
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value.floatValue());
            return Float.valueOf(oldValue);
        }
        return null;
    }

    public float replace(char key, float value) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            float oldValue = Float.intBitsToFloat(vals[index]);
            vals[index] = Float.floatToIntBits(value);
            return oldValue;
        }
        return this.defaultValue();
    }

    public boolean replace(Character key, Float oldValue, Float newValue) {
        return this.replace(key.charValue(), oldValue.floatValue(), newValue.floatValue());
    }

    public boolean replace(char key, float oldValue, float newValue) {
        int index = this.index(key);
        if (index >= 0) {
            int[] vals = this.values;
            if (vals[index] == Float.floatToIntBits(oldValue)) {
                vals[index] = Float.floatToIntBits(newValue);
                return true;
            }
            return false;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Character, ? super Float, ? extends Float> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                vals[i] = Float.floatToIntBits(function.apply(Character.valueOf(key), Float.valueOf(Float.intBitsToFloat(vals[i]))).floatValue());
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = Float.floatToIntBits(function.apply(Character.valueOf(key), Float.valueOf(Float.intBitsToFloat(vals[i]))).floatValue());
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(CharFloatToFloatFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                vals[i] = Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat(vals[i])));
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                vals[i] = Float.floatToIntBits(function.applyAsFloat(key, Float.intBitsToFloat(vals[i])));
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    void removeAt(int index) {
        this.incrementModCount();
        super.removeAt(index);
        this.postRemoveHook();
    }

    public Float remove(Object key) {
        char removed;
        char free;
        char k = ((Character)key).charValue();
        if (k != (free = this.freeValue) && k != (removed = this.removedValue)) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)k) % capacity;
            char cur = keys[index];
            if (cur != k) {
                if (cur == free) {
                    return null;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == k) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == k) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return null;
                    }
                    step += 2;
                }
            }
            float val = Float.intBitsToFloat(this.values[index]);
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return Float.valueOf(val);
        }
        return null;
    }

    @Override
    public boolean justRemove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return true;
        }
        return false;
    }

    public float remove(char key) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return this.defaultValue();
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return this.defaultValue();
                    }
                    step += 2;
                }
            }
            float val = Float.intBitsToFloat(this.values[index]);
            this.incrementModCount();
            keys[index] = removed;
            this.postRemoveHook();
            return val;
        }
        return this.defaultValue();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Character)key).charValue(), ((Float)value).floatValue());
    }

    public boolean remove(char key, float value) {
        char removed;
        char free = this.freeValue;
        if (key != free && key != (removed = this.removedValue)) {
            char[] keys = this.set;
            int capacity = keys.length;
            int index = QHash.SeparateKVCharKeyMixing.mix((char)key) % capacity;
            char cur = keys[index];
            if (cur != key) {
                if (cur == free) {
                    return false;
                }
                int bIndex = index;
                int fIndex = index;
                int step = 1;
                while (true) {
                    if ((bIndex -= step) < 0) {
                        bIndex += capacity;
                    }
                    if ((cur = keys[bIndex]) == key) {
                        index = bIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    int t = (fIndex += step) - capacity;
                    if (t >= 0) {
                        fIndex = t;
                    }
                    if ((cur = keys[fIndex]) == key) {
                        index = fIndex;
                        break;
                    }
                    if (cur == free) {
                        return false;
                    }
                    step += 2;
                }
            }
            if (this.values[index] == Float.floatToIntBits(value)) {
                this.incrementModCount();
                keys[index] = removed;
                this.postRemoveHook();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeIf(CharFloatPredicate filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean changed = false;
        int mc = this.modCount();
        char free = this.freeValue;
        char removed = this.removedValue;
        char[] keys = this.set;
        int[] vals = this.values;
        if (this.noRemoved()) {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || !filter.test(key, Float.intBitsToFloat(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        } else {
            for (int i = keys.length - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed || !filter.test(key, Float.intBitsToFloat(vals[i]))) continue;
                this.incrementModCount();
                ++mc;
                keys[i] = removed;
                this.postRemoveHook();
                changed = true;
            }
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return changed;
    }

    class SomeRemovedMapCursor
    implements CharFloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        SomeRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedMapCursor
    implements CharFloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(CharFloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept(key, Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public char key() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return curKey;
            }
            throw new IllegalStateException();
        }

        public float value() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public void setValue(float value) {
            if (this.curKey != this.free) {
                if (this.expectedModCount != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.vals[this.index] = Float.floatToIntBits(value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueCursor
    implements FloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        SomeRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedValueIterator
    implements FloatIterator {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        SomeRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    char removed = this.removed;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueCursor
    implements FloatCursor {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public float elem() {
            if (this.curKey != this.free) {
                return Float.intBitsToFloat(this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedValueIterator
    implements FloatIterator {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        float next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                if (keys[nextI] == free) continue;
                this.next = Float.intBitsToFloat(vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public float nextFloat() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    float prev = this.next;
                    while (--nextI >= 0) {
                        if (keys[nextI] == free) continue;
                        this.next = Float.intBitsToFloat(this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Float> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public void forEachRemaining(FloatConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                if (keys[i] == free) continue;
                action.accept(Float.intBitsToFloat(vals[i]));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Float next() {
            return Float.valueOf(this.nextFloat());
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        SomeRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Float> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                char removed = this.removed;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class SomeRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        SomeRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free || key == removed) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            char removed = this.removed;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free || key == removed) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Float> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    char removed = this.removed;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free || key == removed) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index;
        char curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.index = this.keys.length;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            this.curKey = free;
        }

        public void forEachForward(Consumer<? super Map.Entry<Character, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (index != this.index || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = free;
        }

        public Map.Entry<Character, Float> elem() {
            char curKey = this.curKey;
            if (curKey != this.free) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                char[] keys = this.keys;
                char free = this.free;
                for (int i = this.index - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = this.vals[i];
                    return true;
                }
                this.curKey = free;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            char free = this.free;
            if (this.curKey != free) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.curKey = free;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[this.index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Character, Float>> {
        final char[] keys;
        final int[] vals;
        final char free;
        final char removed;
        int expectedModCount;
        int index = -1;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            this.vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            char free = this.free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            this.removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            int nextI = keys.length;
            while (--nextI >= 0) {
                char key = keys[nextI];
                if (key == free) continue;
                this.next = new MutableEntry(mc, nextI, key, vals[nextI]);
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Character, Float>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            char[] keys = this.keys;
            int[] vals = this.vals;
            char free = this.free;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                char key = keys[i];
                if (key == free) continue;
                action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
            }
            if (nextI != this.nextIndex || mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Character, Float> next() {
            int mc = this.expectedModCount;
            if (mc == MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    this.index = nextI;
                    char[] keys = this.keys;
                    char free = this.free;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        char key = keys[nextI];
                        if (key == free) continue;
                        this.next = new MutableEntry(mc, nextI, key, this.vals[nextI]);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            int index = this.index;
            if (index >= 0) {
                if (this.expectedModCount++ != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            this.index = -1;
            MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
            this.keys[index] = this.removed;
            MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
        }
    }

    class ValueView
    extends AbstractFloatValueView {
        ValueView() {
        }

        public int size() {
            return MutableQHashSeparateKVCharFloatMapGO.this.size();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVCharFloatMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return MutableQHashSeparateKVCharFloatMapGO.this.containsValue(o);
        }

        public boolean contains(float v) {
            return MutableQHashSeparateKVCharFloatMapGO.this.containsValue(v);
        }

        public boolean contains(int bits) {
            return MutableQHashSeparateKVCharFloatMapGO.this.containsValue(bits);
        }

        public void forEach(Consumer<? super Float> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(Float.valueOf(Float.intBitsToFloat(vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(FloatConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    action.accept(Float.intBitsToFloat(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept(Float.intBitsToFloat(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(FloatPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || predicate.test(Float.intBitsToFloat(vals[i]))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.allContainingIn((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        private boolean allContainingIn(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.reverseAddAllTo((InternalFloatCollectionOps)c);
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(Float.intBitsToFloat(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(Float.intBitsToFloat(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseAddAllTo(InternalFloatCollectionOps c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= c.add(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(FloatSet s) {
            if (s instanceof InternalFloatCollectionOps) {
                return this.reverseRemoveAllFrom((InternalFloatCollectionOps)s);
            }
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeFloat(Float.intBitsToFloat(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean reverseRemoveAllFrom(InternalFloatCollectionOps s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    changed |= s.removeFloat(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.removeFloat(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public FloatIterator iterator() {
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            if (!MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueIterator(mc);
            }
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public FloatCursor cursor() {
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            if (!MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                return new SomeRemovedValueCursor(mc);
            }
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Float.valueOf(Float.intBitsToFloat(vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    result[resultIndex++] = Float.intBitsToFloat(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = Float.intBitsToFloat(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public float[] toArray(float[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new float[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0.0f;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    a[resultIndex++] = Float.intBitsToFloat(vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = Float.intBitsToFloat(vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0.0f;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free) continue;
                    sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ').append(Float.intBitsToFloat(vals[i])).append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeFloat(((Float)o).floatValue());
        }

        public boolean removeFloat(float v) {
            return MutableQHashSeparateKVCharFloatMapGO.this.removeValue(v);
        }

        public boolean removeFloat(int bits) {
            return MutableQHashSeparateKVCharFloatMapGO.this.removeValue(bits);
        }

        public void clear() {
            MutableQHashSeparateKVCharFloatMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Float> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !filter.test(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeIf(FloatPredicate filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !filter.test(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !filter.test(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.removeAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.removeAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean removeAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !c.contains(vals[i])) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            if (c instanceof FloatCollection) {
                return this.retainAll((FloatCollection)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains(Float.valueOf(Float.intBitsToFloat(vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(FloatCollection c) {
            if (c instanceof InternalFloatCollectionOps) {
                return this.retainAll((InternalFloatCollectionOps)c);
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains(Float.intBitsToFloat(vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        private boolean retainAll(InternalFloatCollectionOps c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    if (keys[i] == free || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains(vals[i])) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }
    }

    class ReusableEntry
    extends CharFloatEntry {
        private char key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(char key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends CharFloatEntry {
        final int modCount;
        private final int index;
        final char key;
        private int value;

        MutableEntry(int modCount, int index, char key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public char key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        public Float setValue(Float newValue) {
            int unwrappedNewValue;
            if (this.modCount != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            float oldValue = Float.intBitsToFloat(this.value);
            this.value = unwrappedNewValue = Float.floatToIntBits(newValue.floatValue());
            this.updateValueInTable(unwrappedNewValue);
            return Float.valueOf(oldValue);
        }

        void updateValueInTable(int newValue) {
            MutableQHashSeparateKVCharFloatMapGO.this.values[this.index] = newValue;
        }
    }

    abstract class CharFloatEntry
    extends AbstractEntry<Character, Float> {
        CharFloatEntry() {
        }

        abstract char key();

        public final Character getKey() {
            return Character.valueOf(this.key());
        }

        abstract int value();

        public final Float getValue() {
            return Float.valueOf(Float.intBitsToFloat(this.value()));
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                char k2 = ((Character)e2.getKey()).charValue();
                int v2 = Float.floatToIntBits(((Float)e2.getValue()).floatValue());
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((char)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Character, Float>>
    implements HashObjSet<Map.Entry<Character, Float>>,
    InternalObjCollectionOps<Map.Entry<Character, Float>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Character, Float>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return MutableQHashSeparateKVCharFloatMapGO.this.hashConfig();
        }

        public int size() {
            return MutableQHashSeparateKVCharFloatMapGO.this.size;
        }

        public double currentLoad() {
            return MutableQHashSeparateKVCharFloatMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return MutableQHashSeparateKVCharFloatMapGO.this.containsEntry(((Character)e.getKey()).charValue(), ((Float)e.getValue()).floatValue());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    result[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    a[resultIndex++] = new MutableEntry(mc, i, key, vals[i]);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Character, Float>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    action.accept((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Character, Float>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || predicate.test((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || predicate.test((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    terminated = true;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Character, Float>> iterator() {
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            if (!MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryIterator(mc);
            }
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Character, Float>> cursor() {
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            if (!MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                return new SomeRemovedEntryCursor(mc);
            }
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    containsAll = false;
                    break;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= s.remove((Object)e.with(key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Character, Float>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    changed |= c.add((Object)new MutableEntry(mc, i, key, vals[i]));
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return MutableQHashSeparateKVCharFloatMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Float.intBitsToFloat(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed) continue;
                    sb.append(' ');
                    sb.append(key);
                    sb.append('=');
                    sb.append(Float.intBitsToFloat(vals[i]));
                    sb.append(',');
                    if (++elementCount != 8) continue;
                    int expectedLength = sb.length() * (this.size() / 8);
                    sb.ensureCapacity(expectedLength + expectedLength / 2);
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return MutableQHashSeparateKVCharFloatMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                char key = ((Character)e.getKey()).charValue();
                float value = ((Float)e.getValue()).floatValue();
                return MutableQHashSeparateKVCharFloatMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Character, Float>> filter) {
            if (filter == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || !filter.test((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !filter.test((Map.Entry<Character, Float>)((Object)new MutableEntry(mc, i, key, vals[i])))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty() || c.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || !c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            if (this == c) {
                throw new IllegalArgumentException();
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c.isEmpty()) {
                this.clear();
                return true;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = MutableQHashSeparateKVCharFloatMapGO.this.modCount();
            char free = MutableQHashSeparateKVCharFloatMapGO.this.freeValue;
            char removed = MutableQHashSeparateKVCharFloatMapGO.this.removedValue;
            char[] keys = MutableQHashSeparateKVCharFloatMapGO.this.set;
            int[] vals = MutableQHashSeparateKVCharFloatMapGO.this.values;
            if (MutableQHashSeparateKVCharFloatMapGO.this.noRemoved()) {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            } else {
                for (int i = keys.length - 1; i >= 0; --i) {
                    char key = keys[i];
                    if (key == free || key == removed || c.contains((Object)e.with(key, vals[i]))) continue;
                    MutableQHashSeparateKVCharFloatMapGO.this.incrementModCount();
                    ++mc;
                    keys[i] = removed;
                    MutableQHashSeparateKVCharFloatMapGO.this.postRemoveHook();
                    changed = true;
                }
            }
            if (mc != MutableQHashSeparateKVCharFloatMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public void clear() {
            MutableQHashSeparateKVCharFloatMapGO.this.doClear();
        }
    }
}

